/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.common.header;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ru.tinkoff.kora.http.common.header.AbstractHttpHeaders;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.http.common.header.MutableHttpHeaders;

public final class HttpHeadersImpl
extends AbstractHttpHeaders
implements MutableHttpHeaders {
    private final Map<String, List<String>> values;

    public HttpHeadersImpl(HttpHeaders headers) {
        if (headers.isEmpty()) {
            this.values = new LinkedHashMap<String, List<String>>();
        } else if (headers instanceof HttpHeadersImpl) {
            HttpHeadersImpl hi = (HttpHeadersImpl)headers;
            this.values = new LinkedHashMap<String, List<String>>(hi.values);
        } else {
            this.values = new LinkedHashMap<String, List<String>>(HttpHeadersImpl.calculateHashMapCapacity(headers.size()));
            for (Map.Entry e : headers) {
                this.values.put(((String)e.getKey()).toLowerCase(), new ArrayList((Collection)e.getValue()));
            }
        }
    }

    @SafeVarargs
    public HttpHeadersImpl(Map.Entry<String, List<String>> ... entries) {
        if (entries.length == 0) {
            this.values = new LinkedHashMap<String, List<String>>();
        } else {
            this.values = new LinkedHashMap<String, List<String>>(HttpHeadersImpl.calculateHashMapCapacity(entries.length));
            for (Map.Entry<String, List<String>> entry : entries) {
                String key = entry.getKey().toLowerCase();
                List<String> list = this.values.get(key);
                if (list == null) {
                    this.values.put(key, new ArrayList(entry.getValue()));
                    continue;
                }
                list.addAll((Collection<String>)entry.getValue());
            }
        }
    }

    HttpHeadersImpl(Map<String, List<String>> values) {
        this.values = values;
    }

    @Override
    @Nullable
    public String getFirst(String headerName) {
        List<String> headerValues = this.values.get(headerName.toLowerCase());
        if (headerValues == null || headerValues.isEmpty()) {
            return null;
        }
        return headerValues.get(0);
    }

    @Override
    @Nullable
    public List<String> getAll(String headerName) {
        List<String> value = this.values.get(headerName.toLowerCase());
        if (value == null) {
            return null;
        }
        return Collections.unmodifiableList(value);
    }

    @Override
    public boolean has(String headerName) {
        return this.values.containsKey(headerName.toLowerCase());
    }

    @Override
    public MutableHttpHeaders set(String key, String value) {
        Objects.requireNonNull(value);
        key = key.toLowerCase();
        ArrayList<String> valueList = new ArrayList<String>(1);
        valueList.add(value);
        this.values.put(key, valueList);
        return this;
    }

    @Override
    public MutableHttpHeaders add(String key, Collection<String> value) {
        Objects.requireNonNull(value);
        key = key.toLowerCase();
        List<String> existing = this.values.get(key);
        if (existing == null) {
            this.values.put(key, new ArrayList<String>(value));
        } else {
            existing.addAll(value);
        }
        return this;
    }

    @Override
    public MutableHttpHeaders add(String key, String value) {
        Objects.requireNonNull(value);
        key = key.toLowerCase();
        List existing = this.values.computeIfAbsent(key, k -> new ArrayList(1));
        existing.add(value);
        return this;
    }

    @Override
    public MutableHttpHeaders set(String key, Collection<String> value) {
        this.values.put(key.toLowerCase(), new ArrayList<String>(value));
        return this;
    }

    @Override
    public MutableHttpHeaders remove(String key) {
        this.values.remove(key.toLowerCase());
        return this;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Set<String> names() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    @Override
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        return this.values.entrySet().iterator();
    }

    static int calculateHashMapCapacity(int numMappings) {
        return (int)Math.ceil((double)numMappings / 0.75);
    }
}

