/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.annotation.processor;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.http.server.annotation.processor.HttpServerUtils;
import ru.tinkoff.kora.http.server.annotation.processor.RequestHandlerGenerator;
import ru.tinkoff.kora.http.server.annotation.processor.RequestMappingData;

public class ControllerModuleGenerator {
    private final Types types;
    private final Elements elements;
    private final RoundEnvironment roundEnv;
    private final RequestHandlerGenerator requestHandlerGenerator;

    public ControllerModuleGenerator(Types types, Elements elements, RoundEnvironment roundEnv, RequestHandlerGenerator requestHandlerGenerator) {
        this.types = types;
        this.elements = elements;
        this.roundEnv = roundEnv;
        this.requestHandlerGenerator = requestHandlerGenerator;
    }

    static Set<ExecutableElement> collectMethods(Set<TypeElement> interfaces) {
        return interfaces.stream().map(TypeElement::getEnclosedElements).flatMap(Collection::stream).filter(t -> t.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(e -> !e.getModifiers().contains((Object)Modifier.PRIVATE)).filter(e -> !e.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toSet());
    }

    static Set<TypeElement> collectInterfaces(Types types, TypeElement typeElement) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        ControllerModuleGenerator.collectInterfaces(types, result, typeElement);
        return result;
    }

    private static void collectInterfaces(Types types, Set<TypeElement> collectedElements, TypeElement typeElement) {
        if (collectedElements.add(typeElement)) {
            if (typeElement.asType().getKind() == TypeKind.ERROR) {
                throw new ProcessingErrorException("Element is error: %s".formatted(typeElement.toString()), (Element)typeElement);
            }
            if (typeElement.getKind() == ElementKind.CLASS && typeElement.getSuperclass() != null && !typeElement.getSuperclass().toString().equals("java.lang.Object")) {
                TypeElement parentElement = (TypeElement)types.asElement(typeElement.getSuperclass());
                ControllerModuleGenerator.collectInterfaces(types, collectedElements, parentElement);
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                TypeElement interfaceElement = (TypeElement)types.asElement(typeMirror);
                ControllerModuleGenerator.collectInterfaces(types, collectedElements, interfaceElement);
            }
        }
    }

    @Nullable
    public JavaFile generateController(TypeElement controller) {
        TypeSpec.Builder classBuilder = TypeSpec.interfaceBuilder((String)(controller.getSimpleName().toString() + "Module")).addOriginatingElement((Element)controller).addAnnotation(AnnotationUtils.generated(ControllerModuleGenerator.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(CommonClassNames.module);
        boolean error = false;
        Set<TypeElement> classes = ControllerModuleGenerator.collectInterfaces(this.types, controller);
        List<RequestMappingData> methods = ControllerModuleGenerator.collectMethods(classes).stream().map(m -> HttpServerUtils.extract(this.elements, this.types, controller, m)).filter(Objects::nonNull).toList();
        for (RequestMappingData method : methods) {
            MethodSpec generatedMethod = this.requestHandlerGenerator.generate(controller, method);
            if (generatedMethod != null) {
                classBuilder.addMethod(generatedMethod);
                continue;
            }
            error = true;
        }
        if (error) {
            return null;
        }
        PackageElement packageName = this.elements.getPackageOf(controller);
        return JavaFile.builder((String)packageName.getQualifiedName().toString(), (TypeSpec)classBuilder.build()).build();
    }
}

