/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.http.server.annotation.processor.ControllerModuleGenerator;
import ru.tinkoff.kora.http.server.annotation.processor.HttpProcessorException;
import ru.tinkoff.kora.http.server.annotation.processor.HttpServerClassNames;
import ru.tinkoff.kora.http.server.annotation.processor.RequestHandlerGenerator;

public class HttpControllerProcessor
extends AbstractKoraProcessor {
    public Set<ClassName> getSupportedAnnotationClassNames() {
        return Set.of(HttpServerClassNames.httpController);
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    public void process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Map<ClassName, List<AbstractKoraProcessor.AnnotatedElement>> annotatedElements) {
        for (AbstractKoraProcessor.AnnotatedElement controller : annotatedElements.getOrDefault(HttpServerClassNames.httpController, List.of())) {
            this.processController(controller.element(), roundEnv);
        }
    }

    private void processController(Element controller, RoundEnvironment roundEnv) {
        JavaFile file;
        RequestHandlerGenerator methodGenerator = new RequestHandlerGenerator(this.elements, this.types, this.processingEnv);
        ControllerModuleGenerator generator = new ControllerModuleGenerator(this.types, this.elements, roundEnv, methodGenerator);
        try {
            file = generator.generateController((TypeElement)controller);
        }
        catch (HttpProcessorException e) {
            e.printError(this.processingEnv);
            return;
        }
        if (file != null) {
            CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)file);
        }
    }
}

