/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.http.server.annotation.processor.HttpServerClassNames;
import ru.tinkoff.kora.http.server.annotation.processor.RequestMappingData;

public class HttpServerUtils {
    public static Interceptor parseInterceptor(AnnotationMirror a) {
        TypeMirror interceptorType = (TypeMirror)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)a, (String)"value");
        TypeName interceptorTypeName = ClassName.get((TypeMirror)Objects.requireNonNull(interceptorType));
        AnnotationMirror interceptorTag = (AnnotationMirror)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)a, (String)"tag");
        AnnotationSpec interceptorTagAnnotationSpec = interceptorTag == null ? null : AnnotationSpec.get((AnnotationMirror)interceptorTag);
        return new Interceptor(interceptorTypeName, interceptorTagAnnotationSpec);
    }

    @Nullable
    public static RequestMappingData extract(Elements elements, Types types, TypeElement controller, ExecutableElement executableElement) {
        String finalPath;
        Object controllerPath;
        AnnotationMirror controllerAnnotation = Objects.requireNonNull(AnnotationUtils.findAnnotation((Element)controller, (ClassName)HttpServerClassNames.httpController));
        ExecutableType executableType = (ExecutableType)types.asMemberOf((DeclaredType)controller.asType(), executableElement);
        for (TypeMirror typeMirror : executableType.getParameterTypes()) {
            if (typeMirror.getKind() != TypeKind.ERROR) continue;
            return null;
        }
        if (executableType.getReturnType().getKind() == TypeKind.ERROR) {
            return null;
        }
        AnnotationMirror route = AnnotationUtils.findAnnotation((Element)executableElement, (ClassName)HttpServerClassNames.httpRoute);
        if (route == null) {
            return null;
        }
        String string = Objects.requireNonNull((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)route, (String)"method"));
        Object path = Objects.requireNonNull((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)route, (String)"path"));
        if (!((String)path).isEmpty() && !((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!((String)(controllerPath = Objects.requireNonNullElse((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)controllerAnnotation, (String)"value"), "").trim())).isEmpty()) {
            if (!((String)controllerPath).startsWith("/")) {
                controllerPath = "/" + (String)controllerPath;
            }
            if (((String)controllerPath).endsWith("/")) {
                controllerPath = ((String)controllerPath).substring(0, ((String)controllerPath).length() - 1);
            }
        }
        if ((finalPath = (String)controllerPath + (String)path).isEmpty()) {
            return null;
        }
        Map<VariableElement, CommonUtils.MappingData> mappingData = executableElement.getParameters().stream().map(variableElement -> {
            CommonUtils.MappersData parameterMappings = CommonUtils.parseMapping((Element)variableElement);
            CommonUtils.MappingData mapper = parameterMappings.getMapping(HttpServerClassNames.httpServerRequestMapper);
            return new AbstractMap.SimpleImmutableEntry<VariableElement, CommonUtils.MappingData>((VariableElement)variableElement, mapper);
        }).filter(e -> e.getValue() != null).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, AbstractMap.SimpleImmutableEntry::getValue));
        CommonUtils.MappingData responseMapper = CommonUtils.parseMapping((Element)executableElement).getMapping(HttpServerClassNames.httpServerResponseMapper);
        return new RequestMappingData(executableElement, executableType, string, finalPath, mappingData, responseMapper);
    }

    public record Interceptor(TypeName type, @Nullable AnnotationSpec tag) {
    }
}

