/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.http.server.annotation.processor.HttpServerClassNames;
import ru.tinkoff.kora.http.server.annotation.processor.HttpServerUtils;
import ru.tinkoff.kora.http.server.annotation.processor.RequestMappingData;

public class RequestHandlerGenerator {
    private final Elements elements;
    private final Types types;
    private final ProcessingEnvironment processingEnvironment;
    @Nullable
    private final DeclaredType publisherTypeErasure;
    private final DeclaredType jdkPublisherTypeErasure;
    private final DeclaredType completionStageTypeErasure;

    public RequestHandlerGenerator(Elements elements, Types types, ProcessingEnvironment processingEnvironment) {
        this.elements = elements;
        this.types = types;
        this.processingEnvironment = processingEnvironment;
        this.publisherTypeErasure = RequestHandlerGenerator.dtFromString(elements, types, "org.reactivestreams.Publisher");
        this.jdkPublisherTypeErasure = Objects.requireNonNull(RequestHandlerGenerator.dtFromString(elements, types, "java.util.concurrent.Flow.Publisher"));
        this.completionStageTypeErasure = Objects.requireNonNull(RequestHandlerGenerator.dtFromString(elements, types, "java.util.concurrent.CompletionStage"));
    }

    @Nullable
    private static DeclaredType dtFromString(Elements elements, Types types, String name) {
        TypeElement te = elements.getTypeElement(name);
        if (te == null) {
            return null;
        }
        return types.getDeclaredType(te, types.getWildcardType(null, null));
    }

    @Nullable
    public MethodSpec generate(TypeElement controller, RequestMappingData requestMappingData) {
        boolean isBlocking;
        String methodName = this.methodName(requestMappingData);
        List<Parameter> parameters = this.parseParameters(requestMappingData);
        if (parameters == null) {
            return null;
        }
        Set tags = TagUtils.parseTagValue((AnnotatedConstruct)controller);
        ParameterSpec.Builder paramBuilder = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)controller.asType()), (String)"_controller", (Modifier[])new Modifier[0]);
        if (!tags.isEmpty()) {
            paramBuilder.addAnnotation(TagUtils.makeAnnotationSpec((Set)tags));
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)HttpServerClassNames.httpServerRequestHandler).addParameter(paramBuilder.build());
        if (!tags.isEmpty()) {
            methodBuilder.addAnnotation(TagUtils.makeAnnotationSpec((Set)tags));
        }
        this.addParameterMappers(methodBuilder, requestMappingData, parameters);
        ParameterSpec responseMapper = this.detectResponseMapper(requestMappingData, requestMappingData.executableElement());
        if (responseMapper != null) {
            methodBuilder.addParameter(responseMapper);
        }
        if (isBlocking = this.isBlocking(requestMappingData)) {
            methodBuilder.addParameter((TypeName)HttpServerClassNames.blockingRequestExecutor, "_executor", new Modifier[0]);
        }
        CodeBlock handlerCode = this.buildRequestHandler(controller, requestMappingData, parameters, methodBuilder);
        methodBuilder.addCode("return $T.of($S, $S, (_ctx, _request) -> {$>\n$L\n$<});", new Object[]{HttpServerClassNames.httpServerRequestHandlerImpl, requestMappingData.httpMethod().toUpperCase(), requestMappingData.route(), handlerCode});
        return methodBuilder.build();
    }

    private CodeBlock buildRequestHandler(TypeElement controller, RequestMappingData requestMappingData, List<Parameter> parameters, MethodSpec.Builder methodBuilder) {
        CodeBlock.Builder handler = CodeBlock.builder();
        TypeMirror returnType = requestMappingData.executableType().getReturnType();
        boolean hasNonBodyParams = false;
        List<HttpServerUtils.Interceptor> interceptors = Stream.concat(AnnotationUtils.findAnnotations((Element)controller, (ClassName)HttpServerClassNames.interceptWithClassName, (ClassName)HttpServerClassNames.interceptWithContainerClassName).stream().map(HttpServerUtils::parseInterceptor), AnnotationUtils.findAnnotations((Element)requestMappingData.executableElement(), (ClassName)HttpServerClassNames.interceptWithClassName, (ClassName)HttpServerClassNames.interceptWithContainerClassName).stream().map(HttpServerUtils::parseInterceptor)).distinct().toList();
        CodeBlock.Builder requestMappingBlock = CodeBlock.builder();
        Object requestName = "_request";
        for (int i = 0; i < interceptors.size(); ++i) {
            HttpServerUtils.Interceptor interceptor = interceptors.get(i);
            String interceptorName = "_interceptor" + (i + 1);
            String newRequestName = "_request" + (i + 1);
            String ctxName = "_ctx_" + (i + 1);
            requestMappingBlock.beginControlFlow("try", new Object[0]).add("return ", new Object[0]);
            requestMappingBlock.add("$L.intercept(_ctx, $L, ($N, $N) -> $>{\n", new Object[]{interceptorName, requestName, ctxName, newRequestName});
            requestName = newRequestName;
            ParameterSpec.Builder builder = ParameterSpec.builder((TypeName)interceptor.type(), (String)interceptorName, (Modifier[])new Modifier[0]);
            if (interceptor.tag() != null) {
                builder.addAnnotation(interceptor.tag());
            }
            methodBuilder.addParameter(builder.build());
        }
        handler.add(requestMappingBlock.build());
        for (Parameter parameter : parameters) {
            switch (parameter.parameterType) {
                case PATH: 
                case QUERY: 
                case HEADER: 
                case COOKIE: {
                    handler.addStatement("final $T $N", new Object[]{parameter.type, parameter.variableElement.getSimpleName()});
                    hasNonBodyParams = true;
                    break;
                }
                case REQUEST: {
                    handler.add("var $N = _request;\n", new Object[]{parameter.name()});
                    break;
                }
                case CONTEXT: {
                    handler.add("var $N = _ctx;\n", new Object[]{parameter.name()});
                    break;
                }
            }
        }
        if (hasNonBodyParams) {
            handler.beginControlFlow("try", new Object[0]);
        }
        for (Parameter parameter : parameters) {
            CodeBlock codeBlock = switch (parameter.parameterType) {
                default -> throw new IncompatibleClassChangeError();
                case ParameterType.PATH -> this.definePathParameter(parameter, methodBuilder);
                case ParameterType.QUERY -> this.defineQueryParameter(parameter, methodBuilder);
                case ParameterType.HEADER -> this.defineHeaderParameter(parameter, methodBuilder);
                case ParameterType.COOKIE -> this.defineCookieParameter(parameter, methodBuilder);
                case ParameterType.REQUEST, ParameterType.CONTEXT, ParameterType.MAPPED_HTTP_REQUEST -> CodeBlock.of((String)"", (Object[])new Object[0]);
            };
            handler.add(codeBlock);
            handler.add("\n", new Object[0]);
        }
        if (hasNonBodyParams) {
            handler.nextControlFlow("catch (Exception _e)", new Object[0]);
            handler.beginControlFlow("if (_e instanceof $T)", new Object[]{HttpServerClassNames.httpServerResponse});
            handler.addStatement("return $T.failedFuture(_e)", new Object[]{CompletableFuture.class});
            handler.nextControlFlow("else", new Object[0]);
            handler.addStatement("return $T.failedFuture($T.of(400, _e))", new Object[]{CompletableFuture.class, HttpServerClassNames.httpServerResponseException});
            handler.endControlFlow();
            handler.endControlFlow();
            handler.add("\n", new Object[0]);
        }
        CodeBlock controllerCall = CommonUtils.isMono((TypeMirror)returnType) ? this.generateMonoCall(requestMappingData, parameters, (String)requestName) : (CommonUtils.isFuture((TypeMirror)returnType) ? this.generateFutureCall(requestMappingData, parameters, (String)requestName) : this.generateBlockingCall(requestMappingData, parameters, (String)requestName));
        handler.add(controllerCall);
        for (int i = 0; i < interceptors.size(); ++i) {
            handler.addStatement("$<})", new Object[0]);
            handler.nextControlFlow("catch (Exception _e)", new Object[0]).addStatement("return $T.failedFuture(_e)", new Object[]{CompletableFuture.class}).endControlFlow();
        }
        return handler.build();
    }

    private CodeBlock generateMonoCall(RequestMappingData requestMappingData, List<Parameter> parameters, String requestName) {
        String executeParameters = parameters.stream().map(_p -> _p.variableElement.getSimpleName()).collect(Collectors.joining(", "));
        List<Parameter> mappedParameters = parameters.stream().filter(p -> p.parameterType == ParameterType.MAPPED_HTTP_REQUEST).toList();
        CodeBlock.Builder b = CodeBlock.builder();
        for (Parameter mappedParameter : mappedParameters) {
            b.addStatement("final $T $N", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)mappedParameter.type)}), "_future_" + mappedParameter.name});
            b.beginControlFlow("try", new Object[0]);
            b.addStatement("$N = $LHttpRequestMapper.apply($L).toCompletableFuture()", new Object[]{"_future_" + mappedParameter.name, mappedParameter.name, requestName});
            b.nextControlFlow("catch ($T _e)", new Object[]{CompletionException.class});
            b.addStatement("if (_e.getCause() instanceof $T && _e.getCause() instanceof $T) throw ($T) _e.getCause()", new Object[]{HttpServerClassNames.httpServerResponse, RuntimeException.class, RuntimeException.class});
            b.addStatement("throw $T.of(400, _e.getCause())", new Object[]{HttpServerClassNames.httpServerResponseException});
            b.nextControlFlow("catch (Exception _e)", new Object[0]);
            b.addStatement("if (_e instanceof $T) return $T.failedFuture(_e)", new Object[]{HttpServerClassNames.httpServerResponse, CompletableFuture.class});
            b.addStatement("return $T.failedFuture($T.of(400, _e))", new Object[]{CompletableFuture.class, HttpServerClassNames.httpServerResponseException});
            b.endControlFlow();
        }
        if (!mappedParameters.isEmpty()) {
            b.add("return $T.allOf(", new Object[]{CompletableFuture.class});
            for (int i = 0; i < mappedParameters.size(); ++i) {
                if (i > 0) {
                    b.add(", ", new Object[0]);
                }
                b.add("$N", new Object[]{"_future_" + mappedParameters.get((int)i).name});
            }
            b.add(").thenCompose(_unused_ -> {$>\n", new Object[0]);
            for (Parameter mappedParameter : mappedParameters) {
                b.addStatement("final $T $N", new Object[]{mappedParameter.type, mappedParameter.name});
                b.beginControlFlow("try", new Object[0]);
                b.addStatement("$N = $N.getNow(null)", new Object[]{mappedParameter.name, "_future_" + mappedParameter.name});
                b.nextControlFlow("catch ($T _e)", new Object[]{CompletionException.class});
                b.addStatement("if (_e.getCause() instanceof $T) return $T.failedFuture(_e)", new Object[]{HttpServerClassNames.httpServerResponse, CompletableFuture.class});
                b.addStatement("return $T.failedFuture($T.of(400, _e.getCause()))", new Object[]{CompletableFuture.class, HttpServerClassNames.httpServerResponseException});
                b.endControlFlow();
            }
        }
        b.addStatement("var oldCtx = $T.current()", new Object[]{CommonClassNames.context});
        b.addStatement("_ctx.inject()", new Object[0]);
        b.beginControlFlow("try", new Object[0]);
        DeclaredType returnType = (DeclaredType)requestMappingData.executableType().getReturnType();
        if (returnType.getTypeArguments().get(0).toString().equals("java.lang.Void")) {
            b.add("return _controller.$N($L).contextWrite(_rctx -> $T.inject(_rctx, _ctx)).toFuture()\n", new Object[]{requestMappingData.executableElement().getSimpleName(), executeParameters, CommonClassNames.context.nestedClass("Reactor")});
            b.add("  .thenApply(__unused_ -> $T.of(200));\n", new Object[]{HttpServerClassNames.httpServerResponse});
        } else if (returnType.getTypeArguments().get(0).toString().equals(HttpServerClassNames.httpServerResponse.canonicalName())) {
            b.add("return _controller.$N($L).contextWrite(_rctx -> $T.inject(_rctx, _ctx)).toFuture();\n", new Object[]{requestMappingData.executableElement().getSimpleName(), executeParameters, CommonClassNames.context.nestedClass("Reactor")});
        } else {
            b.add("return _controller.$N($L).contextWrite(_rctx -> $T.inject(_rctx, _ctx)).toFuture()$>\n", new Object[]{requestMappingData.executableElement().getSimpleName(), executeParameters, CommonClassNames.context.nestedClass("Reactor")});
            b.add(".thenApply(_result -> {$>\n", new Object[0]);
            b.add("try {\n", new Object[0]);
            b.add("  return _responseMapper.apply(_ctx, _request, _result);\n", new Object[0]);
            b.add("} catch (Exception e) {\n", new Object[0]);
            b.add("  throw new $T(e);\n", new Object[]{CompletionException.class});
            b.add("}", new Object[0]);
            b.add("$<$<\n});\n", new Object[0]);
        }
        b.nextControlFlow("catch (Exception e)", new Object[0]);
        b.addStatement("return $T.failedFuture(e)", new Object[]{CompletableFuture.class});
        b.nextControlFlow("finally", new Object[0]);
        b.addStatement("oldCtx.inject()", new Object[0]);
        b.endControlFlow();
        if (!mappedParameters.isEmpty()) {
            b.add("$<\n});\n", new Object[0]);
        }
        return b.build();
    }

    private CodeBlock generateFutureCall(RequestMappingData requestMappingData, List<Parameter> parameters, String requestName) {
        String executeParameters = parameters.stream().map(_p -> _p.variableElement.getSimpleName()).collect(Collectors.joining(", "));
        List<Parameter> mappedParameters = parameters.stream().filter(p -> p.parameterType == ParameterType.MAPPED_HTTP_REQUEST).toList();
        CodeBlock.Builder b = CodeBlock.builder();
        for (Parameter mappedParameter : mappedParameters) {
            b.addStatement("final $T $N", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)mappedParameter.type)}), "_future_" + mappedParameter.name});
            b.beginControlFlow("try", new Object[0]);
            b.addStatement("$N = $LHttpRequestMapper.apply($L).toCompletableFuture()", new Object[]{"_future_" + mappedParameter.name, mappedParameter.name, requestName});
            b.nextControlFlow("catch ($T _e)", new Object[]{CompletionException.class});
            b.addStatement("if (_e.getCause() instanceof $T && _e.getCause() instanceof $T) throw ($T) _e.getCause()", new Object[]{HttpServerClassNames.httpServerResponse, RuntimeException.class, RuntimeException.class});
            b.addStatement("throw $T.of(400, _e.getCause())", new Object[]{HttpServerClassNames.httpServerResponseException});
            b.nextControlFlow("catch (Exception _e)", new Object[0]);
            b.addStatement("if (_e instanceof $T) return $T.failedFuture(_e)", new Object[]{HttpServerClassNames.httpServerResponse, CompletableFuture.class});
            b.addStatement("return $T.failedFuture($T.of(400, _e))", new Object[]{CompletableFuture.class, HttpServerClassNames.httpServerResponseException});
            b.endControlFlow();
        }
        if (!mappedParameters.isEmpty()) {
            b.add("return $T.allOf(", new Object[]{CompletableFuture.class});
            for (int i = 0; i < mappedParameters.size(); ++i) {
                if (i > 0) {
                    b.add(", ", new Object[0]);
                }
                b.add("$N", new Object[]{"_future_" + mappedParameters.get((int)i).name});
            }
            b.add(").thenCompose(_unused_ -> {$>\n", new Object[0]);
            for (Parameter mappedParameter : mappedParameters) {
                b.addStatement("final $T $N", new Object[]{mappedParameter.type, mappedParameter.name});
                b.beginControlFlow("try", new Object[0]);
                b.addStatement("$N = $N.getNow(null)", new Object[]{mappedParameter.name, "_future_" + mappedParameter.name});
                b.nextControlFlow("catch ($T _e)", new Object[]{CompletionException.class});
                b.addStatement("if (_e.getCause() instanceof $T) return $T.failedFuture(_e)", new Object[]{HttpServerClassNames.httpServerResponse, CompletableFuture.class});
                b.addStatement("return $T.failedFuture($T.of(400, _e.getCause()))", new Object[]{CompletableFuture.class, HttpServerClassNames.httpServerResponseException});
                b.endControlFlow();
            }
        }
        b.addStatement("var oldCtx = $T.current()", new Object[]{CommonClassNames.context});
        b.addStatement("_ctx.inject()", new Object[0]);
        b.beginControlFlow("try", new Object[0]);
        DeclaredType returnType = (DeclaredType)requestMappingData.executableType().getReturnType();
        if (returnType.getTypeArguments().get(0).toString().equals("java.lang.Void")) {
            b.add("return _controller.$N($L)\n", new Object[]{requestMappingData.executableElement().getSimpleName(), executeParameters});
            b.add("  .thenApply(__unused_ -> $T.of(200));\n", new Object[]{HttpServerClassNames.httpServerResponse});
        } else if (returnType.getTypeArguments().get(0).toString().equals(HttpServerClassNames.httpServerResponse.canonicalName())) {
            b.add("return _controller.$N($L);\n", new Object[]{requestMappingData.executableElement().getSimpleName(), executeParameters});
        } else {
            b.add("return _controller.$N($L)$>\n", new Object[]{requestMappingData.executableElement().getSimpleName(), executeParameters});
            b.add(".thenApply(_result -> {$>\n", new Object[0]);
            b.add("try {\n", new Object[0]);
            b.add("  return _responseMapper.apply(_ctx, _request, _result);\n", new Object[0]);
            b.add("} catch (Exception e) {\n", new Object[0]);
            b.add("  throw new $T(e);\n", new Object[]{CompletionException.class});
            b.add("}", new Object[0]);
            b.add("$<$<\n});\n", new Object[0]);
        }
        b.nextControlFlow("catch (Exception e)", new Object[0]);
        b.addStatement("return $T.failedFuture(e)", new Object[]{CompletableFuture.class});
        b.nextControlFlow("finally", new Object[0]);
        b.addStatement("oldCtx.inject()", new Object[0]);
        b.endControlFlow();
        if (!mappedParameters.isEmpty()) {
            b.add("$<\n});\n", new Object[0]);
        }
        return b.build();
    }

    private CodeBlock generateBlockingCall(RequestMappingData requestMappingData, List<Parameter> parameters, String requestName) {
        String executeParameters = parameters.stream().map(_p -> _p.variableElement.getSimpleName()).collect(Collectors.joining(", "));
        List<Parameter> mappedParameters = parameters.stream().filter(p -> p.parameterType == ParameterType.MAPPED_HTTP_REQUEST).toList();
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("return _executor.execute(_ctx, () -> {$>\n", new Object[0]);
        for (Parameter mappedParameter : mappedParameters) {
            b.addStatement("final $T $N", new Object[]{TypeName.get((TypeMirror)mappedParameter.type), mappedParameter.name});
            b.beginControlFlow("try", new Object[0]);
            b.addStatement("$N = $LHttpRequestMapper.apply($L)", new Object[]{mappedParameter.name, mappedParameter.name, requestName});
            b.nextControlFlow("catch ($T _e)", new Object[]{CompletionException.class});
            b.addStatement("if (_e.getCause() instanceof $T && _e.getCause() instanceof $T) throw ($T) _e.getCause()", new Object[]{HttpServerClassNames.httpServerResponse, RuntimeException.class, RuntimeException.class});
            b.addStatement("throw $T.of(400, _e.getCause())", new Object[]{HttpServerClassNames.httpServerResponseException});
            b.nextControlFlow("catch (Exception _e)", new Object[0]);
            b.addStatement("if (_e instanceof $T) throw _e", new Object[]{HttpServerClassNames.httpServerResponse});
            b.addStatement("throw $T.of(400, _e)", new Object[]{HttpServerClassNames.httpServerResponseException});
            b.endControlFlow();
        }
        if (CommonUtils.isVoid((TypeMirror)requestMappingData.executableType().getReturnType())) {
            b.addStatement("_controller.$N($L)", new Object[]{requestMappingData.executableElement().getSimpleName(), executeParameters});
            b.add("return $T.of(200);", new Object[]{HttpServerClassNames.httpServerResponse});
        } else if (HttpServerClassNames.httpServerResponse.canonicalName().equals(requestMappingData.executableElement().getReturnType().toString())) {
            b.add("return _controller.$N($L);", new Object[]{requestMappingData.executableElement().getSimpleName(), executeParameters});
        } else {
            b.addStatement("var _result = _controller.$N($L)", new Object[]{requestMappingData.executableElement().getSimpleName(), executeParameters});
            b.add("return _responseMapper.apply(_ctx, _request, _result);", new Object[0]);
        }
        b.add("$<\n});", new Object[0]);
        return b.build();
    }

    private CodeBlock definePathParameter(Parameter parameter, MethodSpec.Builder methodBuilder) {
        String typeString;
        CodeBlock.Builder code = CodeBlock.builder();
        switch (typeString = TypeName.get((TypeMirror)parameter.type).withoutAnnotations().toString()) {
            case "java.lang.Boolean": 
            case "boolean": {
                code.add("$L = $T.parseBooleanPathParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.lang.Integer": 
            case "int": {
                code.add("$L = $T.parseIntegerPathParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.lang.Long": 
            case "long": {
                code.add("$L = $T.parseLongPathParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.lang.Double": 
            case "double": {
                code.add("$L = $T.parseDoublePathParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.lang.String": {
                code.add("$L = $T.parseStringPathParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.UUID": {
                code.add("$L = $T.parseUUIDPathParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            default: {
                ParameterizedTypeName parameterReaderType = ParameterizedTypeName.get((ClassName)HttpServerClassNames.stringParameterReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)parameter.type)});
                String parameterReaderName = "_" + parameter.variableElement.getSimpleName().toString() + "Reader";
                methodBuilder.addParameter((TypeName)parameterReaderType, parameterReaderName, new Modifier[0]);
                code.add("$L = $L.read($T.parseStringPathParameter(_request, $S));", new Object[]{parameter.variableElement, parameterReaderName, HttpServerClassNames.requestHandlerUtils, parameter.name});
                return code.build();
            }
        }
        return code.build();
    }

    private CodeBlock defineHeaderParameter(Parameter parameter, MethodSpec.Builder methodBuilder) {
        String typeString;
        CodeBlock.Builder code = CodeBlock.builder();
        switch (typeString = TypeName.get((TypeMirror)parameter.type).withoutAnnotations().toString()) {
            case "java.lang.String": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalStringHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseStringHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<java.lang.String>": {
                code.add("$L = $T.ofNullable($T.parseOptionalStringHeaderParameter(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.List<java.lang.String>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalStringListHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseStringListHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Set<java.lang.String>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalStringSetHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseStringSetHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "int": {
                code.add("$L = $T.parseIntegerHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<java.lang.Integer>": {
                code.add("$L = $T.ofNullable($T.parseOptionalIntegerHeaderParameter(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.lang.Integer": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalIntegerHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseIntegerHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.List<java.lang.Integer>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalIntegerListHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseIntegerListHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Set<java.lang.Integer>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalIntegerSetHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseIntegerSetHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "long": {
                code.add("$L = $T.parseLongHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<java.lang.Long>": {
                code.add("$L = $T.ofNullable($T.parseOptionalLongHeaderParameter(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.lang.Long": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalLongHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseLongHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.List<java.lang.Long>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalLongListHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseLongListHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Set<java.lang.Long>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalLongSetHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseLongSetHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "double": {
                code.add("$L = $T.parseDoubleHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<java.lang.Double>": {
                code.add("$L = $T.ofNullable($T.parseOptionalDoubleHeaderParameter(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.lang.Double": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalDoubleHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseDoubleHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.List<java.lang.Double>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalDoubleListHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseDoubleListHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Set<java.lang.Double>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalDoubleSetHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseDoubleSetHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<java.util.UUID>": {
                code.add("$L = $T.ofNullable($T.parseOptionalUuidHeaderParameter(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.UUID": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalUuidHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseUuidHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.List<java.util.UUID>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalUuidListHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseUuidListHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Set<java.util.UUID>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalUuidSetHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseUuidSetHeaderParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            default: {
                if (CommonUtils.isOptional((TypeMirror)parameter.type)) {
                    TypeMirror optionalParameter = ((DeclaredType)parameter.type).getTypeArguments().get(0);
                    ParameterizedTypeName parameterReaderType = ParameterizedTypeName.get((ClassName)HttpServerClassNames.stringParameterReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)optionalParameter)});
                    String parameterReaderName = "_" + parameter.variableElement.getSimpleName().toString() + "Reader";
                    methodBuilder.addParameter((TypeName)parameterReaderType, parameterReaderName, new Modifier[0]);
                    code.add("$L = $T.ofNullable($T.parseOptionalStringHeaderParameter(_request, $S)).map($L::read);", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name, parameterReaderName});
                    return code.build();
                }
                if (CommonUtils.isList((TypeMirror)parameter.type)) {
                    TypeMirror listParameter = ((DeclaredType)parameter.type).getTypeArguments().get(0);
                    ParameterizedTypeName parameterReaderType = ParameterizedTypeName.get((ClassName)HttpServerClassNames.stringParameterReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)listParameter)});
                    String parameterReaderName = "_" + parameter.name + "Reader";
                    methodBuilder.addParameter((TypeName)parameterReaderType, parameterReaderName, new Modifier[0]);
                    if (this.isNullable(parameter)) {
                        code.add("$L = $T.parseOptionalSomeListHeaderParameter(_request, $S, $L);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name, parameterReaderName});
                    } else {
                        code.add("$L = $T.parseSomeListHeaderParameter(_request, $S, $L);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name, parameterReaderName});
                    }
                    return code.build();
                }
                if (CommonUtils.isSet((TypeMirror)parameter.type)) {
                    TypeMirror listParameter = ((DeclaredType)parameter.type).getTypeArguments().get(0);
                    ParameterizedTypeName parameterReaderType = ParameterizedTypeName.get((ClassName)HttpServerClassNames.stringParameterReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)listParameter)});
                    String parameterReaderName = "_" + parameter.name + "Reader";
                    methodBuilder.addParameter((TypeName)parameterReaderType, parameterReaderName, new Modifier[0]);
                    if (this.isNullable(parameter)) {
                        code.add("$L = $T.parseOptionalSomeSetHeaderParameter(_request, $S, $L);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name, parameterReaderName});
                    } else {
                        code.add("$L = $T.parseSomeSetHeaderParameter(_request, $S, $L);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name, parameterReaderName});
                    }
                    return code.build();
                }
                ParameterizedTypeName parameterReaderType = ParameterizedTypeName.get((ClassName)HttpServerClassNames.stringParameterReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)parameter.type)});
                String parameterReaderName = "_" + String.valueOf(parameter.variableElement.getSimpleName()) + "Reader";
                methodBuilder.addParameter((TypeName)parameterReaderType, parameterReaderName, new Modifier[0]);
                if (this.isNullable(parameter)) {
                    String transitParameterName = "_" + String.valueOf(parameter.variableElement.getSimpleName()) + "RawValue";
                    code.add("var $N = $T.parseOptionalStringHeaderParameter(_request, $S);\n", new Object[]{transitParameterName, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    code.add("$L = $L == null ? null : $L.read($L);", new Object[]{parameter.variableElement, transitParameterName, parameterReaderName, transitParameterName});
                } else {
                    code.add("$L = $L.read($T.parseStringHeaderParameter(_request, $S));", new Object[]{parameter.variableElement, parameterReaderName, HttpServerClassNames.requestHandlerUtils, parameter.name});
                }
                return code.build();
            }
        }
        return code.build();
    }

    private CodeBlock defineCookieParameter(Parameter parameter, MethodSpec.Builder methodBuilder) {
        String typeString;
        CodeBlock.Builder code = CodeBlock.builder();
        switch (typeString = TypeName.get((TypeMirror)parameter.type).withoutAnnotations().toString()) {
            case "java.lang.String": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalCookieString(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseCookieString(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "ru.tinkoff.kora.http.common.cookie.Cookie": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalCookie(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseCookie(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<java.lang.String>": {
                code.add("$L = $T.ofNullable($T.parseOptionalCookieString(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<ru.tinkoff.kora.http.common.cookie.Cookie>": {
                code.add("$L = $T.ofNullable($T.parseOptionalCookie(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            default: {
                if (CommonUtils.isOptional((TypeMirror)parameter.type)) {
                    TypeMirror optionalParameter = ((DeclaredType)parameter.type).getTypeArguments().get(0);
                    ParameterizedTypeName parameterReaderType = ParameterizedTypeName.get((ClassName)HttpServerClassNames.stringParameterReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)optionalParameter)});
                    String parameterReaderName = "_" + parameter.variableElement.getSimpleName().toString() + "Reader";
                    methodBuilder.addParameter((TypeName)parameterReaderType, parameterReaderName, new Modifier[0]);
                    code.add("var $L_cookie = $T.parseOptionalCookieString(_request, $S);\n", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    code.add("$L = $T.ofNullable($L_cookie).map($L::read);", new Object[]{parameter.variableElement, Optional.class, parameter.variableElement, parameterReaderName});
                    return code.build();
                }
                ParameterizedTypeName parameterReaderType = ParameterizedTypeName.get((ClassName)HttpServerClassNames.stringParameterReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)parameter.type).box()});
                String parameterReaderName = "_" + String.valueOf(parameter.variableElement.getSimpleName()) + "Reader";
                methodBuilder.addParameter((TypeName)parameterReaderType, parameterReaderName, new Modifier[0]);
                if (this.isNullable(parameter)) {
                    String transitParameterName = "_" + String.valueOf(parameter.variableElement.getSimpleName()) + "RawValue";
                    code.add("var $N = $T.parseOptionalCookieString(_request, $S);\n", new Object[]{transitParameterName, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    code.add("$L = $L == null ? null : $L.read($L);", new Object[]{parameter.variableElement, transitParameterName, parameterReaderName, transitParameterName});
                } else {
                    code.add("$L = $L.read($T.parseCookieString(_request, $S));", new Object[]{parameter.variableElement, parameterReaderName, HttpServerClassNames.requestHandlerUtils, parameter.name});
                }
                return code.build();
            }
        }
        return code.build();
    }

    private CodeBlock defineQueryParameter(Parameter parameter, MethodSpec.Builder methodBuilder) {
        String typeString;
        CodeBlock.Builder code = CodeBlock.builder();
        switch (typeString = TypeName.get((TypeMirror)parameter.type).withoutAnnotations().toString()) {
            case "java.util.UUID": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalUuidQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseUuidQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<java.util.UUID>": {
                code.add("$L = $T.ofNullable($T.parseOptionalUuidQueryParameter(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.List<java.util.UUID>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalUuidListQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseUuidListQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Set<java.util.UUID>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalUuidSetQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseUuidSetQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "int": {
                code.add("$L = $T.parseIntegerQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<java.lang.Integer>": {
                code.add("$L = $T.ofNullable($T.parseOptionalIntegerQueryParameter(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.lang.Integer": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalIntegerQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseIntegerQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.List<java.lang.Integer>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalIntegerListQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseIntegerListQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Set<java.lang.Integer>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalIntegerSetQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseIntegerSetQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "long": {
                code.add("$L = $T.parseLongQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<java.lang.Long>": {
                code.add("$L = $T.ofNullable($T.parseOptionalLongQueryParameter(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.lang.Long": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalLongQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseLongQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.List<java.lang.Long>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalLongListQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseLongListQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Set<java.lang.Long>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalLongSetQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseLongSetQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "double": {
                code.add("$L = $T.parseDoubleQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<java.lang.Double>": {
                code.add("$L = $T.ofNullable($T.parseOptionalDoubleQueryParameter(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.lang.Double": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalDoubleQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseDoubleQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.List<java.lang.Double>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalDoubleListQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseDoubleListQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Set<java.lang.Double>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalDoubleSetQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseDoubleSetQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<java.lang.String>": {
                code.add("$L = $T.ofNullable($T.parseOptionalStringQueryParameter(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.lang.String": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalStringQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseStringQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.List<java.lang.String>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalStringListQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseStringListQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Set<java.lang.String>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalStringSetQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseStringSetQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "boolean": {
                code.add("$L = $T.parseBooleanQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Optional<java.lang.Boolean>": {
                code.add("$L = $T.ofNullable($T.parseOptionalBooleanQueryParameter(_request, $S));", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.lang.Boolean": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalBooleanQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseBooleanQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.List<java.lang.Boolean>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalBooleanListQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseBooleanListQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            case "java.util.Set<java.lang.Boolean>": {
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.parseOptionalBooleanSetQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                    break;
                }
                code.add("$L = $T.parseBooleanSetQueryParameter(_request, $S);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name});
                break;
            }
            default: {
                String readerParameterName = "_" + parameter.name + "Reader";
                if (CommonUtils.isOptional((TypeMirror)parameter.type)) {
                    TypeMirror optionalParameter = ((DeclaredType)parameter.type).getTypeArguments().get(0);
                    ParameterizedTypeName parameterReaderType = ParameterizedTypeName.get((ClassName)HttpServerClassNames.stringParameterReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)optionalParameter)});
                    methodBuilder.addParameter((TypeName)parameterReaderType, readerParameterName, new Modifier[0]);
                    code.add("$L = $T.ofNullable($T.parseOptionalStringQueryParameter(_request, $S)).map($L::read);", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name, readerParameterName});
                    return code.build();
                }
                if (CommonUtils.isList((TypeMirror)parameter.type)) {
                    TypeMirror listParameter = ((DeclaredType)parameter.type).getTypeArguments().get(0);
                    ParameterizedTypeName parameterReaderType = ParameterizedTypeName.get((ClassName)HttpServerClassNames.stringParameterReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)listParameter)});
                    if (this.isNullable(parameter)) {
                        methodBuilder.addParameter((TypeName)parameterReaderType, readerParameterName, new Modifier[0]);
                        code.add("$L = $T.parseOptionalSomeListQueryParameter(_request, $S, $L);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name, readerParameterName});
                    } else {
                        methodBuilder.addParameter((TypeName)parameterReaderType, readerParameterName, new Modifier[0]);
                        code.add("$L = $T.parseSomeListQueryParameter(_request, $S, $L);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name, readerParameterName});
                    }
                    return code.build();
                }
                if (CommonUtils.isSet((TypeMirror)parameter.type)) {
                    TypeMirror listParameter = ((DeclaredType)parameter.type).getTypeArguments().get(0);
                    ParameterizedTypeName parameterReaderType = ParameterizedTypeName.get((ClassName)HttpServerClassNames.stringParameterReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)listParameter)});
                    if (this.isNullable(parameter)) {
                        methodBuilder.addParameter((TypeName)parameterReaderType, readerParameterName, new Modifier[0]);
                        code.add("$L = $T.parseOptionalSomeSetQueryParameter(_request, $S, $L);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name, readerParameterName});
                    } else {
                        methodBuilder.addParameter((TypeName)parameterReaderType, readerParameterName, new Modifier[0]);
                        code.add("$L = $T.parseSomeSetQueryParameter(_request, $S, $L);", new Object[]{parameter.variableElement, HttpServerClassNames.requestHandlerUtils, parameter.name, readerParameterName});
                    }
                    return code.build();
                }
                ParameterizedTypeName parameterReaderType = ParameterizedTypeName.get((ClassName)HttpServerClassNames.stringParameterReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)parameter.type)});
                methodBuilder.addParameter((TypeName)parameterReaderType, readerParameterName, new Modifier[0]);
                if (this.isNullable(parameter)) {
                    code.add("$L = $T.ofNullable($T.parseOptionalStringQueryParameter(_request, $S)).map($L::read).orElse(null);", new Object[]{parameter.variableElement, Optional.class, HttpServerClassNames.requestHandlerUtils, parameter.name, readerParameterName});
                } else {
                    code.add("$L = $L.read($T.parseStringQueryParameter(_request, $S));", new Object[]{parameter.variableElement, readerParameterName, HttpServerClassNames.requestHandlerUtils, parameter.name});
                }
                return code.build();
            }
        }
        return code.build();
    }

    private boolean isNullable(Parameter parameter) {
        return CommonUtils.isNullable((AnnotatedConstruct)parameter.variableElement);
    }

    @Nullable
    private List<Parameter> parseParameters(RequestMappingData requestMappingData) {
        List<? extends VariableElement> rawParameters = requestMappingData.executableElement().getParameters();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(rawParameters.size());
        for (int i = 0; i < rawParameters.size(); ++i) {
            VariableElement parameter = rawParameters.get(i);
            TypeMirror parameterType = requestMappingData.executableType().getParameterTypes().get(i);
            AnnotationMirror query = AnnotationUtils.findAnnotation((Element)parameter, (ClassName)HttpServerClassNames.query);
            if (query != null) {
                String value = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)query, (String)"value");
                String queryParameterName = value == null || value.isBlank() ? parameter.getSimpleName().toString() : value;
                parameters.add(new Parameter(ParameterType.QUERY, queryParameterName, parameterType, parameter));
                continue;
            }
            AnnotationMirror header = AnnotationUtils.findAnnotation((Element)parameter, (ClassName)HttpServerClassNames.header);
            if (header != null) {
                String value = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)header, (String)"value");
                String headerParameterName = value == null || value.isBlank() ? parameter.getSimpleName().toString() : value;
                parameters.add(new Parameter(ParameterType.HEADER, headerParameterName, parameterType, parameter));
                continue;
            }
            AnnotationMirror cookie = AnnotationUtils.findAnnotation((Element)parameter, (ClassName)HttpServerClassNames.cookie);
            if (cookie != null) {
                String value = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)cookie, (String)"value");
                String cookieParameterName = value == null || value.isBlank() ? parameter.getSimpleName().toString() : value;
                parameters.add(new Parameter(ParameterType.COOKIE, cookieParameterName, parameterType, parameter));
                continue;
            }
            AnnotationMirror path = AnnotationUtils.findAnnotation((Element)parameter, (ClassName)HttpServerClassNames.path);
            if (path != null) {
                String pathParameterName;
                String value = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)path, (String)"value");
                String string = pathParameterName = value == null || value.isBlank() ? parameter.getSimpleName().toString() : value;
                if (requestMappingData.route().contains("{%s}".formatted(pathParameterName))) {
                    parameters.add(new Parameter(ParameterType.PATH, pathParameterName, parameterType, parameter));
                    continue;
                }
                this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Path parameter '%s' is not present in the request mapping path".formatted(pathParameterName), parameter);
                continue;
            }
            if (parameter.asType().toString().equals(CommonClassNames.context.canonicalName())) {
                parameters.add(new Parameter(ParameterType.CONTEXT, parameter.getSimpleName().toString(), parameterType, parameter));
                continue;
            }
            if (parameter.asType().toString().equals(HttpServerClassNames.httpServerRequest.canonicalName())) {
                parameters.add(new Parameter(ParameterType.REQUEST, parameter.getSimpleName().toString(), parameterType, parameter));
                continue;
            }
            parameters.add(new Parameter(ParameterType.MAPPED_HTTP_REQUEST, parameter.getSimpleName().toString(), parameterType, parameter));
        }
        if (parameters.size() != requestMappingData.executableElement().getParameters().size()) {
            return null;
        }
        return parameters;
    }

    private String methodName(RequestMappingData requestMappingData) {
        String suffix = requestMappingData.route().endsWith("/") ? "_trailing_slash" : "";
        return requestMappingData.httpMethod().toLowerCase() + Stream.of(requestMappingData.route().split("[^A-Za-z0-9]+")).filter(Predicate.not(String::isBlank)).collect(Collectors.joining("_", "_", suffix));
    }

    private boolean isBlocking(RequestMappingData requestMappingData) {
        TypeMirror returnType = requestMappingData.executableType().getReturnType();
        boolean isAsync = this.types.isAssignable(returnType, this.completionStageTypeErasure) || this.publisherTypeErasure != null && this.types.isAssignable(returnType, this.publisherTypeErasure) || this.types.isAssignable(returnType, this.jdkPublisherTypeErasure);
        return !isAsync;
    }

    private void addParameterMappers(MethodSpec.Builder methodBuilder, RequestMappingData requestMappingData, List<Parameter> bodyParameterType) {
        for (Parameter parameter : bodyParameterType) {
            TypeName mapperType;
            AnnotationSpec tags;
            if (parameter.parameterType != ParameterType.MAPPED_HTTP_REQUEST) continue;
            CommonUtils.MappingData mapper = requestMappingData.httpRequestMappingData().get(parameter.variableElement);
            String mapperName = parameter.name + "HttpRequestMapper";
            AnnotationSpec annotationSpec = tags = mapper != null ? mapper.toTagAnnotation() : null;
            if (mapper != null && mapper.mapperClass() != null) {
                mapperType = TypeName.get((TypeMirror)mapper.mapperClass());
            } else {
                TypeMirror typeMirror = parameter.type;
                mapperType = this.isBlocking(requestMappingData) ? ParameterizedTypeName.get((ClassName)HttpServerClassNames.httpServerRequestMapper, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)typeMirror).box()}) : ParameterizedTypeName.get((ClassName)HttpServerClassNames.httpServerRequestMapper, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(CompletionStage.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)typeMirror).box()})});
            }
            ParameterSpec.Builder b = ParameterSpec.builder((TypeName)mapperType, (String)mapperName, (Modifier[])new Modifier[0]);
            if (tags != null) {
                b.addAnnotation(tags);
            }
            methodBuilder.addParameter(b.build());
        }
    }

    @Nullable
    private ParameterSpec detectResponseMapper(RequestMappingData requestMappingData, ExecutableElement method) {
        TypeName resultTypeName;
        AnnotationSpec tags;
        AnnotationSpec annotationSpec = tags = requestMappingData.responseMapper() == null ? null : requestMappingData.responseMapper().toTagAnnotation();
        if (requestMappingData.responseMapper() != null && requestMappingData.responseMapper().mapperClass() != null) {
            ParameterSpec.Builder b = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)requestMappingData.responseMapper().mapperClass()), (String)"_responseMapper", (Modifier[])new Modifier[0]);
            if (tags != null) {
                b.addAnnotation(tags);
            }
            return b.build();
        }
        TypeMirror returnType = requestMappingData.executableType().getReturnType();
        if (returnType.getKind() == TypeKind.ERROR) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Method return type is ERROR", method);
            return null;
        }
        boolean isAsync = !this.isBlocking(requestMappingData);
        TypeName returnTypeName = TypeName.get((TypeMirror)returnType).box();
        TypeName typeName = resultTypeName = isAsync ? (TypeName)((ParameterizedTypeName)returnTypeName).typeArguments.get(0) : returnTypeName;
        if (resultTypeName.box().toString().equals("java.lang.Void") && tags == null) {
            return null;
        }
        if (resultTypeName.box().toString().equals(HttpServerClassNames.httpServerResponse.canonicalName()) && tags == null) {
            return null;
        }
        ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)HttpServerClassNames.httpServerResponseMapper, (TypeName[])new TypeName[]{resultTypeName});
        ParameterSpec.Builder b = ParameterSpec.builder((TypeName)mapperType, (String)"_responseMapper", (Modifier[])new Modifier[0]);
        if (tags != null) {
            b.addAnnotation(tags);
        }
        return b.build();
    }

    private record Parameter(ParameterType parameterType, String name, TypeMirror type, VariableElement variableElement) {
    }

    static enum ParameterType {
        MAPPED_HTTP_REQUEST,
        HEADER,
        COOKIE,
        QUERY,
        PATH,
        REQUEST,
        CONTEXT;

    }
}

