/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.http.server.common.HttpServerConfig;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTelemetryConfig;

@Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
public final class $HttpServerConfig_ConfigValueExtractor
implements ConfigValueExtractor<HttpServerConfig> {
    public static final HttpServerConfig_Defaults DEFAULTS = new HttpServerConfig_Defaults();
    private static final PathElement.Key _publicApiHttpPort_path = PathElement.get((String)"publicApiHttpPort");
    private static final PathElement.Key _privateApiHttpPort_path = PathElement.get((String)"privateApiHttpPort");
    private static final PathElement.Key _privateApiHttpMetricsPath_path = PathElement.get((String)"privateApiHttpMetricsPath");
    private static final PathElement.Key _privateApiHttpReadinessPath_path = PathElement.get((String)"privateApiHttpReadinessPath");
    private static final PathElement.Key _privateApiHttpLivenessPath_path = PathElement.get((String)"privateApiHttpLivenessPath");
    private static final PathElement.Key _ignoreTrailingSlash_path = PathElement.get((String)"ignoreTrailingSlash");
    private static final PathElement.Key _ioThreads_path = PathElement.get((String)"ioThreads");
    private static final PathElement.Key _blockingThreads_path = PathElement.get((String)"blockingThreads");
    private static final PathElement.Key _threadKeepAliveTimeout_path = PathElement.get((String)"threadKeepAliveTimeout");
    private static final PathElement.Key _socketReadTimeout_path = PathElement.get((String)"socketReadTimeout");
    private static final PathElement.Key _socketWriteTimeout_path = PathElement.get((String)"socketWriteTimeout");
    private static final PathElement.Key _socketKeepAliveEnabled_path = PathElement.get((String)"socketKeepAliveEnabled");
    private static final PathElement.Key _shutdownWait_path = PathElement.get((String)"shutdownWait");
    private static final PathElement.Key _telemetry_path = PathElement.get((String)"telemetry");
    private final ConfigValueExtractor<Duration> threadKeepAliveTimeout_parser;
    private final ConfigValueExtractor<Duration> socketReadTimeout_parser;
    private final ConfigValueExtractor<Duration> socketWriteTimeout_parser;
    private final ConfigValueExtractor<Duration> shutdownWait_parser;
    private final ConfigValueExtractor<HttpServerTelemetryConfig> telemetry_parser;

    public $HttpServerConfig_ConfigValueExtractor(ConfigValueExtractor<Duration> extractor1, ConfigValueExtractor<HttpServerTelemetryConfig> extractor2) {
        this.threadKeepAliveTimeout_parser = extractor1;
        this.socketReadTimeout_parser = extractor1;
        this.socketWriteTimeout_parser = extractor1;
        this.shutdownWait_parser = extractor1;
        this.telemetry_parser = extractor2;
    }

    public HttpServerConfig extract(ConfigValue<?> _sourceValue) {
        if (_sourceValue instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue _nullValue = (ConfigValue.NullValue)_sourceValue;
            _sourceValue = new ConfigValue.ObjectValue(_sourceValue.origin(), Map.of());
        }
        ConfigValue.ObjectValue _config = _sourceValue.asObject();
        int publicApiHttpPort = this.parse_publicApiHttpPort(_config);
        int privateApiHttpPort = this.parse_privateApiHttpPort(_config);
        String privateApiHttpMetricsPath = this.parse_privateApiHttpMetricsPath(_config);
        String privateApiHttpReadinessPath = this.parse_privateApiHttpReadinessPath(_config);
        String privateApiHttpLivenessPath = this.parse_privateApiHttpLivenessPath(_config);
        boolean ignoreTrailingSlash = this.parse_ignoreTrailingSlash(_config);
        int ioThreads = this.parse_ioThreads(_config);
        int blockingThreads = this.parse_blockingThreads(_config);
        Duration threadKeepAliveTimeout = this.parse_threadKeepAliveTimeout(_config);
        Duration socketReadTimeout = this.parse_socketReadTimeout(_config);
        Duration socketWriteTimeout = this.parse_socketWriteTimeout(_config);
        boolean socketKeepAliveEnabled = this.parse_socketKeepAliveEnabled(_config);
        Duration shutdownWait = this.parse_shutdownWait(_config);
        HttpServerTelemetryConfig telemetry = this.parse_telemetry(_config);
        return new HttpServerConfig_Impl(publicApiHttpPort, privateApiHttpPort, privateApiHttpMetricsPath, privateApiHttpReadinessPath, privateApiHttpLivenessPath, ignoreTrailingSlash, ioThreads, blockingThreads, threadKeepAliveTimeout, socketReadTimeout, socketWriteTimeout, socketKeepAliveEnabled, shutdownWait, telemetry);
    }

    private int parse_publicApiHttpPort(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_publicApiHttpPort_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.publicApiHttpPort();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private int parse_privateApiHttpPort(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_privateApiHttpPort_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.privateApiHttpPort();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private String parse_privateApiHttpMetricsPath(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_privateApiHttpMetricsPath_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            String defaultValue = DEFAULTS.privateApiHttpMetricsPath();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
            }
            return defaultValue;
        }
        return value.asString();
    }

    private String parse_privateApiHttpReadinessPath(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_privateApiHttpReadinessPath_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            String defaultValue = DEFAULTS.privateApiHttpReadinessPath();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
            }
            return defaultValue;
        }
        return value.asString();
    }

    private String parse_privateApiHttpLivenessPath(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_privateApiHttpLivenessPath_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            String defaultValue = DEFAULTS.privateApiHttpLivenessPath();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
            }
            return defaultValue;
        }
        return value.asString();
    }

    private boolean parse_ignoreTrailingSlash(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_ignoreTrailingSlash_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            boolean defaultValue = DEFAULTS.ignoreTrailingSlash();
            return defaultValue;
        }
        return value.asBoolean();
    }

    private int parse_ioThreads(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_ioThreads_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.ioThreads();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private int parse_blockingThreads(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_blockingThreads_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            int defaultValue = DEFAULTS.blockingThreads();
            return defaultValue;
        }
        return value.asNumber().intValue();
    }

    private Duration parse_threadKeepAliveTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_threadKeepAliveTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.threadKeepAliveTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.threadKeepAliveTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Duration parse_socketReadTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_socketReadTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.socketReadTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.socketReadTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Duration parse_socketWriteTimeout(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_socketWriteTimeout_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.socketWriteTimeout();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.socketWriteTimeout_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private boolean parse_socketKeepAliveEnabled(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_socketKeepAliveEnabled_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            boolean defaultValue = DEFAULTS.socketKeepAliveEnabled();
            return defaultValue;
        }
        return value.asBoolean();
    }

    private Duration parse_shutdownWait(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_shutdownWait_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Duration defaultValue = DEFAULTS.shutdownWait();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Duration parsed = (Duration)this.shutdownWait_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private HttpServerTelemetryConfig parse_telemetry(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_telemetry_path);
        HttpServerTelemetryConfig parsed = (HttpServerTelemetryConfig)this.telemetry_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public record HttpServerConfig_Impl(int publicApiHttpPort, int privateApiHttpPort, @Nonnull String privateApiHttpMetricsPath, @Nonnull String privateApiHttpReadinessPath, @Nonnull String privateApiHttpLivenessPath, boolean ignoreTrailingSlash, int ioThreads, int blockingThreads, @Nonnull Duration threadKeepAliveTimeout, @Nonnull Duration socketReadTimeout, @Nonnull Duration socketWriteTimeout, boolean socketKeepAliveEnabled, @Nonnull Duration shutdownWait, @Nonnull HttpServerTelemetryConfig telemetry) implements HttpServerConfig
    {
        public HttpServerConfig_Impl {
            Objects.requireNonNull(privateApiHttpMetricsPath);
            Objects.requireNonNull(privateApiHttpReadinessPath);
            Objects.requireNonNull(privateApiHttpLivenessPath);
            Objects.requireNonNull(threadKeepAliveTimeout);
            Objects.requireNonNull(socketReadTimeout);
            Objects.requireNonNull(socketWriteTimeout);
            Objects.requireNonNull(shutdownWait);
            Objects.requireNonNull(telemetry);
        }
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public static final class HttpServerConfig_Defaults
    implements HttpServerConfig {
        @Override
        public HttpServerTelemetryConfig telemetry() {
            return null;
        }
    }
}

