/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common;

import java.time.Duration;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTelemetryConfig;

@ConfigValueExtractor
public interface HttpServerConfig {
    default public int publicApiHttpPort() {
        return 8080;
    }

    default public int privateApiHttpPort() {
        return 8085;
    }

    default public String privateApiHttpMetricsPath() {
        return "/metrics";
    }

    default public String privateApiHttpReadinessPath() {
        return "/system/readiness";
    }

    default public String privateApiHttpLivenessPath() {
        return "/system/liveness";
    }

    default public boolean ignoreTrailingSlash() {
        return false;
    }

    default public int ioThreads() {
        return Math.max(Runtime.getRuntime().availableProcessors(), 2);
    }

    default public int blockingThreads() {
        return Math.min(Math.max(Runtime.getRuntime().availableProcessors(), 2) * 8, 200);
    }

    default public Duration threadKeepAliveTimeout() {
        return Duration.ofSeconds(60L);
    }

    default public Duration socketReadTimeout() {
        return Duration.ZERO;
    }

    default public Duration socketWriteTimeout() {
        return Duration.ZERO;
    }

    default public boolean socketKeepAliveEnabled() {
        return false;
    }

    default public Duration shutdownWait() {
        return Duration.ofSeconds(30L);
    }

    public HttpServerTelemetryConfig telemetry();
}

