/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;

public interface HttpServerInterceptor {
    public CompletionStage<HttpServerResponse> intercept(Context var1, HttpServerRequest var2, InterceptChain var3) throws Exception;

    public static HttpServerInterceptor noop() {
        return (context, request, chain) -> chain.process(context, request);
    }

    public static HttpServerInterceptor wrapped(HttpServerInterceptor interceptor) {
        return (context, request, chain) -> {
            try {
                return interceptor.intercept(context, request, chain);
            }
            catch (CompletionException | ExecutionException e) {
                return CompletableFuture.failedFuture(e.getCause());
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        };
    }

    public static interface InterceptChain {
        public CompletionStage<HttpServerResponse> process(Context var1, HttpServerRequest var2) throws Exception;
    }
}

