/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common;

import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import ru.tinkoff.kora.application.graph.All;
import ru.tinkoff.kora.application.graph.PromiseOf;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.common.liveness.LivenessProbe;
import ru.tinkoff.kora.common.readiness.ReadinessProbe;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.http.server.common.HttpServerConfig;
import ru.tinkoff.kora.http.server.common.HttpServerInterceptor;
import ru.tinkoff.kora.http.server.common.HttpServerRequestMapperModule;
import ru.tinkoff.kora.http.server.common.HttpServerResponseMapperModule;
import ru.tinkoff.kora.http.server.common.PrivateApiHandler;
import ru.tinkoff.kora.http.server.common.StringParameterReadersModule;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandler;
import ru.tinkoff.kora.http.server.common.router.PublicApiHandler;
import ru.tinkoff.kora.http.server.common.telemetry.DefaultHttpServerTelemetryFactory;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerLoggerFactory;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerMetricsFactory;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTelemetryFactory;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTracerFactory;
import ru.tinkoff.kora.http.server.common.telemetry.PrivateApiMetrics;
import ru.tinkoff.kora.http.server.common.telemetry.Slf4jHttpServerLoggerFactory;

public interface HttpServerModule
extends StringParameterReadersModule,
HttpServerRequestMapperModule,
HttpServerResponseMapperModule {
    default public HttpServerConfig httpServerConfig(Config config, ConfigValueExtractor<HttpServerConfig> configValueExtractor) {
        return (HttpServerConfig)configValueExtractor.extract(config.get("httpServer"));
    }

    default public PrivateApiHandler privateApiHandler(ValueOf<HttpServerConfig> config, ValueOf<Optional<PrivateApiMetrics>> meterRegistry, All<PromiseOf<ReadinessProbe>> readinessProbes, All<PromiseOf<LivenessProbe>> livenessProbes) {
        return new PrivateApiHandler(config, meterRegistry, readinessProbes, livenessProbes);
    }

    default public PublicApiHandler publicApiHandler(All<HttpServerRequestHandler> handlers, @Tag(value={HttpServerModule.class}) All<HttpServerInterceptor> interceptors, HttpServerTelemetryFactory telemetry, HttpServerConfig config) {
        return new PublicApiHandler((List<HttpServerRequestHandler>)handlers, (List<HttpServerInterceptor>)interceptors, telemetry, config);
    }

    @DefaultComponent
    default public Slf4jHttpServerLoggerFactory slf4jHttpServerLoggerFactory() {
        return new Slf4jHttpServerLoggerFactory();
    }

    @DefaultComponent
    default public DefaultHttpServerTelemetryFactory defaultHttpServerTelemetryFactory(@Nullable HttpServerLoggerFactory logger, @Nullable HttpServerMetricsFactory metrics, @Nullable HttpServerTracerFactory tracer) {
        return new DefaultHttpServerTelemetryFactory(logger, metrics, tracer);
    }
}

