/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.common.util.FlowUtils;
import ru.tinkoff.kora.http.common.form.FormUrlEncoded;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.form.FormMultipartAsyncServerRequestMapper;
import ru.tinkoff.kora.http.server.common.form.FormMultipartServerRequestMapper;
import ru.tinkoff.kora.http.server.common.form.FormUrlEncodedAsyncServerRequestMapper;
import ru.tinkoff.kora.http.server.common.form.FormUrlEncodedServerRequestMapper;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestMapper;

public interface HttpServerRequestMapperModule {
    default public HttpServerRequestMapper<HttpServerRequest> noopRequestMapper() {
        return r -> r;
    }

    default public HttpServerRequestMapper<CompletionStage<HttpServerRequest>> noopAsyncRequestMapper() {
        return CompletableFuture::completedFuture;
    }

    default public HttpServerRequestMapper<ByteBuffer> byteBufBodyRequestMapper() {
        return r -> {
            ByteBuffer content = r.body().getFullContentIfAvailable();
            return content != null ? content : (ByteBuffer)r.body().asBufferStage().toCompletableFuture().join();
        };
    }

    default public HttpServerRequestMapper<CompletionStage<ByteBuffer>> byteBufAsyncBodyRequestMapper() {
        return r -> {
            ByteBuffer content = r.body().getFullContentIfAvailable();
            return content != null ? CompletableFuture.completedFuture(content) : r.body().asBufferStage();
        };
    }

    default public HttpServerRequestMapper<CompletionStage<byte[]>> byteArrayAsyncRequestMapper() {
        return request -> {
            ByteBuffer full = request.body().getFullContentIfAvailable();
            if (full != null) {
                if (full.hasArray() && full.arrayOffset() == 0 && full.array().length == full.remaining()) {
                    return CompletableFuture.completedFuture(full.array());
                }
                byte[] array = new byte[full.remaining()];
                full.get(array);
                return CompletableFuture.completedFuture(array);
            }
            return request.body().asArrayStage();
        };
    }

    default public HttpServerRequestMapper<byte[]> byteArrayRequestMapper() {
        return request -> {
            ByteBuffer full = request.body().getFullContentIfAvailable();
            if (full != null) {
                if (full.hasArray() && full.arrayOffset() == 0 && full.array().length == full.remaining()) {
                    return full.array();
                }
                byte[] array = new byte[full.remaining()];
                full.get(array);
                return array;
            }
            try (InputStream is = request.body().asInputStream();){
                if (is != null) {
                    byte[] byArray = is.readAllBytes();
                    return byArray;
                }
            }
            return (byte[])request.body().asArrayStage().toCompletableFuture().join();
        };
    }

    default public HttpServerRequestMapper<CompletionStage<String>> stringAsyncRequestMapper(HttpServerRequestMapper<CompletionStage<byte[]>> mapper) {
        return request -> {
            ByteBuffer full = request.body().getFullContentIfAvailable();
            if (full != null) {
                if (full.hasArray() && full.arrayOffset() == 0 && full.array().length == full.remaining()) {
                    return CompletableFuture.completedFuture(new String(full.array(), StandardCharsets.UTF_8));
                }
                byte[] array = new byte[full.remaining()];
                full.get(array);
                return CompletableFuture.completedFuture(new String(array, StandardCharsets.UTF_8));
            }
            return FlowUtils.toByteArrayFuture((Flow.Publisher)request.body()).thenApply(bytes -> {
                if (bytes == null) {
                    return null;
                }
                return new String((byte[])bytes, StandardCharsets.UTF_8);
            });
        };
    }

    default public HttpServerRequestMapper<String> stringRequestMapper(HttpServerRequestMapper<byte[]> mapper) {
        return request -> {
            byte[] bytes = (byte[])mapper.apply(request);
            if (bytes == null) {
                return null;
            }
            return new String(bytes, StandardCharsets.UTF_8);
        };
    }

    default public HttpServerRequestMapper<Flow.Publisher<ByteBuffer>> byteBufferPublisherRequestMapper() {
        return HttpServerRequest::body;
    }

    default public HttpServerRequestMapper<CompletionStage<Flow.Publisher<ByteBuffer>>> byteBufferPublisherAsyncRequestMapper() {
        return request -> CompletableFuture.completedFuture(request.body());
    }

    default public HttpServerRequestMapper<InputStream> inputStreamRequestMapper() {
        return r -> r.body().asInputStream();
    }

    default public HttpServerRequestMapper<FormUrlEncoded> formUrlEncoderHttpServerRequestMapper() {
        return new FormUrlEncodedServerRequestMapper();
    }

    default public HttpServerRequestMapper<CompletionStage<FormUrlEncoded>> formUrlEncodedAsyncServerRequestMapper() {
        return new FormUrlEncodedAsyncServerRequestMapper();
    }

    default public FormMultipartAsyncServerRequestMapper formMultipartAsyncServerRequestMapper() {
        return new FormMultipartAsyncServerRequestMapper();
    }

    default public FormMultipartServerRequestMapper formMultipartServerRequestMapper() {
        return new FormMultipartServerRequestMapper();
    }
}

