/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.http.common.header.MutableHttpHeaders;
import ru.tinkoff.kora.http.server.common.SimpleHttpServerResponse;

public interface HttpServerResponse {
    public int code();

    public MutableHttpHeaders headers();

    @Nullable
    public HttpBodyOutput body();

    public static HttpServerResponse of(int code) {
        return new SimpleHttpServerResponse(code, HttpHeaders.of(), null);
    }

    public static HttpServerResponse of(int code, @Nullable HttpBodyOutput body) {
        return new SimpleHttpServerResponse(code, HttpHeaders.of(), body);
    }

    public static HttpServerResponse of(int code, @Nullable HttpHeaders headers, HttpBodyOutput body) {
        return new SimpleHttpServerResponse(code, headers != null ? headers.toMutable() : null, body);
    }

    public static HttpServerResponse of(int code, @Nullable HttpHeaders headers) {
        return new SimpleHttpServerResponse(code, headers != null ? headers.toMutable() : null, (HttpBodyOutput)HttpBody.empty());
    }

    public static HttpServerResponse of(int code, @Nullable MutableHttpHeaders headers, HttpBodyOutput body) {
        return new SimpleHttpServerResponse(code, headers, body);
    }

    public static HttpServerResponse of(int code, @Nullable MutableHttpHeaders headers) {
        return new SimpleHttpServerResponse(code, headers, (HttpBodyOutput)HttpBody.empty());
    }
}

