/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import ru.tinkoff.kora.application.graph.All;
import ru.tinkoff.kora.application.graph.PromiseOf;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.application.graph.internal.loom.VirtualThreadExecutorHolder;
import ru.tinkoff.kora.common.liveness.LivenessProbe;
import ru.tinkoff.kora.common.liveness.LivenessProbeFailure;
import ru.tinkoff.kora.common.readiness.ReadinessProbe;
import ru.tinkoff.kora.common.readiness.ReadinessProbeFailure;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.server.common.HttpServerConfig;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.telemetry.PrivateApiMetrics;

public class PrivateApiHandler {
    private static final String PROBE_FAILURE_MDC_KEY = "probeFailureMessage";
    private static final HttpServerResponse NOT_FOUND = HttpServerResponse.of(404, (HttpBodyOutput)HttpBody.plaintext((String)"Private API path not found"));
    private final Executor executor;
    private final ValueOf<HttpServerConfig> config;
    private final ValueOf<Optional<PrivateApiMetrics>> meterRegistry;
    private final All<PromiseOf<ReadinessProbe>> readinessProbes;
    private final All<PromiseOf<LivenessProbe>> livenessProbes;

    public PrivateApiHandler(ValueOf<HttpServerConfig> config, ValueOf<Optional<PrivateApiMetrics>> meterRegistry, All<PromiseOf<ReadinessProbe>> readinessProbes, All<PromiseOf<LivenessProbe>> livenessProbes) {
        this.config = config;
        this.meterRegistry = meterRegistry;
        this.readinessProbes = readinessProbes;
        this.livenessProbes = livenessProbes;
        this.executor = Objects.requireNonNullElse(VirtualThreadExecutorHolder.executor(), ForkJoinPool.commonPool());
    }

    public CompletionStage<? extends HttpServerResponse> handle(String path) {
        String livenessPathWithoutSlash;
        String readinessPathWithoutSlash;
        String metricPathWithoutSlash;
        String metricsPath = ((HttpServerConfig)this.config.get()).privateApiHttpMetricsPath();
        String livenessPath = ((HttpServerConfig)this.config.get()).privateApiHttpLivenessPath();
        String readinessPath = ((HttpServerConfig)this.config.get()).privateApiHttpReadinessPath();
        String pathWithoutSlash = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        String string = metricPathWithoutSlash = metricsPath.endsWith("/") ? metricsPath.substring(0, metricsPath.length() - 1) : metricsPath;
        if (pathWithoutSlash.equals(metricPathWithoutSlash) || pathWithoutSlash.startsWith(metricPathWithoutSlash + "?")) {
            return this.metrics();
        }
        String string2 = readinessPathWithoutSlash = readinessPath.endsWith("/") ? readinessPath.substring(0, readinessPath.length() - 1) : readinessPath;
        if (pathWithoutSlash.equals(readinessPathWithoutSlash) || pathWithoutSlash.startsWith(readinessPathWithoutSlash + "?")) {
            return this.readiness();
        }
        String string3 = livenessPathWithoutSlash = livenessPath.endsWith("/") ? livenessPath.substring(0, livenessPath.length() - 1) : livenessPath;
        if (pathWithoutSlash.equals(livenessPathWithoutSlash) || pathWithoutSlash.startsWith(livenessPathWithoutSlash + "?")) {
            return this.liveness();
        }
        return CompletableFuture.completedFuture(NOT_FOUND);
    }

    private CompletionStage<HttpServerResponse> metrics() {
        String response = ((Optional)this.meterRegistry.get()).map(PrivateApiMetrics::scrape).orElse("");
        ByteBuffer body = ByteBuffer.wrap(response.getBytes(StandardCharsets.UTF_8));
        return CompletableFuture.completedFuture(HttpServerResponse.of(200, (HttpBodyOutput)HttpBody.plaintext((ByteBuffer)body)));
    }

    private CompletionStage<HttpServerResponse> readiness() {
        return this.handleProbes(this.readinessProbes, ReadinessProbe::probe, ReadinessProbeFailure::message);
    }

    private CompletionStage<HttpServerResponse> liveness() {
        return this.handleProbes(this.livenessProbes, LivenessProbe::probe, LivenessProbeFailure::message);
    }

    private <Probe, Failure> CompletionStage<HttpServerResponse> handleProbes(All<PromiseOf<Probe>> probes, TFunction<Probe, Failure> performProbe, Function<Failure, String> getMessage) {
        if (probes.isEmpty()) {
            return CompletableFuture.completedFuture(HttpServerResponse.of(200, (HttpBodyOutput)HttpBody.plaintext((String)"OK")));
        }
        CompletableFuture[] futures = new CompletableFuture[probes.size()];
        for (int i = 0; i < futures.length; ++i) {
            Optional optional = ((PromiseOf)probes.get(i)).get();
            if (optional.isEmpty()) {
                return CompletableFuture.completedFuture(HttpServerResponse.of(503, (HttpBodyOutput)HttpBody.plaintext((String)"Probe is not ready yet")));
            }
            Object probe = optional.get();
            try {
                CompletableFuture<Object> probeResult = CompletableFuture.supplyAsync(() -> {
                    try {
                        return performProbe.apply(probe);
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                }, this.executor);
                CompletableFuture future = new CompletableFuture();
                probeResult.whenComplete((result, error) -> {
                    if (error != null) {
                        future.complete("Probe failed: " + error.getMessage());
                    } else if (result != null) {
                        future.complete((String)getMessage.apply(result));
                    } else {
                        future.complete(null);
                    }
                });
                futures[i] = future;
                continue;
            }
            catch (Exception e) {
                futures[i] = CompletableFuture.failedFuture(e);
            }
        }
        CompletionStage resultFuture = CompletableFuture.allOf(futures).handle((T r, U error) -> {
            if (error != null) {
                return HttpServerResponseException.of(error, 500, error.getMessage());
            }
            for (CompletableFuture future : futures) {
                Object result = future.getNow(null);
                if (result == null) continue;
                return HttpServerResponse.of(503, (HttpBodyOutput)HttpBody.plaintext((String)String.valueOf(result)));
            }
            return HttpServerResponse.of(200, (HttpBodyOutput)HttpBody.plaintext((String)"OK"));
        });
        CompletableFuture<Void> timeoutFuture = CompletableFuture.runAsync(() -> {}, CompletableFuture.delayedExecutor(30L, TimeUnit.SECONDS, this.executor));
        return CompletableFuture.anyOf(new CompletableFuture[]{resultFuture, timeoutFuture}).thenApply(arg_0 -> PrivateApiHandler.lambda$handleProbes$4((CompletableFuture)resultFuture, arg_0));
    }

    private static /* synthetic */ HttpServerResponse lambda$handleProbes$4(CompletableFuture resultFuture, Object v) {
        if (resultFuture.isDone()) {
            return resultFuture.getNow(null);
        }
        resultFuture.cancel(true);
        return HttpServerResponse.of(408, (HttpBodyOutput)HttpBody.plaintext((String)"Probe failed: timeout"));
    }

    public static interface TFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

