/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.form;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import ru.tinkoff.kora.http.common.form.FormUrlEncoded;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.form.FormUrlEncodedServerRequestMapper;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestMapper;

public final class FormUrlEncodedAsyncServerRequestMapper
implements HttpServerRequestMapper<CompletionStage<FormUrlEncoded>> {
    @Override
    public CompletionStage<FormUrlEncoded> apply(HttpServerRequest request) {
        String contentType = request.headers().getFirst("content-type");
        if (contentType == null || !contentType.equalsIgnoreCase("application/x-www-form-urlencoded")) {
            HttpServerResponseException rs = HttpServerResponseException.of(415, "Expected content type: 'application/x-www-form-urlencoded'");
            try {
                request.body().close();
            }
            catch (IOException e) {
                rs.addSuppressed(e);
            }
            throw rs;
        }
        return request.body().asArrayStage().thenApply(bytes -> {
            String str = new String((byte[])bytes, StandardCharsets.UTF_8);
            Map<String, FormUrlEncoded.FormPart> parts = FormUrlEncodedServerRequestMapper.read(str);
            return new FormUrlEncoded(parts);
        });
    }
}

