/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.form;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ru.tinkoff.kora.http.common.form.FormUrlEncoded;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestMapper;

public final class FormUrlEncodedServerRequestMapper
implements HttpServerRequestMapper<FormUrlEncoded> {
    @Override
    public FormUrlEncoded apply(HttpServerRequest request) {
        String contentType = request.headers().getFirst("content-type");
        if (contentType == null || !contentType.equalsIgnoreCase("application/x-www-form-urlencoded")) {
            HttpServerResponseException rs = HttpServerResponseException.of(415, "Expected content type: 'application/x-www-form-urlencoded'");
            try {
                request.body().close();
            }
            catch (IOException e) {
                rs.addSuppressed(e);
            }
            throw rs;
        }
        byte[] bytes = (byte[])request.body().asArrayStage().toCompletableFuture().join();
        String str = new String(bytes, StandardCharsets.UTF_8);
        Map<String, FormUrlEncoded.FormPart> parts = FormUrlEncodedServerRequestMapper.read(str);
        return new FormUrlEncoded(parts);
    }

    public static Map<String, FormUrlEncoded.FormPart> read(String body) {
        HashMap<String, FormUrlEncoded.FormPart> parts = new HashMap<String, FormUrlEncoded.FormPart>();
        for (String s : body.split("&")) {
            if (s.isBlank()) continue;
            String[] pair = s.split("=");
            String name = URLDecoder.decode(pair[0].trim(), StandardCharsets.UTF_8);
            FormUrlEncoded.FormPart part = parts.computeIfAbsent(name, n -> new FormUrlEncoded.FormPart(n, new ArrayList()));
            if (pair.length <= 1) continue;
            String value = URLDecoder.decode(pair[1].trim(), StandardCharsets.UTF_8);
            part.values().add(value);
        }
        return parts;
    }
}

