/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.form;

import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.tinkoff.kora.http.common.form.FormMultipart;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;

public class MultipartReader {
    private static final Pattern boundaryPattern = Pattern.compile(".*(\\s|;)boundary=\"?(?<boundary>[^;\"]+).*");

    public static CompletionStage<List<FormMultipart.FormPart.MultipartFile>> read(HttpServerRequest r) {
        String contentType = r.headers().getFirst("content-type");
        if (contentType == null) {
            throw HttpServerResponseException.of(400, "content-type header is required");
        }
        Matcher m = boundaryPattern.matcher(contentType);
        if (!m.matches()) {
            throw HttpServerResponseException.of(400, "content-type header is invalid");
        }
        String boundary = m.group("boundary");
        CompletableFuture<List<FormMultipart.FormPart.MultipartFile>> future = new CompletableFuture<List<FormMultipart.FormPart.MultipartFile>>();
        MultipartDecoder decoder = new MultipartDecoder(boundary, future);
        r.body().subscribe((Flow.Subscriber)decoder);
        return future;
    }

    private static class MultipartDecoder
    implements Flow.Subscriber<ByteBuffer> {
        private static final Pattern namePattern = Pattern.compile(".*form-data;.*(\\s|;)name=\"(?<name>.*?)\".*", 2);
        private static final Pattern fileNamePattern = Pattern.compile(".*form-data;.*(\\s|;)filename=\"(?<filename>.*?)\".*", 2);
        private static final int SIZE_STEP = 0x400000;
        private final byte[] boundary;
        private final byte[] boundaryBuf;
        private final CompletableFuture<List<FormMultipart.FormPart.MultipartFile>> future;
        private ByteBuffer buf = null;
        private State state = State.BEGIN;
        private int readPosition = 0;
        private ArrayList<byte[]> currentHeaders;
        private ContentDisposition currentContentDisposition;
        private int lastBodyPosition = 0;
        private final List<FormMultipart.FormPart.MultipartFile> parts = Collections.synchronizedList(new ArrayList());

        public MultipartDecoder(String boundary, CompletableFuture<List<FormMultipart.FormPart.MultipartFile>> future) {
            this.boundary = boundary.getBytes(StandardCharsets.US_ASCII);
            this.boundaryBuf = new byte[this.boundary.length];
            this.future = future;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onNext(ByteBuffer byteBuffer) {
            if (this.future.isDone()) {
                return;
            }
            this.ensureWritable(byteBuffer);
            this.buf.put(byteBuffer);
            block5: while (true) {
                int readPosition = this.readPosition;
                switch (this.state) {
                    case BEGIN: {
                        if (this.buf.position() - readPosition < this.boundary.length + 4) {
                            return;
                        }
                        if (this.buf.get(this.readPosition) != 45 || this.buf.get(this.readPosition + 1) != 45) {
                            this.future.completeExceptionally(HttpServerResponseException.of(400, "Invalid beginning of multipart body"));
                            return;
                        }
                        this.buf.get(readPosition += 2, this.boundaryBuf);
                        if (!Arrays.equals(this.boundary, this.boundaryBuf)) {
                            this.future.completeExceptionally(HttpServerResponseException.of(400, "Invalid beginning of multipart body"));
                        }
                        if (this.buf.get(readPosition += this.boundary.length) != 13 || this.buf.get(readPosition + 1) != 10) {
                            this.future.completeExceptionally(HttpServerResponseException.of(400, "Invalid beginning of multipart body"));
                        }
                        this.readPosition = readPosition += 2;
                        this.state = State.READ_HEADERS;
                        this.currentHeaders = new ArrayList();
                        break;
                    }
                    case READ_HEADERS: {
                        int nextLineBreak = this.findNextLineBreak();
                        if (nextLineBreak < 0) {
                            return;
                        }
                        if (nextLineBreak != this.readPosition) {
                            byte[] bytes = new byte[nextLineBreak - this.readPosition];
                            this.buf.get(this.readPosition, bytes);
                            this.currentHeaders.add(bytes);
                            this.readPosition = nextLineBreak + 2;
                        } else {
                            ContentDisposition contentDisposition = this.parseContentDisposition();
                            if (contentDisposition == null) {
                                this.future.completeExceptionally(HttpServerResponseException.of(400, "Multipart part is missing content-disposition header"));
                                return;
                            }
                            this.currentContentDisposition = contentDisposition;
                            this.state = State.READ_BODY;
                            this.readPosition += 2;
                            this.lastBodyPosition = readPosition;
                        }
                        break;
                    }
                    case READ_BODY: {
                        int i = this.lastBodyPosition;
                        while (i <= this.buf.position() - (6 + this.boundary.length)) {
                            if (this.buf.get(i) != 13 || this.buf.get(i + 1) != 10 || this.buf.get(i + 2) != 45 || this.buf.get(i + 3) != 45) {
                                this.lastBodyPosition = i + 1;
                            } else if (!(this.buf.get(i + 4 + this.boundary.length) == 45 && this.buf.get(i + 4 + this.boundary.length + 1) == 45 || this.buf.get(i + 4 + this.boundary.length) == 13 && this.buf.get(i + 4 + this.boundary.length + 1) == 10)) {
                                this.lastBodyPosition = i + 1;
                            } else {
                                this.buf.get(i + 4, this.boundaryBuf);
                                if (Arrays.equals(this.boundary, this.boundaryBuf)) {
                                    byte[] array = new byte[i - this.readPosition];
                                    this.buf.get(this.readPosition, array);
                                    this.parts.add(new FormMultipart.FormPart.MultipartFile(this.currentContentDisposition.name(), this.currentContentDisposition.filename(), this.parseContentType(), array));
                                    if (this.buf.get(i + 4 + this.boundary.length) == 45 || this.buf.get(i + 4 + this.boundary.length + 1) == 45) {
                                        this.future.complete(this.parts);
                                        return;
                                    }
                                    this.readPosition = i + 4 + this.boundary.length + 2;
                                    this.state = State.READ_HEADERS;
                                    this.currentHeaders = new ArrayList();
                                    this.currentContentDisposition = null;
                                    int writePosition = this.buf.position();
                                    int newWritePosition = writePosition - this.readPosition;
                                    this.buf.position(this.readPosition).compact().position(newWritePosition);
                                    this.readPosition = 0;
                                    continue block5;
                                }
                            }
                            ++i;
                        }
                        return;
                    }
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (!this.future.isDone()) {
                this.future.completeExceptionally(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (!this.future.isDone()) {
                this.future.complete(this.parts);
            }
        }

        @Nullable
        private ContentDisposition parseContentDisposition() {
            for (byte[] header : this.currentHeaders) {
                Matcher m1;
                String headerStr;
                if (header.length < 19 || !(headerStr = new String(header, 0, 19)).equalsIgnoreCase("content-disposition") || !(m1 = namePattern.matcher(headerStr = new String(header, 19, header.length - 19))).matches()) continue;
                String name = m1.group("name");
                Matcher m2 = fileNamePattern.matcher(headerStr);
                String fileName = m2.matches() ? m2.group("filename") : null;
                return new ContentDisposition(name, fileName);
            }
            return null;
        }

        @Nullable
        private String parseContentType() {
            for (byte[] header : this.currentHeaders) {
                String headerStr;
                if (header.length < 12 || !(headerStr = new String(header, 0, 12)).equalsIgnoreCase("content-type")) continue;
                for (int i = 12; i < header.length; ++i) {
                    if (header[i] != 58) continue;
                    return new String(header, i + 1, header.length - i - 1).trim();
                }
            }
            return null;
        }

        private int findNextLineBreak() {
            for (int i = this.readPosition; i < this.buf.position() - 1; ++i) {
                if (this.buf.get(i) != 13 || this.buf.get(i + 1) != 10) continue;
                return i;
            }
            return -1;
        }

        private void ensureWritable(ByteBuffer byteBuffer) {
            int newCapacity;
            int bytesToWrite = byteBuffer.remaining();
            if (this.buf == null) {
                int newCapacity2;
                for (newCapacity2 = 0x400000; newCapacity2 <= bytesToWrite; newCapacity2 += 0x400000) {
                }
                this.buf = ByteBuffer.allocate(newCapacity2);
                return;
            }
            int writableBytes = this.buf.capacity() - this.buf.position();
            if (writableBytes >= bytesToWrite) {
                return;
            }
            int position = this.buf.position();
            for (newCapacity = this.buf.capacity(); newCapacity <= bytesToWrite + position; newCapacity += 0x400000) {
            }
            this.buf = ByteBuffer.allocate(newCapacity).put(this.buf.position(0)).position(position);
        }

        private static enum State {
            BEGIN,
            READ_HEADERS,
            READ_BODY;

        }

        private record ContentDisposition(String name, @Nullable String filename) {
        }
    }
}

