/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.handler.StringParameterReader;

public final class EnumStringParameterReader<T extends Enum<T>>
implements StringParameterReader<T> {
    private final Map<String, T> values = new HashMap<String, T>();

    public EnumStringParameterReader(T[] values, Function<T, String> mapper) {
        for (T value : values) {
            this.values.put(mapper.apply(value), value);
        }
    }

    @Override
    public T read(String string) {
        Enum value = (Enum)this.values.get(string);
        if (value == null) {
            throw HttpServerResponseException.of(400, "Invalid value '%s'. Valid values are: %s".formatted(string, this.values.keySet()));
        }
        return (T)value;
    }
}

