/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.handler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandler;

public final class HttpServerRequestHandlerImpl
implements HttpServerRequestHandler {
    private final String method;
    private final String routeTemplate;
    private final HttpServerRequestHandler.HandlerFunction handler;
    private final boolean enabled;

    public HttpServerRequestHandlerImpl(String method, String routeTemplate, HttpServerRequestHandler.HandlerFunction handler) {
        this(method, routeTemplate, handler, true);
    }

    public HttpServerRequestHandlerImpl(String method, String routeTemplate, HttpServerRequestHandler.HandlerFunction handler, boolean enabled) {
        this.method = method;
        this.routeTemplate = routeTemplate;
        this.handler = handler;
        this.enabled = enabled;
    }

    public static HttpServerRequestHandlerImpl of(String method, String routeTemplate, HttpServerRequestHandler.HandlerFunction handler) {
        return new HttpServerRequestHandlerImpl(method, routeTemplate, handler);
    }

    public static HttpServerRequestHandlerImpl of(String method, String routeTemplate, HttpServerRequestHandler.HandlerFunction handler, boolean enabled) {
        return new HttpServerRequestHandlerImpl(method, routeTemplate, handler, enabled);
    }

    public static HttpServerRequestHandlerImpl get(String routeTemplate, HttpServerRequestHandler.HandlerFunction handler) {
        return new HttpServerRequestHandlerImpl("GET", routeTemplate, handler);
    }

    public static HttpServerRequestHandlerImpl head(String routeTemplate, HttpServerRequestHandler.HandlerFunction handler) {
        return new HttpServerRequestHandlerImpl("HEAD", routeTemplate, handler);
    }

    public static HttpServerRequestHandlerImpl post(String routeTemplate, HttpServerRequestHandler.HandlerFunction handler) {
        return new HttpServerRequestHandlerImpl("POST", routeTemplate, handler);
    }

    public static HttpServerRequestHandlerImpl put(String routeTemplate, HttpServerRequestHandler.HandlerFunction handler) {
        return new HttpServerRequestHandlerImpl("PUT", routeTemplate, handler);
    }

    public static HttpServerRequestHandlerImpl delete(String routeTemplate, HttpServerRequestHandler.HandlerFunction handler) {
        return new HttpServerRequestHandlerImpl("DELETE", routeTemplate, handler);
    }

    public static HttpServerRequestHandlerImpl connect(String routeTemplate, HttpServerRequestHandler.HandlerFunction handler) {
        return new HttpServerRequestHandlerImpl("CONNECT", routeTemplate, handler);
    }

    public static HttpServerRequestHandlerImpl options(String routeTemplate, HttpServerRequestHandler.HandlerFunction handler) {
        return new HttpServerRequestHandlerImpl("OPTIONS", routeTemplate, handler);
    }

    public static HttpServerRequestHandlerImpl trace(String routeTemplate, HttpServerRequestHandler.HandlerFunction handler) {
        return new HttpServerRequestHandlerImpl("TRACE", routeTemplate, handler);
    }

    public static HttpServerRequestHandlerImpl patch(String routeTemplate, HttpServerRequestHandler.HandlerFunction handler) {
        return new HttpServerRequestHandlerImpl("PATCH", routeTemplate, handler);
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String routeTemplate() {
        return this.routeTemplate;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public CompletionStage<HttpServerResponse> handle(Context ctx, HttpServerRequest request) throws Exception {
        try {
            return this.handler.apply(ctx, request);
        }
        catch (CompletionException | ExecutionException e) {
            return CompletableFuture.failedFuture(e.getCause());
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }
}

