/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.handler;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.common.HttpResponseEntity;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.http.common.header.MutableHttpHeaders;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.handler.HttpServerResponseMapper;

public class HttpServerResponseEntityMapper<T>
implements HttpServerResponseMapper<HttpResponseEntity<T>> {
    private final HttpServerResponseMapper<T> delegate;

    public HttpServerResponseEntityMapper(HttpServerResponseMapper<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public HttpServerResponse apply(Context ctx, HttpServerRequest request, HttpResponseEntity<T> result) throws IOException {
        Objects.requireNonNull(result);
        HttpServerResponse response = this.delegate.apply(ctx, request, result.body());
        String contentType = result.headers().getFirst("content-type");
        HttpBodyOutput body = contentType != null && !contentType.isEmpty() ? (response.body().contentLength() >= 0L ? HttpBodyOutput.of((String)contentType, (long)response.body().contentLength(), (Flow.Publisher)response.body()) : HttpBodyOutput.of((String)contentType, (Flow.Publisher)response.body())) : response.body();
        if (result.headers().isEmpty()) {
            return HttpServerResponse.of(result.code(), response.headers(), body);
        }
        if (response.headers().isEmpty()) {
            return HttpServerResponse.of(result.code(), result.headers(), body);
        }
        MutableHttpHeaders headers = HttpHeaders.of();
        for (Map.Entry header : response.headers()) {
            headers.set((String)header.getKey(), (Collection)header.getValue());
        }
        for (Map.Entry header : result.headers()) {
            headers.add((String)header.getKey(), (Collection)header.getValue());
        }
        return HttpServerResponse.of(result.code(), headers, body);
    }
}

