/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.handler;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import ru.tinkoff.kora.http.common.cookie.Cookie;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.handler.StringParameterReader;

public final class RequestHandlerUtils {
    private RequestHandlerUtils() {
    }

    @Nonnull
    public static String parseStringPathParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        String param = request.pathParams().get(name);
        if (param == null) {
            throw HttpServerResponseException.of(400, "Path parameter '%s' is required".formatted(name));
        }
        return RequestHandlerUtils.decodeUrlSlashIfExist(param);
    }

    private static String decodeUrlSlashIfExist(String pathValue) {
        int encodedSymbolIndex = pathValue.indexOf(37);
        if (encodedSymbolIndex == -1) {
            return pathValue;
        }
        int lastEncodedSymbolIndex = 0;
        StringBuilder builder = new StringBuilder(pathValue.length());
        int lengthLimit = pathValue.length() - 2;
        while (encodedSymbolIndex != -1 && encodedSymbolIndex < lengthLimit) {
            boolean isSlash;
            boolean bl = isSlash = pathValue.charAt(encodedSymbolIndex + 1) == '2' && pathValue.charAt(encodedSymbolIndex + 2) == 'F';
            if (isSlash) {
                builder.append(pathValue, lastEncodedSymbolIndex, encodedSymbolIndex).append('/');
                lastEncodedSymbolIndex = encodedSymbolIndex + 3;
            }
            encodedSymbolIndex = pathValue.indexOf(37, encodedSymbolIndex + 1);
        }
        builder.append(pathValue.substring(lastEncodedSymbolIndex));
        return builder.toString();
    }

    @Nonnull
    public static UUID parseUUIDPathParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        String param = request.pathParams().get(name);
        if (param == null) {
            throw HttpServerResponseException.of(400, "Path parameter '%s' is required".formatted(name));
        }
        try {
            return UUID.fromString(param);
        }
        catch (IllegalArgumentException e) {
            throw HttpServerResponseException.of(400, "Path parameter '%s' has invalid value '%s'".formatted(name, param));
        }
    }

    public static int parseIntegerPathParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        String param = request.pathParams().get(name);
        if (param == null) {
            throw HttpServerResponseException.of(400, "Path parameter '%s' is required".formatted(name));
        }
        try {
            return Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Path parameter '%s' has invalid value '%s'".formatted(name, param));
        }
    }

    public static long parseLongPathParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        String param = request.pathParams().get(name);
        if (param == null) {
            throw HttpServerResponseException.of(400, "Path parameter '%s' is required".formatted(name));
        }
        try {
            return Long.parseLong(param);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Path parameter %s has invalid value: %s".formatted(name, param));
        }
    }

    public static double parseDoublePathParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        String param = request.pathParams().get(name);
        if (param == null) {
            throw HttpServerResponseException.of(400, "Path parameter '%s' is required".formatted(name));
        }
        try {
            return Double.parseDouble(param);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Path parameter %s has invalid value: %s".formatted(name, param));
        }
    }

    public static boolean parseBooleanPathParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        String param = request.pathParams().get(name);
        if (param == null) {
            throw HttpServerResponseException.of(400, "Path parameter '%s' is required".formatted(name));
        }
        if ("true".equalsIgnoreCase(param)) {
            return true;
        }
        if ("false".equalsIgnoreCase(param)) {
            return false;
        }
        throw HttpServerResponseException.of(400, "Path parameter %s has invalid value: %s".formatted(name, param));
    }

    @Nonnull
    public static String parseStringHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List result = request.headers().getAll(name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return String.join((CharSequence)", ", result);
    }

    @Nullable
    public static String parseOptionalStringHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List result = request.headers().getAll(name);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)", ", result);
    }

    public static List<String> parseStringListHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List<String> result = RequestHandlerUtils.parseOptionalStringListHeaderParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static List<String> parseOptionalStringListHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List headers = request.headers().getAll(name);
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return List.of();
        }
        ArrayList<String> result = new ArrayList<String>(headers.size());
        for (String header : headers) {
            String[] split;
            for (String s : split = header.split(",")) {
                if ((s = s.strip()).isBlank()) continue;
                result.add(s);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static Set<String> parseStringSetHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Set<String> result = RequestHandlerUtils.parseOptionalStringSetHeaderParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Set<String> parseOptionalStringSetHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List headers = request.headers().getAll(name);
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(headers.size() + 1);
        for (String header : headers) {
            String[] split;
            for (String s : split = header.split(",")) {
                if ((s = s.strip()).isBlank()) continue;
                result.add(s);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static int parseIntegerHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List result = request.headers().getAll(name);
        if (result == null || result.isEmpty()) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        String first = ((String)result.iterator().next()).strip();
        if (first.isEmpty()) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid blank string value".formatted(name));
        }
        try {
            return Integer.parseInt(first);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, first));
        }
    }

    @Nullable
    public static Integer parseOptionalIntegerHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List result = request.headers().getAll(name);
        if (result == null || result.isEmpty()) {
            return null;
        }
        String first = ((String)result.iterator().next()).strip();
        if (first.isEmpty()) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid blank string value".formatted(name));
        }
        try {
            return Integer.parseInt(first);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, first));
        }
    }

    public static List<Integer> parseIntegerListHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List<Integer> result = RequestHandlerUtils.parseOptionalIntegerListHeaderParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static List<Integer> parseOptionalIntegerListHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List headers = request.headers().getAll(name);
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return List.of();
        }
        ArrayList<Integer> result = new ArrayList<Integer>(headers.size());
        for (String header : headers) {
            String[] split;
            if ((header = header.strip()).isEmpty()) continue;
            for (String s : split = header.split(",")) {
                if ((s = s.strip()).isEmpty()) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, header));
                }
                try {
                    result.add(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, s));
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static Set<Integer> parseIntegerSetHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Set<Integer> result = RequestHandlerUtils.parseOptionalIntegerSetHeaderParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Set<Integer> parseOptionalIntegerSetHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List headers = request.headers().getAll(name);
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(headers.size() + 1);
        for (String header : headers) {
            String[] split;
            if ((header = header.strip()).isEmpty()) continue;
            for (String s : split = header.split(",")) {
                if ((s = s.strip()).isEmpty()) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, header));
                }
                try {
                    result.add(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, s));
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static long parseLongHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List param = request.headers().getAll(name);
        if (param == null || param.isEmpty()) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        String first = ((String)param.iterator().next()).strip();
        if (first.isEmpty()) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid blank string value".formatted(name));
        }
        try {
            return Long.parseLong(first);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, first));
        }
    }

    @Nullable
    public static Long parseOptionalLongHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List param = request.headers().getAll(name);
        if (param == null || param.isEmpty()) {
            return null;
        }
        String first = ((String)param.iterator().next()).strip();
        if (first.isEmpty()) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid blank string value".formatted(name));
        }
        try {
            return Long.parseLong(first);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, first));
        }
    }

    public static List<Long> parseLongListHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List<Long> result = RequestHandlerUtils.parseOptionalLongListHeaderParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static List<Long> parseOptionalLongListHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List headers = request.headers().getAll(name);
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return List.of();
        }
        ArrayList<Long> result = new ArrayList<Long>(headers.size());
        for (String header : headers) {
            String[] split;
            if ((header = header.strip()).isEmpty()) continue;
            for (String s : split = header.split(",")) {
                if ((s = s.strip()).isEmpty()) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, header));
                }
                try {
                    result.add(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, s));
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static Set<Long> parseLongSetHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Set<Long> result = RequestHandlerUtils.parseOptionalLongSetHeaderParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Set<Long> parseOptionalLongSetHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List headers = request.headers().getAll(name);
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<Long> result = new LinkedHashSet<Long>(headers.size() + 1);
        for (String header : headers) {
            String[] split;
            if ((header = header.strip()).isEmpty()) continue;
            for (String s : split = header.split(",")) {
                if ((s = s.strip()).isEmpty()) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, header));
                }
                try {
                    result.add(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, s));
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static double parseDoubleHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List param = request.headers().getAll(name);
        if (param == null || param.isEmpty()) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        String first = ((String)param.iterator().next()).strip();
        if (first.isEmpty()) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid blank string value".formatted(name));
        }
        try {
            return Double.parseDouble(first);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, first));
        }
    }

    @Nullable
    public static Double parseOptionalDoubleHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List param = request.headers().getAll(name);
        if (param == null || param.isEmpty()) {
            return null;
        }
        String first = ((String)param.iterator().next()).strip();
        if (first.isEmpty()) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid blank string value".formatted(name));
        }
        try {
            return Double.parseDouble(first);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, first));
        }
    }

    public static List<Double> parseDoubleListHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List<Double> result = RequestHandlerUtils.parseOptionalDoubleListHeaderParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static List<Double> parseOptionalDoubleListHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List headers = request.headers().getAll(name);
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return List.of();
        }
        ArrayList<Double> result = new ArrayList<Double>(headers.size());
        for (String header : headers) {
            String[] split;
            if ((header = header.strip()).isEmpty()) continue;
            for (String s : split = header.split(",")) {
                if ((s = s.strip()).isEmpty()) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, header));
                }
                try {
                    result.add(Double.parseDouble(s));
                }
                catch (NumberFormatException e) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, s));
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static Set<Double> parseDoubleSetHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Set<Double> result = RequestHandlerUtils.parseOptionalDoubleSetHeaderParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Set<Double> parseOptionalDoubleSetHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List headers = request.headers().getAll(name);
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<Double> result = new LinkedHashSet<Double>(headers.size() + 1);
        for (String header : headers) {
            String[] split;
            if ((header = header.strip()).isEmpty()) continue;
            for (String s : split = header.split(",")) {
                if ((s = s.strip()).isEmpty()) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, header));
                }
                try {
                    result.add(Double.parseDouble(s));
                }
                catch (NumberFormatException e) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, s));
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static UUID parseUuidHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        UUID result = RequestHandlerUtils.parseOptionalUuidHeaderParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static UUID parseOptionalUuidHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List result = request.headers().getAll(name);
        if (result == null || result.isEmpty()) {
            return null;
        }
        String first = ((String)result.iterator().next()).strip();
        if (first.isEmpty()) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid blank string value".formatted(name));
        }
        try {
            return UUID.fromString(first);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, first));
        }
    }

    public static List<UUID> parseUuidListHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List<UUID> result = RequestHandlerUtils.parseOptionalUuidListHeaderParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static List<UUID> parseOptionalUuidListHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List headers = request.headers().getAll(name);
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return List.of();
        }
        ArrayList<UUID> result = new ArrayList<UUID>(headers.size());
        for (String header : headers) {
            String[] split;
            if ((header = header.strip()).isEmpty()) continue;
            for (String s : split = header.split(",")) {
                if ((s = s.strip()).isEmpty()) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, header));
                }
                try {
                    result.add(UUID.fromString(s));
                }
                catch (NumberFormatException e) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, s));
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static Set<UUID> parseUuidSetHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Set<UUID> result = RequestHandlerUtils.parseOptionalUuidSetHeaderParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Set<UUID> parseOptionalUuidSetHeaderParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List headers = request.headers().getAll(name);
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<UUID> result = new LinkedHashSet<UUID>(headers.size() + 1);
        for (String header : headers) {
            String[] split;
            if ((header = header.strip()).isEmpty()) continue;
            for (String s : split = header.split(",")) {
                if ((s = s.strip()).isEmpty()) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, header));
                }
                try {
                    result.add(UUID.fromString(s));
                }
                catch (NumberFormatException e) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s".formatted(name, s));
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static <T> List<T> parseSomeListHeaderParameter(HttpServerRequest request, String name, StringParameterReader<T> mapping) throws HttpServerResponseException {
        List<T> result = RequestHandlerUtils.parseOptionalSomeListHeaderParameter(request, name, mapping);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static <T> List<T> parseOptionalSomeListHeaderParameter(HttpServerRequest request, String name, StringParameterReader<T> mapping) throws HttpServerResponseException {
        List headers = request.headers().getAll(name);
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return List.of();
        }
        ArrayList<T> result = new ArrayList<T>(headers.size());
        for (String header : headers) {
            String[] split;
            if ((header = header.strip()).isEmpty()) continue;
            for (String s : split = header.split(",")) {
                try {
                    T value = mapping.read(s);
                    result.add(value);
                }
                catch (HttpServerResponseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s due to: ".formatted(name, s) + e.getMessage());
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> Set<T> parseSomeSetHeaderParameter(HttpServerRequest request, String name, StringParameterReader<T> mapping) throws HttpServerResponseException {
        Set<T> result = RequestHandlerUtils.parseOptionalSomeSetHeaderParameter(request, name, mapping);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static <T> Set<T> parseOptionalSomeSetHeaderParameter(HttpServerRequest request, String name, StringParameterReader<T> mapping) throws HttpServerResponseException {
        List headers = request.headers().getAll(name);
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(headers.size() + 1);
        for (String header : headers) {
            String[] split;
            if ((header = header.strip()).isEmpty()) continue;
            for (String s : split = header.split(",")) {
                try {
                    T value = mapping.read(s);
                    result.add(value);
                }
                catch (HttpServerResponseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw HttpServerResponseException.of(400, "Header '%s' has invalid value: %s due to: ".formatted(name, s) + e.getMessage());
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    public static UUID parseUuidQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        UUID result = RequestHandlerUtils.parseOptionalUuidQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static UUID parseOptionalUuidQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> param = request.queryParams().get(name);
        if (param == null || param.isEmpty()) {
            return null;
        }
        String first = param.iterator().next().strip();
        if (first.isEmpty()) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
        }
        try {
            return UUID.fromString(first);
        }
        catch (IllegalArgumentException e) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value '%s'".formatted(name, param));
        }
    }

    @Nonnull
    public static String parseStringQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        String result = RequestHandlerUtils.parseOptionalStringQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static String parseOptionalStringQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> param = request.queryParams().get(name);
        if (param == null || param.isEmpty()) {
            return null;
        }
        return param.iterator().next();
    }

    public static int parseIntegerQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Integer result = RequestHandlerUtils.parseOptionalIntegerQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Integer parseOptionalIntegerQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> param = request.queryParams().get(name);
        if (param == null || param.isEmpty()) {
            return null;
        }
        String first = param.iterator().next().strip();
        if (first.isEmpty()) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
        }
        try {
            return Integer.parseInt(first);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, first));
        }
    }

    public static long parseLongQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Long result = RequestHandlerUtils.parseOptionalLongQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Long parseOptionalLongQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> param = request.queryParams().get(name);
        if (param == null || param.isEmpty()) {
            return null;
        }
        String first = param.iterator().next().strip();
        if (first.isEmpty()) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
        }
        try {
            return Long.parseLong(first);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, first));
        }
    }

    public static boolean parseBooleanQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Boolean result = RequestHandlerUtils.parseOptionalBooleanQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Boolean parseOptionalBooleanQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> param = request.queryParams().get(name);
        if (param == null || param.isEmpty()) {
            return null;
        }
        String first = param.iterator().next().strip();
        if (first.isEmpty()) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
        }
        if ("true".equalsIgnoreCase(first)) {
            return true;
        }
        if ("false".equalsIgnoreCase(first)) {
            return false;
        }
        throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, param));
    }

    public static double parseDoubleQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Double result = RequestHandlerUtils.parseOptionalDoubleQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Double parseOptionalDoubleQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> param = request.queryParams().get(name);
        if (param == null || param.isEmpty()) {
            return null;
        }
        String first = param.iterator().next().strip();
        if (first.isEmpty()) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
        }
        try {
            return Double.parseDouble(first);
        }
        catch (NumberFormatException e) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, first));
        }
    }

    @Nonnull
    public static List<Integer> parseIntegerListQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List<Integer> result = RequestHandlerUtils.parseOptionalIntegerListQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static List<Integer> parseOptionalIntegerListQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return List.of();
        }
        ArrayList<Integer> result = new ArrayList<Integer>(params.size());
        for (String param : params) {
            if (param == null) continue;
            if ((param = param.strip()).isEmpty()) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
            }
            try {
                result.add(Integer.parseInt(param));
            }
            catch (NumberFormatException e) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, param));
            }
        }
        return result;
    }

    @Nonnull
    public static List<UUID> parseUuidListQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List<UUID> result = RequestHandlerUtils.parseOptionalUuidListQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static List<UUID> parseOptionalUuidListQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return List.of();
        }
        ArrayList<UUID> result = new ArrayList<UUID>(params.size());
        for (String param : params) {
            if (param == null) continue;
            if ((param = param.strip()).isEmpty()) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
            }
            try {
                result.add(UUID.fromString(param));
            }
            catch (NumberFormatException e) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, param));
            }
        }
        return result;
    }

    @Nonnull
    public static List<String> parseStringListQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List<String> result = RequestHandlerUtils.parseOptionalStringListQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static List<String> parseOptionalStringListQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return List.of();
        }
        return params.stream().toList();
    }

    @Nonnull
    public static List<Long> parseLongListQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List<Long> result = RequestHandlerUtils.parseOptionalLongListQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static List<Long> parseOptionalLongListQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return List.of();
        }
        ArrayList<Long> result = new ArrayList<Long>(params.size());
        for (String param : params) {
            if (param == null) continue;
            if ((param = param.strip()).isEmpty()) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
            }
            try {
                result.add(Long.parseLong(param));
            }
            catch (NumberFormatException e) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, param));
            }
        }
        return result;
    }

    @Nonnull
    public static List<Double> parseDoubleListQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List<Double> result = RequestHandlerUtils.parseOptionalDoubleListQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static List<Double> parseOptionalDoubleListQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return List.of();
        }
        ArrayList<Double> result = new ArrayList<Double>(params.size());
        for (String param : params) {
            if (param == null) continue;
            if ((param = param.strip()).isEmpty()) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
            }
            try {
                result.add(Double.parseDouble(param));
            }
            catch (NumberFormatException e) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, param));
            }
        }
        return result;
    }

    @Nonnull
    public static List<Boolean> parseBooleanListQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        List<Boolean> result = RequestHandlerUtils.parseOptionalBooleanListQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static List<Boolean> parseOptionalBooleanListQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return List.of();
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>(params.size());
        for (String param : params) {
            if (param == null) continue;
            if ((param = param.strip()).isEmpty()) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
            }
            if ("true".equalsIgnoreCase(param)) {
                result.add(true);
                continue;
            }
            if ("false".equalsIgnoreCase(param)) {
                result.add(false);
                continue;
            }
            throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, params));
        }
        return result;
    }

    @Nonnull
    public static Set<Integer> parseIntegerSetQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Set<Integer> result = RequestHandlerUtils.parseOptionalIntegerSetQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Set<Integer> parseOptionalIntegerSetQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(params.size() + 1);
        for (String param : params) {
            if (param == null) continue;
            if ((param = param.strip()).isEmpty()) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
            }
            try {
                result.add(Integer.parseInt(param));
            }
            catch (NumberFormatException e) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, param));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    public static Set<UUID> parseUuidSetQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Set<UUID> result = RequestHandlerUtils.parseOptionalUuidSetQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Set<UUID> parseOptionalUuidSetQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<UUID> result = new LinkedHashSet<UUID>(params.size() + 1);
        for (String param : params) {
            if (param == null) continue;
            if ((param = param.strip()).isEmpty()) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
            }
            try {
                result.add(UUID.fromString(param));
            }
            catch (NumberFormatException e) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, param));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    public static Set<String> parseStringSetQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Set<String> result = RequestHandlerUtils.parseOptionalStringSetQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Set<String> parseOptionalStringSetQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(params.size() + 1);
        for (String str : params) {
            if (str == null) continue;
            result.add(str);
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    public static Set<Long> parseLongSetQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Set<Long> result = RequestHandlerUtils.parseOptionalLongSetQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Set<Long> parseOptionalLongSetQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<Long> result = new LinkedHashSet<Long>(params.size() + 1);
        for (String param : params) {
            if (param == null) continue;
            if ((param = param.strip()).isEmpty()) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
            }
            try {
                result.add(Long.parseLong(param));
            }
            catch (NumberFormatException e) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, param));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    public static Set<Double> parseDoubleSetQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Set<Double> result = RequestHandlerUtils.parseOptionalDoubleSetQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Set<Double> parseOptionalDoubleSetQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<Double> result = new LinkedHashSet<Double>(params.size() + 1);
        for (String param : params) {
            if (param == null) continue;
            if ((param = param.strip()).isEmpty()) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
            }
            try {
                result.add(Double.parseDouble(param));
            }
            catch (NumberFormatException e) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, param));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    public static Set<Boolean> parseBooleanSetQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Set<Boolean> result = RequestHandlerUtils.parseOptionalBooleanSetQueryParameter(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query parameter '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static Set<Boolean> parseOptionalBooleanSetQueryParameter(HttpServerRequest request, String name) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<Boolean> result = new LinkedHashSet<Boolean>(params.size() + 1);
        for (String param : params) {
            if (param == null) continue;
            if ((param = param.strip()).isEmpty()) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid blank string value".formatted(name));
            }
            if ("true".equalsIgnoreCase(param)) {
                result.add(true);
                continue;
            }
            if ("false".equalsIgnoreCase(param)) {
                result.add(false);
                continue;
            }
            throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, param));
        }
        return Collections.unmodifiableSet(result);
    }

    public static <T> List<T> parseSomeListQueryParameter(HttpServerRequest request, String name, StringParameterReader<T> mapping) throws HttpServerResponseException {
        List<T> result = RequestHandlerUtils.parseOptionalSomeListQueryParameter(request, name, mapping);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Header '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static <T> List<T> parseOptionalSomeListQueryParameter(HttpServerRequest request, String name, StringParameterReader<T> mapping) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return List.of();
        }
        ArrayList<T> result = new ArrayList<T>(params.size());
        for (String param : params) {
            if (param == null) continue;
            try {
                T value = mapping.read(param);
                result.add(value);
            }
            catch (HttpServerResponseException e) {
                throw e;
            }
            catch (Exception e) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, param));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> Set<T> parseSomeSetQueryParameter(HttpServerRequest request, String name, StringParameterReader<T> mapping) throws HttpServerResponseException {
        Set<T> result = RequestHandlerUtils.parseOptionalSomeSetQueryParameter(request, name, mapping);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Query '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static <T> Set<T> parseOptionalSomeSetQueryParameter(HttpServerRequest request, String name, StringParameterReader<T> mapping) throws HttpServerResponseException {
        Collection<String> params = request.queryParams().get(name);
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(params.size() + 1);
        for (String param : params) {
            if (param == null) continue;
            try {
                T value = mapping.read(param);
                result.add(value);
            }
            catch (HttpServerResponseException e) {
                throw e;
            }
            catch (Exception e) {
                throw HttpServerResponseException.of(400, "Query parameter '%s' has invalid value: %s".formatted(name, param));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Nullable
    public static Cookie parseOptionalCookie(HttpServerRequest request, String name) {
        List<Cookie> cookies = request.cookies();
        for (Cookie cookie : cookies) {
            if (!Objects.equals(cookie.name(), name)) continue;
            return cookie;
        }
        return null;
    }

    public static Cookie parseCookie(HttpServerRequest request, String name) {
        Cookie result = RequestHandlerUtils.parseOptionalCookie(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Cookie '%s' is required".formatted(name));
        }
        return result;
    }

    @Nullable
    public static String parseOptionalCookieString(HttpServerRequest request, String name) {
        Cookie cookie = RequestHandlerUtils.parseOptionalCookie(request, name);
        if (cookie != null) {
            return cookie.value();
        }
        return null;
    }

    public static String parseCookieString(HttpServerRequest request, String name) {
        String result = RequestHandlerUtils.parseOptionalCookieString(request, name);
        if (result == null) {
            throw HttpServerResponseException.of(400, "Cookie '%s' is required".formatted(name));
        }
        return result;
    }
}

