/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.handler;

import java.util.function.Function;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;

public interface StringParameterReader<T> {
    public T read(String var1);

    public static <T> StringParameterReader<T> of(Function<String, T> converter, String errorMessage) {
        return string -> {
            try {
                return converter.apply(string);
            }
            catch (Exception e) {
                throw HttpServerResponseException.of(e, 400, errorMessage);
            }
        };
    }

    public static <T> StringParameterReader<T> of(Function<String, T> converter, Function<String, String> errorMessage) {
        return string -> {
            try {
                return converter.apply(string);
            }
            catch (Exception e) {
                throw HttpServerResponseException.of(e, 400, (String)errorMessage.apply(string));
            }
        };
    }
}

