/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public record PathTemplate(String templateString, boolean template, String base, List<Part> parts, Set<String> parameterNames, boolean trailingSlash) implements Comparable<PathTemplate>
{
    public PathTemplate {
        parameterNames = Collections.unmodifiableSet(parameterNames);
    }

    public static PathTemplate create(String inputPath) {
        if (inputPath == null) {
            throw new IllegalArgumentException("Path must be specified");
        }
        if (!inputPath.startsWith("/")) {
            return PathTemplate.create("/" + inputPath);
        }
        String path = inputPath;
        int state = 0;
        String base = "";
        ArrayList<Part> parts = new ArrayList<Part>();
        int stringStart = 0;
        block15: for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '/') {
                        state = 1;
                        continue block15;
                    }
                    if (c == '*') {
                        base = path.substring(0, i + 1);
                        stringStart = i;
                        state = 5;
                        continue block15;
                    }
                    state = 0;
                    continue block15;
                }
                case 1: {
                    if (c == '{') {
                        base = path.substring(0, i);
                        stringStart = i + 1;
                        state = 2;
                        continue block15;
                    }
                    if (c == '*') {
                        base = path.substring(0, i + 1);
                        stringStart = i;
                        state = 5;
                        continue block15;
                    }
                    if (c == '/') continue block15;
                    state = 0;
                    continue block15;
                }
                case 2: {
                    if (c != '}') continue block15;
                    Part part = new Part(true, path.substring(stringStart, i));
                    parts.add(part);
                    stringStart = i;
                    state = 3;
                    continue block15;
                }
                case 3: {
                    if (c == '/') {
                        state = 4;
                        continue block15;
                    }
                    throw new IllegalArgumentException("Could not parse URI template %s, exception at char %s".formatted(path, path.length()));
                }
                case 4: {
                    if (c == '{') {
                        stringStart = i + 1;
                        state = 2;
                        continue block15;
                    }
                    if (c == '/') continue block15;
                    stringStart = i;
                    state = 5;
                    continue block15;
                }
                case 5: {
                    if (c != '/') continue block15;
                    Part part = new Part(false, path.substring(stringStart, i));
                    parts.add(part);
                    stringStart = i + 1;
                    state = 4;
                }
            }
        }
        boolean trailingSlash = false;
        switch (state) {
            case 1: {
                trailingSlash = true;
            }
            case 0: {
                base = path;
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Could not parse URI template %s, exception at char %s".formatted(path, path.length()));
            }
            case 4: {
                trailingSlash = true;
                break;
            }
            case 5: {
                Part part = new Part(false, path.substring(stringStart));
                parts.add(part);
                break;
            }
        }
        HashSet<String> templates = new HashSet<String>();
        for (Part part : parts) {
            if (!part.template) continue;
            templates.add(part.part);
        }
        return new PathTemplate(path, state > 1 && !base.contains("*"), base, parts, templates, trailingSlash);
    }

    public boolean matches(String path, Map<String, String> pathParameters) {
        int i;
        if (!this.template && this.base.contains("*")) {
            int indexOf = this.base.indexOf("*");
            String startBase = this.base.substring(0, indexOf);
            if (!path.startsWith(startBase)) {
                return false;
            }
            pathParameters.put("*", path.substring(indexOf, path.length()));
            return true;
        }
        if (!path.startsWith(this.base)) {
            return false;
        }
        int baseLength = this.base.length();
        if (!this.template) {
            return path.length() == baseLength;
        }
        if (this.trailingSlash && path.charAt(path.length() - 1) != '/') {
            return false;
        }
        int currentPartPosition = 0;
        Part current = this.parts.get(currentPartPosition);
        int stringStart = baseLength;
        for (i = baseLength; i < path.length(); ++i) {
            char currentChar = path.charAt(i);
            if (current.part.equals("*")) break;
            if (currentChar != '/') continue;
            String result = path.substring(stringStart, i);
            if (current.template) {
                pathParameters.put(current.part, result);
            } else if (!result.equals(current.part)) {
                pathParameters.clear();
                return false;
            }
            if (++currentPartPosition == this.parts.size()) {
                return this.trailingSlash && i == path.length() - 1;
            }
            current = this.parts.get(currentPartPosition);
            stringStart = i + 1;
        }
        if (currentPartPosition + 1 != this.parts.size()) {
            pathParameters.clear();
            return false;
        }
        String result = path.substring(stringStart, i);
        if (current.part.equals("*")) {
            pathParameters.put(current.part, path.substring(stringStart, path.length()));
            return true;
        }
        if (current.template && !result.isEmpty()) {
            pathParameters.put(current.part, result);
        } else if (!result.equals(current.part)) {
            pathParameters.clear();
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PathTemplate) {
            PathTemplate that = (PathTemplate)o;
            return this.compareTo(that) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(PathTemplate o) {
        if (this.template && !o.template) {
            return 1;
        }
        if (o.template && !this.template) {
            return -1;
        }
        int res = this.base.compareTo(o.base);
        if (res > 0) {
            return -1;
        }
        if (res < 0) {
            return 1;
        }
        if (!this.template) {
            return 0;
        }
        int i = 0;
        while (true) {
            int r;
            if (this.parts.size() == i) {
                if (o.parts.size() == i) {
                    if (this.trailingSlash == o.trailingSlash) {
                        return this.base.compareTo(o.base);
                    }
                    if (this.trailingSlash) {
                        return -1;
                    }
                    return 1;
                }
                return 1;
            }
            if (o.parts.size() == i) {
                return -1;
            }
            Part thisPath = this.parts.get(i);
            Part otherPart = o.parts.get(i);
            if (thisPath.template && !otherPart.template) {
                return 1;
            }
            if (!thisPath.template && otherPart.template) {
                return -1;
            }
            if (!thisPath.template && (r = thisPath.part.compareTo(otherPart.part)) != 0) {
                return r;
            }
            ++i;
        }
    }

    private record Part(boolean template, String part) {
    }
}

