/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.router;

import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import ru.tinkoff.kora.http.server.common.router.PathTemplate;

public class PathTemplateMatcher<T> {
    private final Map<String, Set<PathTemplateHolder>> pathTemplateMap = new HashMap<String, Set<PathTemplateHolder>>();
    private volatile int[] lengths = new int[0];

    @Nullable
    public PathTemplateMatch<T> match(String path) {
        int[] lengths;
        String normalizedPath = "".equals(path) ? "/" : path;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        int length = normalizedPath.length();
        for (int pathLength : lengths = this.lengths) {
            PathTemplateMatch<T> res;
            String part;
            Set<PathTemplateHolder> entry;
            if (pathLength == length) {
                PathTemplateMatch<T> res2;
                Set<PathTemplateHolder> entry2 = this.pathTemplateMap.get(normalizedPath);
                if (entry2 == null || (res2 = this.handleStemMatch(entry2, normalizedPath, params)) == null) continue;
                return res2;
            }
            if (pathLength >= length || (entry = this.pathTemplateMap.get(part = normalizedPath.substring(0, pathLength))) == null || (res = this.handleStemMatch(entry, normalizedPath, params)) == null) continue;
            return res;
        }
        return null;
    }

    @Nullable
    private PathTemplateMatch<T> handleStemMatch(Set<PathTemplateHolder> entry, String path, Map<String, String> params) {
        for (PathTemplateHolder val : entry) {
            if (val.template.matches(path, params)) {
                return new PathTemplateMatch(val.template.templateString(), params, val.value);
            }
            params.clear();
        }
        return null;
    }

    @Nullable
    public Map.Entry<PathTemplate, T> add(PathTemplate template, T value) {
        PathTemplateHolder holder;
        Set<PathTemplateHolder> values = this.pathTemplateMap.get(this.trimBase(template));
        TreeSet<Object> newValues = values == null ? new TreeSet() : new TreeSet<PathTemplateHolder>(values);
        if (newValues.contains(holder = new PathTemplateHolder(value, template))) {
            for (PathTemplateHolder pathTemplateHolder : newValues) {
                if (pathTemplateHolder.compareTo(holder) != 0) continue;
                return Map.entry(pathTemplateHolder.template, pathTemplateHolder.value);
            }
            throw new IllegalStateException();
        }
        newValues.add(holder);
        this.pathTemplateMap.put(this.trimBase(template), newValues);
        this.buildLengths();
        return null;
    }

    private String trimBase(PathTemplate template) {
        String retval = template.base();
        if (retval.endsWith("*")) {
            return retval.substring(0, retval.length() - 1);
        }
        return retval;
    }

    private void buildLengths() {
        TreeSet<Integer> lengths = new TreeSet<Integer>((o1, o2) -> -o1.compareTo((Integer)o2));
        for (String p : this.pathTemplateMap.keySet()) {
            lengths.add(p.length());
        }
        int[] lengthArray = new int[lengths.size()];
        int pos = 0;
        Iterator iterator = lengths.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            lengthArray[pos++] = i;
        }
        this.lengths = lengthArray;
    }

    public synchronized Map.Entry<PathTemplate, T> add(String pathTemplate, T value) {
        PathTemplate template = PathTemplate.create(pathTemplate);
        return this.add(template, value);
    }

    public synchronized PathTemplateMatcher<T> addAll(PathTemplateMatcher<T> pathTemplateMatcher) {
        for (Map.Entry<String, Set<PathTemplateHolder>> entry : pathTemplateMatcher.getPathTemplateMap().entrySet()) {
            for (PathTemplateHolder pathTemplateHolder : entry.getValue()) {
                this.add(pathTemplateHolder.template, pathTemplateHolder.value);
            }
        }
        return this;
    }

    Map<String, Set<PathTemplateHolder>> getPathTemplateMap() {
        return this.pathTemplateMap;
    }

    public Set<PathTemplate> getPathTemplates() {
        HashSet<PathTemplate> templates = new HashSet<PathTemplate>();
        for (Set<PathTemplateHolder> holders : this.pathTemplateMap.values()) {
            for (PathTemplateHolder holder : holders) {
                templates.add(holder.template);
            }
        }
        return templates;
    }

    public synchronized PathTemplateMatcher<T> remove(String pathTemplate) {
        PathTemplate template = PathTemplate.create(pathTemplate);
        return this.remove(template);
    }

    private synchronized PathTemplateMatcher<T> remove(PathTemplate template) {
        Set<PathTemplateHolder> values = this.pathTemplateMap.get(this.trimBase(template));
        if (values == null) {
            return this;
        }
        TreeSet<PathTemplateHolder> newValues = new TreeSet<PathTemplateHolder>(values);
        Iterator it = newValues.iterator();
        while (it.hasNext()) {
            PathTemplateHolder next = (PathTemplateHolder)it.next();
            if (!next.template.templateString().equals(template.templateString())) continue;
            it.remove();
            break;
        }
        if (newValues.size() == 0) {
            this.pathTemplateMap.remove(this.trimBase(template));
        } else {
            this.pathTemplateMap.put(this.trimBase(template), newValues);
        }
        this.buildLengths();
        return this;
    }

    public synchronized T get(String template) {
        PathTemplate pathTemplate = PathTemplate.create(template);
        Set<PathTemplateHolder> values = this.pathTemplateMap.get(this.trimBase(pathTemplate));
        if (values == null) {
            return null;
        }
        for (PathTemplateHolder next : values) {
            if (!next.template.equals(pathTemplate)) continue;
            return next.value;
        }
        return null;
    }

    public record PathTemplateMatch<T>(String matchedTemplate, Map<String, String> parameters, T value) {
    }

    private final class PathTemplateHolder
    implements Comparable<PathTemplateHolder> {
        final T value;
        final PathTemplate template;

        private PathTemplateHolder(T value, PathTemplate template) {
            this.value = value;
            this.template = template;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof PathTemplateHolder) {
                PathTemplateHolder that = (PathTemplateHolder)o;
                return this.template.equals(that.template);
            }
            return false;
        }

        public int hashCode() {
            return this.template.hashCode();
        }

        @Override
        public int compareTo(PathTemplateHolder o) {
            return this.template.compareTo(o.template);
        }
    }
}

