/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.router;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.http.server.common.HttpServerConfig;
import ru.tinkoff.kora.http.server.common.HttpServerInterceptor;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandler;
import ru.tinkoff.kora.http.server.common.router.LazyRequest;
import ru.tinkoff.kora.http.server.common.router.PathTemplate;
import ru.tinkoff.kora.http.server.common.router.PathTemplateMatcher;
import ru.tinkoff.kora.http.server.common.router.PublicApiRequest;
import ru.tinkoff.kora.http.server.common.router.PublicApiResponse;
import ru.tinkoff.kora.http.server.common.router.PublicApiResponseImpl;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTelemetry;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTelemetryFactory;

public class PublicApiHandler {
    private static final CompletionStage<HttpServerResponse> NOT_FOUND_RESPONSE = CompletableFuture.completedFuture(HttpServerResponse.of(404));
    private static final HttpServerRequestHandler.HandlerFunction NOT_FOUND_HANDLER = (ctx, request) -> NOT_FOUND_RESPONSE;
    private final Map<String, PathTemplateMatcher<HttpServerRequestHandler>> pathTemplateMatcher;
    private final PathTemplateMatcher<List<String>> allMethodMatchers;
    private final AtomicReference<RequestHandler> requestHandler = new AtomicReference();
    private final HttpServerTelemetry telemetry;

    public PublicApiHandler(List<HttpServerRequestHandler> handlers, List<HttpServerInterceptor> interceptors, HttpServerTelemetryFactory httpServerTelemetry, HttpServerConfig config) {
        this.telemetry = Objects.requireNonNullElse(httpServerTelemetry.get(config.telemetry()), HttpServerTelemetry.EMPTY);
        this.pathTemplateMatcher = new HashMap<String, PathTemplateMatcher<HttpServerRequestHandler>>();
        this.allMethodMatchers = new PathTemplateMatcher();
        for (HttpServerRequestHandler h : handlers) {
            if (!h.enabled()) continue;
            Object route = h.routeTemplate();
            PathTemplateMatcher methodMatchers = this.pathTemplateMatcher.computeIfAbsent(h.method(), k -> new PathTemplateMatcher());
            Map.Entry<PathTemplate, HttpServerRequestHandler> oldValue = methodMatchers.add((String)route, h);
            if (oldValue != null) {
                throw new IllegalStateException("Cannot add path template %s, matcher already contains an equivalent pattern %s".formatted(route, oldValue.getKey().templateString()));
            }
            if (config.ignoreTrailingSlash() && !((String)route).endsWith("*") && (oldValue = methodMatchers.add((String)(route = ((String)route).charAt(((String)route).length() - 1) == '/' ? ((String)route).substring(0, ((String)route).length() - 1) : (String)route + "/"), h)) != null) {
                throw new IllegalStateException("Cannot add path template %s, matcher already contains an equivalent pattern %s".formatted(route, oldValue.getKey().templateString()));
            }
            ArrayList<String> otherMethods = new ArrayList<String>(List.of(h.method()));
            Map.Entry<PathTemplate, ArrayList<String>> oldAllMethodValue = this.allMethodMatchers.add((String)route, otherMethods);
            if (oldAllMethodValue == null) continue;
            otherMethods.addAll((Collection<String>)oldAllMethodValue.getValue());
        }
        if (interceptors.isEmpty()) {
            this.requestHandler.set(new SimpleRequestHandler());
        } else {
            this.requestHandler.set(new AggregatedRequestHandler(interceptors));
        }
    }

    public PublicApiResponse process(Context context, PublicApiRequest publicApiRequest) {
        Map<String, String> templateParameters;
        String routeTemplate;
        HttpServerRequestHandler.HandlerFunction handlerFunction;
        PathTemplateMatcher.PathTemplateMatch<HttpServerRequestHandler> pathTemplateMatch;
        PathTemplateMatcher<HttpServerRequestHandler> methodMatchers = this.pathTemplateMatcher.get(publicApiRequest.method());
        PathTemplateMatcher.PathTemplateMatch<HttpServerRequestHandler> pathTemplateMatch2 = pathTemplateMatch = methodMatchers == null ? null : methodMatchers.match(publicApiRequest.path());
        if (pathTemplateMatch == null) {
            PathTemplateMatcher.PathTemplateMatch<List<String>> allMethodMatch = this.allMethodMatchers.match(publicApiRequest.path());
            if (allMethodMatch != null) {
                String allowed = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)allMethodMatch.value());
                handlerFunction = (ctx, request) -> CompletableFuture.failedFuture(HttpServerResponseException.of(405, "Method Not Allowed", HttpHeaders.of((String)"allow", (String)allowed)));
                routeTemplate = allMethodMatch.matchedTemplate();
                templateParameters = Map.of();
            } else {
                handlerFunction = NOT_FOUND_HANDLER;
                routeTemplate = null;
                templateParameters = Map.of();
            }
        } else {
            templateParameters = pathTemplateMatch.parameters();
            routeTemplate = pathTemplateMatch.matchedTemplate();
            handlerFunction = pathTemplateMatch.value()::handle;
        }
        LazyRequest request2 = new LazyRequest(publicApiRequest, templateParameters, routeTemplate);
        HttpServerTelemetry.HttpServerTelemetryContext tctx = this.telemetry.get(publicApiRequest, routeTemplate);
        try {
            CompletionStage<HttpServerResponse> future = this.requestHandler.get().apply(context, request2, handlerFunction);
            return new PublicApiResponseImpl(tctx, future.toCompletableFuture());
        }
        catch (CompletionException error) {
            return new PublicApiResponseImpl(tctx, CompletableFuture.failedFuture(Objects.requireNonNullElse(error.getCause(), error)));
        }
        catch (Throwable error) {
            return new PublicApiResponseImpl(tctx, CompletableFuture.failedFuture(error));
        }
    }

    private static class SimpleRequestHandler
    implements RequestHandler {
        private SimpleRequestHandler() {
        }

        @Override
        public CompletionStage<HttpServerResponse> apply(Context context, HttpServerRequest request, HttpServerRequestHandler.HandlerFunction lastHandlerInChain) throws Exception {
            return lastHandlerInChain.apply(context, request);
        }
    }

    private static class AggregatedRequestHandler
    implements RequestHandler {
        private static final RequestHandler FINAL_HANDLER = (ctx, request, lastHandlerInChain) -> lastHandlerInChain.apply(ctx, request);
        private final RequestHandler chain;

        private AggregatedRequestHandler(List<HttpServerInterceptor> interceptors) {
            RequestHandler chain = FINAL_HANDLER;
            for (HttpServerInterceptor interceptor : interceptors) {
                RequestHandler remainingChain = chain;
                chain = (ctx, r, lastHandler) -> {
                    Context oldCtx = Context.current();
                    try {
                        ctx.inject();
                        CompletionStage<HttpServerResponse> completionStage = interceptor.intercept(ctx, r, (_ctx, httpServerRequest) -> remainingChain.apply(_ctx, httpServerRequest, lastHandler));
                        return completionStage;
                    }
                    finally {
                        oldCtx.inject();
                    }
                };
            }
            this.chain = chain;
        }

        @Override
        public CompletionStage<HttpServerResponse> apply(Context ctx, HttpServerRequest request, HttpServerRequestHandler.HandlerFunction lastHandlerInChain) throws Exception {
            return this.chain.apply(ctx, request, lastHandlerInChain);
        }
    }

    private static interface RequestHandler {
        public CompletionStage<HttpServerResponse> apply(Context var1, HttpServerRequest var2, HttpServerRequestHandler.HandlerFunction var3) throws Exception;
    }
}

