/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.telemetry;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerLoggerConfig;

@Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
public final class $HttpServerLoggerConfig_ConfigValueExtractor
implements ConfigValueExtractor<HttpServerLoggerConfig> {
    public static final HttpServerLoggerConfig_Defaults DEFAULTS = new HttpServerLoggerConfig_Defaults();
    private static final PathElement.Key _stacktrace_path = PathElement.get((String)"stacktrace");
    private static final PathElement.Key _enabled_path = PathElement.get((String)"enabled");
    private static final PathElement.Key _maskQueries_path = PathElement.get((String)"maskQueries");
    private static final PathElement.Key _maskHeaders_path = PathElement.get((String)"maskHeaders");
    private static final PathElement.Key _mask_path = PathElement.get((String)"mask");
    private static final PathElement.Key _pathTemplate_path = PathElement.get((String)"pathTemplate");
    private final ConfigValueExtractor<Set<String>> maskQueries_parser;
    private final ConfigValueExtractor<Set<String>> maskHeaders_parser;

    public $HttpServerLoggerConfig_ConfigValueExtractor(ConfigValueExtractor<Set<String>> extractor1) {
        this.maskQueries_parser = extractor1;
        this.maskHeaders_parser = extractor1;
    }

    public HttpServerLoggerConfig extract(ConfigValue<?> _sourceValue) {
        if (_sourceValue instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue _nullValue = (ConfigValue.NullValue)_sourceValue;
            _sourceValue = new ConfigValue.ObjectValue(_sourceValue.origin(), Map.of());
        }
        ConfigValue.ObjectValue _config = _sourceValue.asObject();
        boolean stacktrace = this.parse_stacktrace(_config);
        Boolean enabled = this.parse_enabled(_config);
        Set<String> maskQueries = this.parse_maskQueries(_config);
        Set<String> maskHeaders = this.parse_maskHeaders(_config);
        String mask = this.parse_mask(_config);
        Boolean pathTemplate = this.parse_pathTemplate(_config);
        return new HttpServerLoggerConfig_Impl(stacktrace, enabled, maskQueries, maskHeaders, mask, pathTemplate);
    }

    private boolean parse_stacktrace(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_stacktrace_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            boolean defaultValue = DEFAULTS.stacktrace();
            return defaultValue;
        }
        return value.asBoolean();
    }

    @Nullable
    private Boolean parse_enabled(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_enabled_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return value.asBoolean();
    }

    private Set<String> parse_maskQueries(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_maskQueries_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Set<String> defaultValue = DEFAULTS.maskQueries();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Set parsed = (Set)this.maskQueries_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private Set<String> parse_maskHeaders(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_maskHeaders_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            Set<String> defaultValue = DEFAULTS.maskHeaders();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)value);
            }
            return defaultValue;
        }
        Set parsed = (Set)this.maskHeaders_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private String parse_mask(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_mask_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            String defaultValue = DEFAULTS.mask();
            if (defaultValue == null) {
                throw ConfigValueExtractionException.missingValue((ConfigValue)nullValue);
            }
            return defaultValue;
        }
        return value.asString();
    }

    @Nullable
    private Boolean parse_pathTemplate(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_pathTemplate_path);
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nullValue = (ConfigValue.NullValue)value;
            return null;
        }
        return value.asBoolean();
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public record HttpServerLoggerConfig_Impl(boolean stacktrace, Boolean enabled, @Nonnull Set<String> maskQueries, @Nonnull Set<String> maskHeaders, @Nonnull String mask, Boolean pathTemplate) implements HttpServerLoggerConfig
    {
        public HttpServerLoggerConfig_Impl {
            Objects.requireNonNull(maskQueries);
            Objects.requireNonNull(maskHeaders);
            Objects.requireNonNull(mask);
        }
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public static final class HttpServerLoggerConfig_Defaults
    implements HttpServerLoggerConfig {
        public Boolean enabled() {
            return null;
        }

        @Override
        public Boolean pathTemplate() {
            return null;
        }
    }
}

