/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.telemetry;

import jakarta.annotation.Nonnull;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Objects;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerLoggerConfig;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTelemetryConfig;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

@Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
public final class $HttpServerTelemetryConfig_ConfigValueExtractor
implements ConfigValueExtractor<HttpServerTelemetryConfig> {
    private static final PathElement.Key _logging_path = PathElement.get((String)"logging");
    private static final PathElement.Key _tracing_path = PathElement.get((String)"tracing");
    private static final PathElement.Key _metrics_path = PathElement.get((String)"metrics");
    private final ConfigValueExtractor<HttpServerLoggerConfig> logging_parser;
    private final ConfigValueExtractor<TelemetryConfig.TracingConfig> tracing_parser;
    private final ConfigValueExtractor<TelemetryConfig.MetricsConfig> metrics_parser;

    public $HttpServerTelemetryConfig_ConfigValueExtractor(ConfigValueExtractor<HttpServerLoggerConfig> extractor1, ConfigValueExtractor<TelemetryConfig.TracingConfig> extractor2, ConfigValueExtractor<TelemetryConfig.MetricsConfig> extractor3) {
        this.logging_parser = extractor1;
        this.tracing_parser = extractor2;
        this.metrics_parser = extractor3;
    }

    public HttpServerTelemetryConfig extract(ConfigValue<?> _sourceValue) {
        if (_sourceValue instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue _nullValue = (ConfigValue.NullValue)_sourceValue;
            _sourceValue = new ConfigValue.ObjectValue(_sourceValue.origin(), Map.of());
        }
        ConfigValue.ObjectValue _config = _sourceValue.asObject();
        HttpServerLoggerConfig logging = this.parse_logging(_config);
        TelemetryConfig.TracingConfig tracing = this.parse_tracing(_config);
        TelemetryConfig.MetricsConfig metrics = this.parse_metrics(_config);
        return new HttpServerTelemetryConfig_Impl(logging, tracing, metrics);
    }

    private HttpServerLoggerConfig parse_logging(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_logging_path);
        HttpServerLoggerConfig parsed = (HttpServerLoggerConfig)this.logging_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private TelemetryConfig.TracingConfig parse_tracing(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_tracing_path);
        TelemetryConfig.TracingConfig parsed = (TelemetryConfig.TracingConfig)this.tracing_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    private TelemetryConfig.MetricsConfig parse_metrics(ConfigValue.ObjectValue config) {
        ConfigValue value = config.get(_metrics_path);
        TelemetryConfig.MetricsConfig parsed = (TelemetryConfig.MetricsConfig)this.metrics_parser.extract(value);
        if (parsed == null) {
            throw ConfigValueExtractionException.missingValueAfterParse((ConfigValue)value);
        }
        return parsed;
    }

    @Generated(value={"ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator"})
    public static final class HttpServerTelemetryConfig_Impl
    extends Record
    implements HttpServerTelemetryConfig {
        @Nonnull
        private final HttpServerLoggerConfig logging;
        @Nonnull
        private final TelemetryConfig.TracingConfig tracing;
        @Nonnull
        private final TelemetryConfig.MetricsConfig metrics;

        public HttpServerTelemetryConfig_Impl(@Nonnull HttpServerLoggerConfig logging, @Nonnull TelemetryConfig.TracingConfig tracing, @Nonnull TelemetryConfig.MetricsConfig metrics) {
            Objects.requireNonNull(logging);
            Objects.requireNonNull(tracing);
            Objects.requireNonNull(metrics);
            this.logging = logging;
            this.tracing = tracing;
            this.metrics = metrics;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{HttpServerTelemetryConfig_Impl.class, "logging;tracing;metrics", "logging", "tracing", "metrics"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{HttpServerTelemetryConfig_Impl.class, "logging;tracing;metrics", "logging", "tracing", "metrics"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{HttpServerTelemetryConfig_Impl.class, "logging;tracing;metrics", "logging", "tracing", "metrics"}, this, o);
        }

        @Override
        @Nonnull
        public HttpServerLoggerConfig logging() {
            return this.logging;
        }

        @Nonnull
        public TelemetryConfig.TracingConfig tracing() {
            return this.tracing;
        }

        @Nonnull
        public TelemetryConfig.MetricsConfig metrics() {
            return this.metrics;
        }
    }
}

