/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.telemetry;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.http.server.common.router.PublicApiRequest;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerLogger;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerMetrics;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTelemetry;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTracer;

public final class DefaultHttpServerTelemetry
implements HttpServerTelemetry {
    private static final String UNMATCHED_ROUTE_TEMPLATE = "UNKNOWN_ROUTE";
    @Nullable
    private final HttpServerMetrics metrics;
    @Nullable
    private final HttpServerLogger logger;
    @Nullable
    private final HttpServerTracer tracer;

    public DefaultHttpServerTelemetry(@Nullable HttpServerMetrics metrics, @Nullable HttpServerLogger logger, @Nullable HttpServerTracer tracer) {
        this.metrics = metrics;
        this.logger = logger;
        this.tracer = tracer;
    }

    @Override
    public HttpServerTelemetry.HttpServerTelemetryContext get(PublicApiRequest request, @Nullable String routeTemplate) {
        HttpServerTracer.HttpServerSpan span;
        HttpServerMetrics metrics = this.metrics;
        HttpServerLogger logger = this.logger;
        HttpServerTracer tracer = this.tracer;
        if (!(metrics != null || tracer != null || logger != null && logger.isEnabled())) {
            return EMPTY_CTX;
        }
        long start = System.nanoTime();
        String method = request.method();
        String scheme = request.scheme();
        String host = request.hostName();
        if (metrics != null) {
            String pathTemplate = routeTemplate != null ? routeTemplate : UNMATCHED_ROUTE_TEMPLATE;
            metrics.requestStarted(method, pathTemplate, host, scheme);
        }
        if (routeTemplate != null) {
            if (logger != null) {
                logger.logStart(method, request.path(), routeTemplate, request.queryParams(), request.headers());
            }
            span = tracer != null ? tracer.createSpan(routeTemplate, request) : null;
        } else {
            span = null;
        }
        return (statusCode, resultCode, httpHeaders, exception) -> {
            long end = System.nanoTime();
            long processingTime = end - start;
            if (metrics != null) {
                String pathTemplate = routeTemplate != null ? routeTemplate : UNMATCHED_ROUTE_TEMPLATE;
                metrics.requestFinished(statusCode, resultCode, scheme, host, method, pathTemplate, httpHeaders, processingTime, exception);
            }
            if (routeTemplate != null) {
                if (logger != null) {
                    logger.logEnd(statusCode, resultCode, method, request.path(), routeTemplate, processingTime, request.queryParams(), httpHeaders, exception);
                }
                if (span != null) {
                    span.close(statusCode, resultCode, exception);
                }
            }
        };
    }
}

