/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.telemetry;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.http.server.common.telemetry.DefaultHttpServerTelemetry;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerLogger;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerLoggerFactory;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerMetrics;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerMetricsFactory;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTelemetry;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTelemetryConfig;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTelemetryFactory;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTracer;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTracerFactory;

public final class DefaultHttpServerTelemetryFactory
implements HttpServerTelemetryFactory {
    @Nullable
    private final HttpServerLoggerFactory logger;
    @Nullable
    private final HttpServerMetricsFactory metrics;
    @Nullable
    private final HttpServerTracerFactory tracer;

    public DefaultHttpServerTelemetryFactory(@Nullable HttpServerLoggerFactory logger, @Nullable HttpServerMetricsFactory metrics, @Nullable HttpServerTracerFactory tracer) {
        this.logger = logger;
        this.metrics = metrics;
        this.tracer = tracer;
    }

    @Override
    @Nullable
    public HttpServerTelemetry get(HttpServerTelemetryConfig config) {
        HttpServerTracer tracer;
        HttpServerMetrics metrics = this.metrics == null ? null : this.metrics.get(config.metrics());
        HttpServerLogger logging = this.logger == null ? null : this.logger.get(config.logging());
        HttpServerTracer httpServerTracer = tracer = this.tracer == null ? null : this.tracer.get(config.tracing());
        if (metrics == null && logging == null && tracer == null) {
            return null;
        }
        return new DefaultHttpServerTelemetry(metrics, logging, tracer);
    }
}

