/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.common.telemetry;

import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import ru.tinkoff.kora.http.common.HttpResultCode;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.http.server.common.HttpServer;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerLogger;
import ru.tinkoff.kora.logging.common.arg.StructuredArgument;

public class Slf4jHttpServerLogger
implements HttpServerLogger {
    private static final int AVERAGE_HEADER_SIZE = 15;
    private static final Logger log = LoggerFactory.getLogger(HttpServer.class);
    private final boolean logStacktrace;
    private final Set<String> maskedQueryParams;
    private final Set<String> maskedHeaders;
    private final String mask;
    private final Boolean pathTemplate;

    public Slf4jHttpServerLogger(boolean stacktrace, Set<String> maskedQueryParams, Set<String> maskedHeaders, String mask, Boolean pathTemplate) {
        this.logStacktrace = stacktrace;
        this.maskedQueryParams = maskedQueryParams.stream().map(e -> e.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        this.maskedHeaders = maskedHeaders.stream().map(e -> e.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        this.mask = mask;
        this.pathTemplate = pathTemplate;
    }

    @Override
    public boolean isEnabled() {
        return log.isInfoEnabled();
    }

    @Override
    public void logStart(String method, String path, String pathTemplate, Map<String, ? extends Collection<String>> queryParams, @Nullable HttpHeaders headers) {
        if (!log.isInfoEnabled()) {
            return;
        }
        String operation = this.getOperation(method, path, pathTemplate);
        Marker marker = StructuredArgument.marker((String)"httpRequest", gen -> {
            gen.writeStartObject();
            gen.writeStringField("operation", operation);
            gen.writeEndObject();
        });
        if (log.isDebugEnabled()) {
            this.logServerReceivedRequest(marker, Level.DEBUG, operation, queryParams, headers);
        } else {
            this.logServerReceivedRequest(marker, Level.INFO, operation, null, null);
        }
    }

    @Override
    public void logEnd(int statusCode, HttpResultCode resultCode, String method, String path, String pathTemplate, long processingTime, Map<String, ? extends Collection<String>> queryParams, @Nullable HttpHeaders headers, @Nullable Throwable exception) {
        if (!log.isWarnEnabled()) {
            return;
        }
        String operation = this.getOperation(method, path, pathTemplate);
        Marker marker = StructuredArgument.marker((String)"httpResponse", gen -> {
            gen.writeStartObject();
            gen.writeStringField("operation", operation);
            gen.writeStringField("resultCode", resultCode.string());
            gen.writeNumberField("processingTime", processingTime / 1000000L);
            gen.writeNumberField("statusCode", statusCode);
            if (exception != null) {
                String exceptionType = exception.getClass().getCanonicalName();
                gen.writeStringField("exceptionType", exceptionType);
            }
            gen.writeEndObject();
        });
        if (exception != null) {
            this.logServerRespondedWithException(marker, statusCode, operation, queryParams, headers, exception);
        } else if (log.isDebugEnabled()) {
            this.logServerResponded(marker, Level.DEBUG, statusCode, operation, queryParams, headers);
        } else {
            this.logServerResponded(marker, Level.INFO, statusCode, operation, null, null);
        }
    }

    protected String requestHeaderString(HttpHeaders headers) {
        return this.toMaskedString(headers);
    }

    protected String requestQueryParamsString(Map<String, ? extends Collection<String>> queryParams) {
        return this.toMaskedString(queryParams);
    }

    private void logServerReceivedRequest(Marker marker, Level level, String operation, @Nullable Map<String, ? extends Collection<String>> queryParams, @Nullable HttpHeaders headers) {
        boolean shouldWriteHeaders;
        boolean shouldWriteQueryParams = queryParams != null && !queryParams.isEmpty();
        boolean bl = shouldWriteHeaders = headers != null && !headers.isEmpty();
        if (shouldWriteQueryParams) {
            if (shouldWriteHeaders) {
                log.atLevel(level).addMarker(marker).log("HttpServer received request for {}?{}\n{}", new Object[]{operation, this.requestQueryParamsString(queryParams), this.requestHeaderString(headers)});
            } else {
                log.atLevel(level).addMarker(marker).log("HttpServer received request for {}?{}", (Object)operation, (Object)this.requestQueryParamsString(queryParams));
            }
        } else if (shouldWriteHeaders) {
            log.atLevel(level).addMarker(marker).log("HttpServer received request for {}\n{}", (Object)operation, (Object)this.requestHeaderString(headers));
        } else {
            log.atLevel(level).addMarker(marker).log("HttpServer received request for {}", (Object)operation);
        }
    }

    private void logServerRespondedWithException(Marker marker, int statusCode, String operation, @Nullable Map<String, ? extends Collection<String>> queryParams, @Nullable HttpHeaders headers, Throwable exception) {
        boolean shouldWriteHeaders;
        boolean shouldWriteQueryParams = queryParams != null && !queryParams.isEmpty();
        boolean bl = shouldWriteHeaders = headers != null && !headers.isEmpty();
        if (this.logStacktrace) {
            if (shouldWriteQueryParams) {
                if (shouldWriteHeaders) {
                    log.warn(marker, "HttpServer responded error {} for {}?{}\n{}", new Object[]{statusCode, operation, this.requestQueryParamsString(queryParams), this.requestHeaderString(headers), exception});
                } else {
                    log.warn(marker, "HttpServer responded error {} for {}?{}", new Object[]{statusCode, operation, this.requestQueryParamsString(queryParams), exception});
                }
            } else if (shouldWriteHeaders) {
                log.warn(marker, "HttpServer responded error {} for {}\n{}", new Object[]{statusCode, operation, this.requestHeaderString(headers), exception});
            } else {
                log.warn(marker, "HttpServer responded error {} for {}", new Object[]{statusCode, operation, exception});
            }
        } else if (shouldWriteQueryParams) {
            if (shouldWriteHeaders) {
                log.warn(marker, "HttpServer responded error {} for {}?{} due to: {}\n{}", new Object[]{statusCode, operation, this.requestQueryParamsString(queryParams), exception.getMessage(), this.requestHeaderString(headers)});
            } else {
                log.warn(marker, "HttpServer responded error {} for {}?{} due to: {}", new Object[]{statusCode, operation, this.requestQueryParamsString(queryParams), exception.getMessage()});
            }
        } else if (shouldWriteHeaders) {
            log.warn(marker, "HttpServer responded error {} for {} due to: {}\n{}", new Object[]{statusCode, operation, exception.getMessage(), this.requestHeaderString(headers)});
        } else {
            log.warn(marker, "HttpServer responded error {} for {} due to: {}", new Object[]{statusCode, operation, exception.getMessage()});
        }
    }

    private void logServerResponded(Marker marker, Level level, int statusCode, String operation, @Nullable Map<String, ? extends Collection<String>> queryParams, @Nullable HttpHeaders headers) {
        boolean shouldWriteHeaders;
        boolean shouldWriteQueryParams = queryParams != null && !queryParams.isEmpty();
        boolean bl = shouldWriteHeaders = headers != null && !headers.isEmpty();
        if (shouldWriteQueryParams) {
            if (shouldWriteHeaders) {
                log.atLevel(level).addMarker(marker).log("HttpServer responded {} for {}?{}\n{}", new Object[]{statusCode, operation, this.requestQueryParamsString(queryParams), this.requestHeaderString(headers)});
            } else {
                log.atLevel(level).addMarker(marker).log("HttpServer responded {} for {}?{}", new Object[]{statusCode, operation, this.requestQueryParamsString(queryParams)});
            }
        } else if (shouldWriteHeaders) {
            log.atLevel(level).addMarker(marker).log("HttpServer responded {} for {}\n{}", new Object[]{statusCode, operation, this.requestHeaderString(headers)});
        } else {
            log.atLevel(level).addMarker(marker).log("HttpServer responded {} for {}", (Object)statusCode, (Object)operation);
        }
    }

    private String toMaskedString(HttpHeaders headers) {
        StringBuilder sb = new StringBuilder(headers.size() * 15);
        Iterator iterator = headers.iterator();
        while (iterator.hasNext()) {
            Map.Entry headerEntry = (Map.Entry)iterator.next();
            String headerKey = (String)headerEntry.getKey();
            List headerValues = (List)headerEntry.getValue();
            sb.append(headerKey).append(": ").append(this.maskedHeaders.contains(headerKey) ? this.mask : String.join((CharSequence)", ", headerValues));
            if (!iterator.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private String toMaskedString(Map<String, ? extends Collection<String>> queryParams) {
        return queryParams.entrySet().stream().map(e -> {
            String key = (String)e.getKey();
            Collection values = (Collection)e.getValue();
            if (this.maskedQueryParams.contains(key.toLowerCase(Locale.ROOT))) {
                return key + "=" + this.mask;
            }
            if (values.isEmpty()) {
                return key + "=";
            }
            return values.stream().map(v -> key + "=" + v).collect(Collectors.joining("&"));
        }).collect(Collectors.joining("&"));
    }

    private boolean shouldWritePath() {
        return this.pathTemplate != null ? !this.pathTemplate.booleanValue() : log.isTraceEnabled();
    }

    private String getOperation(String method, String path, String pathTemplate) {
        return method + " " + (this.shouldWritePath() ? path : pathTemplate);
    }
}

