/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.undertow;

import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.tinkoff.kora.http.common.header.AbstractHttpHeaders;
import ru.tinkoff.kora.http.common.header.HttpHeaders;

public class UndertowHttpHeaders
extends AbstractHttpHeaders
implements HttpHeaders {
    private final HeaderMap headerMap;

    public UndertowHttpHeaders(HeaderMap headerMap) {
        this.headerMap = headerMap;
    }

    @Nullable
    public String getFirst(String headerName) {
        return this.headerMap.getFirst(headerName);
    }

    public List<String> getAll(String headerName) {
        HeaderValues headers = this.headerMap.get(headerName);
        if (headers == null) {
            return null;
        }
        return List.copyOf(headers);
    }

    public boolean has(String headerName) {
        return this.headerMap.contains(headerName);
    }

    public int size() {
        return this.headerMap.size();
    }

    public boolean isEmpty() {
        return this.headerMap.size() == 0;
    }

    public Set<String> names() {
        HashSet<String> names = new HashSet<String>();
        for (HttpString headerName : this.headerMap.getHeaderNames()) {
            names.add(headerName.toString().toLowerCase());
        }
        return names;
    }

    @Nonnull
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        final Iterator i = this.headerMap.iterator();
        return new Iterator<Map.Entry<String, List<String>>>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Map.Entry<String, List<String>> next() {
                HeaderValues next = (HeaderValues)i.next();
                return Map.entry(next.getHeaderName().toString().toLowerCase(), next);
            }
        };
    }
}

