/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.undertow;

import io.undertow.Undertow;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import jakarta.annotation.Nullable;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.xnio.Options;
import org.xnio.XnioWorker;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.common.readiness.ReadinessProbe;
import ru.tinkoff.kora.common.readiness.ReadinessProbeFailure;
import ru.tinkoff.kora.common.util.TimeUtils;
import ru.tinkoff.kora.http.server.common.HttpServer;
import ru.tinkoff.kora.http.server.common.HttpServerConfig;
import ru.tinkoff.kora.http.server.undertow.UndertowPublicApiHandler;
import ru.tinkoff.kora.logging.common.arg.StructuredArgument;

public class UndertowHttpServer
implements HttpServer,
ReadinessProbe {
    private static final Logger logger = LoggerFactory.getLogger(UndertowHttpServer.class);
    private final AtomicReference<HttpServerState> state = new AtomicReference<HttpServerState>(HttpServerState.INIT);
    private final ValueOf<HttpServerConfig> config;
    private final GracefulShutdownHandler gracefulShutdown;
    private final XnioWorker xnioWorker;
    private final ByteBufferPool byteBufferPool;
    private volatile Undertow undertow;

    public UndertowHttpServer(ValueOf<HttpServerConfig> config, ValueOf<UndertowPublicApiHandler> publicApiHandler, @Nullable XnioWorker xnioWorker, ByteBufferPool byteBufferPool) {
        this.config = config;
        this.xnioWorker = xnioWorker;
        this.byteBufferPool = byteBufferPool;
        this.gracefulShutdown = new GracefulShutdownHandler(exchange -> ((UndertowPublicApiHandler)publicApiHandler.get()).handleRequest(exchange));
    }

    public void release() {
        logger.debug("Public HTTP Server (Undertow) stopping...");
        this.state.set(HttpServerState.SHUTDOWN);
        long started = TimeUtils.started();
        this.gracefulShutdown.shutdown();
        Duration shutdownAwait = ((HttpServerConfig)this.config.get()).shutdownWait();
        try {
            logger.debug("Public HTTP Server (Undertow) awaiting graceful shutdown...");
            if (!this.gracefulShutdown.awaitShutdown(shutdownAwait.toMillis())) {
                logger.warn("Public HTTP Server (Undertow) failed completing graceful shutdown in {}", (Object)shutdownAwait);
            }
        }
        catch (InterruptedException e) {
            logger.warn("Public HTTP Server (Undertow) failed completing graceful shutdown in {}", (Object)shutdownAwait, (Object)e);
        }
        if (this.undertow != null) {
            this.undertow.stop();
            this.undertow = null;
        }
        logger.info("Public HTTP Server (Undertow) stopped in {}", (Object)TimeUtils.tookForLogging((long)started));
    }

    public void init() {
        logger.debug("Public HTTP Server (Undertow) starting...");
        long started = TimeUtils.started();
        this.gracefulShutdown.start();
        this.undertow = this.createServer();
        this.undertow.start();
        this.state.set(HttpServerState.RUN);
        Marker data = StructuredArgument.marker((String)"port", (Integer)this.port());
        logger.info(data, "Public HTTP Server (Undertow) started in {}", (Object)TimeUtils.tookForLogging((long)started));
    }

    private Undertow createServer() {
        HttpServerConfig config = (HttpServerConfig)this.config.get();
        return Undertow.builder().addHttpListener(config.publicApiHttpPort(), "0.0.0.0", (HttpHandler)this.gracefulShutdown).setWorker(this.xnioWorker).setByteBufferPool(this.byteBufferPool).setServerOption(Options.READ_TIMEOUT, (Object)((int)config.socketReadTimeout().toMillis())).setServerOption(Options.WRITE_TIMEOUT, (Object)((int)config.socketWriteTimeout().toMillis())).setServerOption(Options.KEEP_ALIVE, (Object)config.socketKeepAliveEnabled()).build();
    }

    public int port() {
        if (this.undertow == null) {
            return -1;
        }
        List infos = this.undertow.getListenerInfo();
        InetSocketAddress address = (InetSocketAddress)((Undertow.ListenerInfo)infos.get(0)).getAddress();
        return address.getPort();
    }

    public ReadinessProbeFailure probe() {
        return switch (this.state.get()) {
            default -> throw new IncompatibleClassChangeError();
            case HttpServerState.INIT -> new ReadinessProbeFailure("Public HTTP Server (Undertow) init");
            case HttpServerState.RUN -> null;
            case HttpServerState.SHUTDOWN -> new ReadinessProbeFailure("Public HTTP Server (Undertow) shutdown");
        };
    }

    private static enum HttpServerState {
        INIT,
        RUN,
        SHUTDOWN;

    }
}

