/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.undertow;

import io.undertow.Undertow;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import jakarta.annotation.Nullable;
import java.util.concurrent.ExecutorService;
import org.xnio.XnioWorker;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.common.annotation.Root;
import ru.tinkoff.kora.http.server.common.HttpServerConfig;
import ru.tinkoff.kora.http.server.common.handler.BlockingRequestExecutor;
import ru.tinkoff.kora.http.server.common.router.PublicApiHandler;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTracer;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTracerFactory;
import ru.tinkoff.kora.http.server.undertow.UndertowHttpServer;
import ru.tinkoff.kora.http.server.undertow.UndertowModule;
import ru.tinkoff.kora.http.server.undertow.UndertowPublicApiHandler;

public interface UndertowHttpServerModule
extends UndertowModule {
    default public UndertowPublicApiHandler undertowPublicApiHandler(PublicApiHandler publicApiHandler, @Nullable HttpServerTracerFactory tracerFactory, HttpServerConfig config) {
        HttpServerTracer tracer = tracerFactory == null ? null : tracerFactory.get(config.telemetry().tracing());
        return new UndertowPublicApiHandler(publicApiHandler, tracer);
    }

    @Root
    default public UndertowHttpServer undertowHttpServer(ValueOf<HttpServerConfig> config, ValueOf<UndertowPublicApiHandler> handler, @Tag(value={Undertow.class}) XnioWorker worker, @Tag(value={Undertow.class}) ByteBufferPool byteBufferPool) {
        return new UndertowHttpServer(config, handler, worker, byteBufferPool);
    }

    @DefaultComponent
    default public BlockingRequestExecutor undertowBlockingRequestExecutor(@Tag(value={Undertow.class}) XnioWorker xnioWorker) {
        return new BlockingRequestExecutor.Default((ExecutorService)xnioWorker);
    }

    @Tag(value={Undertow.class})
    @DefaultComponent
    default public ByteBufferPool undertowPublicByteBufferPool() {
        boolean directBuffers;
        int bufferSize;
        long maxMemory = Runtime.getRuntime().maxMemory();
        int maxPoolSize = -1;
        if (maxMemory < 0x4000000L) {
            bufferSize = 512;
            directBuffers = false;
        } else if (maxMemory < 0x8000000L) {
            bufferSize = 1024;
            directBuffers = true;
        } else {
            bufferSize = 16364;
            directBuffers = true;
        }
        return new DefaultByteBufferPool(directBuffers, bufferSize, -1, 4);
    }
}

