/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.undertow;

import io.undertow.Undertow;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import org.xnio.XnioWorker;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.common.annotation.Root;
import ru.tinkoff.kora.http.server.common.HttpServerConfig;
import ru.tinkoff.kora.http.server.common.HttpServerModule;
import ru.tinkoff.kora.http.server.common.PrivateApiHandler;
import ru.tinkoff.kora.http.server.undertow.UndertowPrivateApiHandler;
import ru.tinkoff.kora.http.server.undertow.UndertowPrivateHttpServer;
import ru.tinkoff.kora.http.server.undertow.XnioLifecycle;

public interface UndertowModule
extends HttpServerModule {
    default public UndertowPrivateApiHandler undertowPrivateApiHandler(PrivateApiHandler privateApiHandler) {
        return new UndertowPrivateApiHandler(privateApiHandler);
    }

    @Root
    default public UndertowPrivateHttpServer undertowPrivateHttpServer(ValueOf<HttpServerConfig> configValue, ValueOf<UndertowPrivateApiHandler> privateApiHandler, @Tag(value={Undertow.class}) XnioWorker xnioWorker, @Tag(value={UndertowPrivateHttpServer.class}) ByteBufferPool byteBufferPool) {
        return new UndertowPrivateHttpServer(configValue, privateApiHandler, xnioWorker, byteBufferPool);
    }

    @Tag(value={Undertow.class})
    default public Wrapped<XnioWorker> xnioWorker(ValueOf<HttpServerConfig> configValue) {
        return new XnioLifecycle(configValue);
    }

    @Tag(value={UndertowPrivateHttpServer.class})
    @DefaultComponent
    default public ByteBufferPool undertowPrivateByteBufferPool() {
        boolean directBuffers;
        int bufferSize;
        int maxPoolSize;
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory < 0x4000000L) {
            maxPoolSize = 32;
            bufferSize = 512;
            directBuffers = false;
        } else if (maxMemory < 0x8000000L) {
            maxPoolSize = 16;
            bufferSize = 1024;
            directBuffers = true;
        } else {
            maxPoolSize = 8;
            bufferSize = 16364;
            directBuffers = true;
        }
        return new DefaultByteBufferPool(directBuffers, bufferSize, maxPoolSize, 4);
    }
}

