/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.undertow;

import io.undertow.Undertow;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.common.util.TimeUtils;
import ru.tinkoff.kora.http.server.common.HttpServerConfig;

public final class XnioLifecycle
implements Lifecycle,
Wrapped<XnioWorker> {
    private static final Logger logger = LoggerFactory.getLogger(XnioLifecycle.class);
    private final ValueOf<HttpServerConfig> configValue;
    private volatile XnioWorker worker;

    public XnioLifecycle(ValueOf<HttpServerConfig> configValue) {
        this.configValue = configValue;
    }

    public void init() throws Exception {
        logger.debug("XnioWorker starting...");
        long started = System.nanoTime();
        HttpServerConfig httpServerConfig = (HttpServerConfig)this.configValue.get();
        CompletableFuture f = new CompletableFuture();
        Thread t = new Thread(() -> {
            try {
                XnioWorker worker = Xnio.getInstance((ClassLoader)Undertow.class.getClassLoader()).createWorkerBuilder().setCoreWorkerPoolSize(1).setMaxWorkerPoolSize(httpServerConfig.blockingThreads()).setWorkerIoThreads(httpServerConfig.ioThreads()).setWorkerKeepAlive((int)httpServerConfig.threadKeepAliveTimeout().toMillis()).setDaemon(false).setWorkerName("kora-undertow").build();
                f.complete(worker);
            }
            catch (Throwable e) {
                f.completeExceptionally(e);
            }
        });
        t.setDaemon(false);
        t.start();
        this.worker = (XnioWorker)f.get();
        logger.info("XnioWorker started in {}", (Object)TimeUtils.tookForLogging((long)started));
    }

    public void release() throws Exception {
        if (this.worker != null) {
            logger.debug("XnioWorker stopping...");
            long started = System.nanoTime();
            this.worker.shutdown();
            this.worker.awaitTermination();
            logger.info("XnioWorker stopped in {}", (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public XnioWorker value() {
        return this.worker;
    }
}

