/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.http.server.undertow.request;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.xnio.channels.StreamSourceChannel;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.common.body.DefaultFullHttpBody;
import ru.tinkoff.kora.http.common.body.EmptyHttpBody;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyInput;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.http.server.common.router.PublicApiRequest;
import ru.tinkoff.kora.http.server.undertow.UndertowHttpHeaders;
import ru.tinkoff.kora.http.server.undertow.request.UndertowRequestHttpBody;

public class UndertowPublicApiRequest
implements PublicApiRequest {
    private final HttpServerExchange exchange;
    private final Context context;
    private final String method;
    private final String path;
    private volatile HttpBodyInput body;
    private final UndertowHttpHeaders headers;

    public UndertowPublicApiRequest(HttpServerExchange exchange, Context context) {
        this.exchange = exchange;
        this.method = exchange.getRequestMethod().toString();
        this.path = exchange.getRelativePath();
        this.headers = new UndertowHttpHeaders(exchange.getRequestHeaders());
        this.context = context;
    }

    public String method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public String hostName() {
        return this.exchange.getHostName();
    }

    public String scheme() {
        return this.exchange.getRequestScheme();
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public Map<String, ? extends Collection<String>> queryParams() {
        return UndertowPublicApiRequest.queryParams(this.exchange);
    }

    public HttpBodyInput body() {
        HttpBodyInput b = this.body;
        if (b != null) {
            return b;
        }
        try {
            b = this.getContent(this.exchange);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.body = b;
        return this.body;
    }

    private static Map<String, List<String>> queryParams(HttpServerExchange httpServerExchange) {
        Map undertowQueryParams = httpServerExchange.getQueryParameters();
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>(undertowQueryParams.size());
        for (Map.Entry entry : undertowQueryParams.entrySet()) {
            String key = (String)entry.getKey();
            List<String> value = ((Deque)entry.getValue()).stream().filter(Predicate.not(String::isEmpty)).toList();
            queryParams.put(key, List.copyOf(value));
        }
        return Map.copyOf(queryParams);
    }

    private HttpBodyInput getContent(HttpServerExchange exchange) throws IOException {
        if (exchange.isRequestComplete()) {
            return HttpBody.empty();
        }
        if (!exchange.isInIoThread()) {
            return new UndertowRequestHttpBody(this.context, exchange, null);
        }
        try (PooledByteBuffer pooled = exchange.getConnection().getByteBufferPool().allocate();){
            ByteBuffer buffer = pooled.getBuffer();
            buffer.clear();
            Connectors.resetRequestChannel((HttpServerExchange)exchange);
            StreamSourceChannel channel = exchange.getRequestChannel();
            int res = channel.read(buffer);
            if (res == -1) {
                EmptyHttpBody emptyHttpBody = HttpBody.empty();
                return emptyHttpBody;
            }
            if (res == 0) {
                UndertowRequestHttpBody undertowRequestHttpBody = new UndertowRequestHttpBody(this.context, exchange, null);
                return undertowRequestHttpBody;
            }
            buffer.flip();
            byte[] data = new byte[res];
            buffer.get(data);
            buffer.clear();
            res = channel.read(buffer);
            if (res == -1) {
                String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
                DefaultFullHttpBody defaultFullHttpBody = HttpBody.of((Context)this.context, (String)contentType, (byte[])data);
                return defaultFullHttpBody;
            }
            if (res == 0) {
                LinkedList<byte[]> prefetched = new LinkedList<byte[]>();
                prefetched.add(data);
                UndertowRequestHttpBody undertowRequestHttpBody = new UndertowRequestHttpBody(this.context, exchange, prefetched);
                return undertowRequestHttpBody;
            }
            LinkedList<byte[]> prefetched = new LinkedList<byte[]>();
            prefetched.add(data);
            int len = data.length;
            while (res > 0) {
                buffer.flip();
                data = new byte[res];
                len += res;
                buffer.get(data);
                buffer.clear();
                prefetched.add(data);
                res = channel.read(buffer);
            }
            if (res < 0) {
                String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
                data = new byte[len];
                int pos = 0;
                for (byte[] bytes : prefetched) {
                    System.arraycopy(bytes, 0, data, pos, bytes.length);
                    pos += bytes.length;
                }
                DefaultFullHttpBody defaultFullHttpBody = HttpBody.of((Context)this.context, (String)contentType, (byte[])data);
                return defaultFullHttpBody;
            }
            UndertowRequestHttpBody undertowRequestHttpBody = new UndertowRequestHttpBody(this.context, exchange, prefetched);
            return undertowRequestHttpBody;
        }
    }
}

