/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.annotation.processor;

import com.squareup.javapoet.ClassName;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.LogUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.json.annotation.processor.JsonProcessor;
import ru.tinkoff.kora.json.annotation.processor.JsonTypes;

public class JsonAnnotationProcessor
extends AbstractKoraProcessor {
    private static final Logger log = LoggerFactory.getLogger(JsonAnnotationProcessor.class);
    private boolean initialized = false;
    private JsonProcessor processor;
    private TypeElement jsonAnnotation;
    private TypeElement jsonWriterAnnotation;
    private TypeElement jsonReaderAnnotation;

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(JsonTypes.json.canonicalName(), JsonTypes.jsonReaderAnnotation.canonicalName(), JsonTypes.jsonWriterAnnotation.canonicalName());
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.jsonAnnotation = processingEnv.getElementUtils().getTypeElement(JsonTypes.json.canonicalName());
        if (this.jsonAnnotation == null) {
            return;
        }
        this.jsonWriterAnnotation = Objects.requireNonNull(processingEnv.getElementUtils().getTypeElement(JsonTypes.jsonWriterAnnotation.canonicalName()));
        this.jsonReaderAnnotation = Objects.requireNonNull(processingEnv.getElementUtils().getTypeElement(JsonTypes.jsonReaderAnnotation.canonicalName()));
        this.initialized = true;
        this.processor = new JsonProcessor(processingEnv);
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.initialized) {
            return false;
        }
        if (roundEnv.processingOver()) {
            return false;
        }
        List<Element> jsonElements = roundEnv.getElementsAnnotatedWith(this.jsonAnnotation).stream().filter(e -> e.getKind().isClass() || e.getKind() == ElementKind.INTERFACE).toList();
        LogUtils.logElementsFull((Logger)log, (Level)Level.DEBUG, (String)"Generating Json Readers & Writers for", jsonElements);
        for (Element element : jsonElements) {
            try {
                this.processor.generateReader((TypeElement)element);
            }
            catch (ProcessingErrorException ex) {
                ex.printError(this.processingEnv);
            }
            try {
                this.processor.generateWriter((TypeElement)element);
            }
            catch (ProcessingErrorException ex) {
                ex.printError(this.processingEnv);
            }
        }
        List<Element> jsonWriterElements = roundEnv.getElementsAnnotatedWith(this.jsonWriterAnnotation).stream().filter(e -> e.getKind().isClass() || e.getKind() == ElementKind.INTERFACE).filter(e -> AnnotationUtils.findAnnotation((Element)e, (ClassName)JsonTypes.json) == null).toList();
        LogUtils.logElementsFull((Logger)log, (Level)Level.DEBUG, (String)"Generating JsonWriters for", jsonWriterElements);
        for (Element e3 : jsonWriterElements) {
            try {
                this.processor.generateWriter((TypeElement)e3);
            }
            catch (ProcessingErrorException ex) {
                ex.printError(this.processingEnv);
            }
        }
        List<Element> list = roundEnv.getElementsAnnotatedWith(this.jsonReaderAnnotation).stream().filter(e -> e.getKind().isClass() || e.getKind() == ElementKind.CONSTRUCTOR).map(e -> e.getKind() == ElementKind.CONSTRUCTOR ? e.getEnclosingElement() : e).filter(e -> AnnotationUtils.findAnnotation((Element)e, (ClassName)JsonTypes.json) == null).toList();
        LogUtils.logElementsFull((Logger)log, (Level)Level.DEBUG, (String)"Generating JsonReaders for", list);
        for (Element e4 : list) {
            try {
                this.processor.generateReader((TypeElement)e4);
            }
            catch (ProcessingErrorException ex) {
                ex.printError(this.processingEnv);
            }
        }
        return false;
    }
}

