/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.annotation.processor;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.ComparableTypeMirror;
import ru.tinkoff.kora.annotation.processor.common.SealedTypeUtils;
import ru.tinkoff.kora.json.annotation.processor.JsonUtils;
import ru.tinkoff.kora.json.annotation.processor.KnownType;
import ru.tinkoff.kora.json.annotation.processor.reader.EnumReaderGenerator;
import ru.tinkoff.kora.json.annotation.processor.reader.JsonClassReaderMeta;
import ru.tinkoff.kora.json.annotation.processor.reader.JsonReaderGenerator;
import ru.tinkoff.kora.json.annotation.processor.reader.ReaderTypeMetaParser;
import ru.tinkoff.kora.json.annotation.processor.reader.SealedInterfaceReaderGenerator;
import ru.tinkoff.kora.json.annotation.processor.writer.EnumWriterGenerator;
import ru.tinkoff.kora.json.annotation.processor.writer.JsonClassWriterMeta;
import ru.tinkoff.kora.json.annotation.processor.writer.JsonWriterGenerator;
import ru.tinkoff.kora.json.annotation.processor.writer.SealedInterfaceWriterGenerator;
import ru.tinkoff.kora.json.annotation.processor.writer.WriterTypeMetaParser;

public class JsonProcessor {
    private static final Logger log = LoggerFactory.getLogger(JsonProcessor.class);
    private final ProcessingEnvironment processingEnv;
    private final Elements elements;
    private final Types types;
    private final ReaderTypeMetaParser readerTypeMetaParser;
    private final WriterTypeMetaParser writerTypeMetaParser;
    private final JsonWriterGenerator writerGenerator;
    private final JsonReaderGenerator readerGenerator;
    private final SealedInterfaceReaderGenerator sealedReaderGenerator;
    private final SealedInterfaceWriterGenerator sealedWriterGenerator;
    private final EnumReaderGenerator enumReaderGenerator;
    private final EnumWriterGenerator enumWriterGenerator;

    public JsonProcessor(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        KnownType knownTypes = new KnownType();
        this.readerTypeMetaParser = new ReaderTypeMetaParser(this.processingEnv, knownTypes);
        this.writerTypeMetaParser = new WriterTypeMetaParser(processingEnv, knownTypes);
        this.writerGenerator = new JsonWriterGenerator(this.processingEnv);
        this.readerGenerator = new JsonReaderGenerator(this.processingEnv);
        this.sealedReaderGenerator = new SealedInterfaceReaderGenerator(this.processingEnv);
        this.sealedWriterGenerator = new SealedInterfaceWriterGenerator(this.processingEnv);
        this.enumReaderGenerator = new EnumReaderGenerator();
        this.enumWriterGenerator = new EnumWriterGenerator();
    }

    public void generateReader(TypeElement jsonElement) {
        String readerClassName;
        TypeMirror jsonElementType = jsonElement.asType();
        String packageElement = JsonUtils.jsonClassPackage(this.elements, jsonElement);
        TypeElement readerElement = this.elements.getTypeElement(packageElement + "." + (readerClassName = JsonUtils.jsonReaderName(this.types, jsonElementType)));
        if (readerElement != null) {
            return;
        }
        if (jsonElement.getKind() == ElementKind.ENUM) {
            this.generateEnumReader(jsonElement);
            return;
        }
        if (jsonElement.getModifiers().contains((Object)Modifier.SEALED)) {
            this.generateSealedRootReader(jsonElement);
            return;
        }
        this.generateDtoReader(jsonElement, jsonElementType);
    }

    private void generateSealedRootReader(TypeElement jsonElement) {
        String packageElement = JsonUtils.jsonClassPackage(this.elements, jsonElement);
        TypeSpec sealedReaderType = this.sealedReaderGenerator.generateSealedReader(jsonElement);
        JavaFile javaFile = JavaFile.builder((String)packageElement, (TypeSpec)sealedReaderType).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
    }

    private void generateEnumReader(TypeElement jsonElement) {
        String packageElement = JsonUtils.jsonClassPackage(this.elements, jsonElement);
        TypeSpec sealedReaderType = this.enumReaderGenerator.generateForEnum(jsonElement);
        JavaFile javaFile = JavaFile.builder((String)packageElement, (TypeSpec)sealedReaderType).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
    }

    private void generateDtoReader(TypeElement typeElement, TypeMirror jsonTypeMirror) {
        String packageElement = JsonUtils.jsonClassPackage(this.elements, typeElement);
        JsonClassReaderMeta meta = Objects.requireNonNull(this.readerTypeMetaParser.parse(typeElement, jsonTypeMirror));
        TypeSpec readerType = Objects.requireNonNull(this.readerGenerator.generate(meta));
        JavaFile javaFile = JavaFile.builder((String)packageElement, (TypeSpec)readerType).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
    }

    private void generateEnumWriter(TypeElement jsonElement) {
        String packageElement = JsonUtils.jsonClassPackage(this.elements, jsonElement);
        TypeSpec enumWriterType = this.enumWriterGenerator.generateEnumWriter(jsonElement);
        JavaFile javaFile = JavaFile.builder((String)packageElement, (TypeSpec)enumWriterType).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
    }

    public void generateWriter(TypeElement jsonElement) {
        String writerClassName;
        ComparableTypeMirror wrapper = new ComparableTypeMirror(this.types, jsonElement.asType());
        String packageElement = JsonUtils.jsonClassPackage(this.elements, jsonElement);
        TypeElement writerElement = this.elements.getTypeElement(packageElement + "." + (writerClassName = JsonUtils.jsonWriterName(this.types, wrapper.typeMirror())));
        if (writerElement != null) {
            return;
        }
        if (jsonElement.getKind() == ElementKind.ENUM) {
            this.generateEnumWriter(jsonElement);
            return;
        }
        if (jsonElement.getModifiers().contains((Object)Modifier.SEALED)) {
            this.generateSealedWriter(jsonElement);
            return;
        }
        this.tryGenerateWriter(jsonElement, jsonElement.asType());
    }

    private void generateSealedWriter(TypeElement jsonElement) {
        String packageElement = JsonUtils.jsonClassPackage(this.elements, jsonElement);
        TypeSpec sealedWriterType = this.sealedWriterGenerator.generateSealedWriter(jsonElement, SealedTypeUtils.collectFinalPermittedSubtypes((Types)this.types, (Elements)this.elements, (TypeElement)jsonElement));
        JavaFile javaFile = JavaFile.builder((String)packageElement, (TypeSpec)sealedWriterType).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
    }

    private void tryGenerateWriter(TypeElement jsonElement, TypeMirror jsonTypeMirror) {
        JsonClassWriterMeta meta = Objects.requireNonNull(this.writerTypeMetaParser.parse(jsonElement, jsonTypeMirror));
        String packageElement = JsonUtils.jsonClassPackage(this.elements, jsonElement);
        TypeSpec writerType = Objects.requireNonNull(this.writerGenerator.generate(meta));
        JavaFile javaFile = JavaFile.builder((String)packageElement, (TypeSpec)writerType).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
    }
}

