/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.annotation.processor;

import com.squareup.javapoet.ClassName;
import jakarta.annotation.Nullable;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.json.annotation.processor.JsonTypes;

public class JsonUtils {
    public static String jsonClassPackage(Elements elements, Element typeElement) {
        return elements.getPackageOf(typeElement).getQualifiedName().toString();
    }

    public static String jsonWriterName(Element typeElement) {
        return NameUtils.generatedType((Element)typeElement, (String)"JsonWriter");
    }

    public static String jsonWriterName(Types types, TypeMirror typeMirror) {
        Element typeElement = types.asElement(typeMirror);
        return JsonUtils.jsonWriterName(typeElement);
    }

    public static String jsonReaderName(TypeElement typeElement) {
        return NameUtils.generatedType((Element)typeElement, (String)"JsonReader");
    }

    public static String jsonReaderName(Types types, TypeMirror typeMirror) {
        Element typeElement = types.asElement(typeMirror);
        return JsonUtils.jsonReaderName((TypeElement)typeElement);
    }

    @Nullable
    public static String discriminatorField(Types types, TypeElement element) {
        AnnotationMirror annotation;
        AnnotationMirror annotation2;
        if (element.getModifiers().contains((Object)Modifier.SEALED) && (annotation2 = AnnotationUtils.findAnnotation((Element)element, (ClassName)JsonTypes.jsonDiscriminatorField)) != null) {
            return (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)annotation2, (String)"value");
        }
        Element superClass = types.asElement(element.getSuperclass());
        if (superClass instanceof TypeElement && superClass.getModifiers().contains((Object)Modifier.SEALED) && (annotation = AnnotationUtils.findAnnotation((Element)superClass, (ClassName)JsonTypes.jsonDiscriminatorField)) != null) {
            return (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)annotation, (String)"value");
        }
        for (TypeMirror typeMirror : types.directSupertypes(element.asType())) {
            Element superelement;
            String discriminator;
            if (typeMirror.toString().equals("java.lang.Object") || (discriminator = JsonUtils.discriminatorField(types, (TypeElement)(superelement = types.asElement(typeMirror)))) == null) continue;
            return discriminator;
        }
        return null;
    }

    public static List<String> discriminatorValue(TypeElement element) {
        List value;
        AnnotationMirror annotation = AnnotationUtils.findAnnotation((Element)element, (ClassName)JsonTypes.jsonDiscriminatorValue);
        if (annotation != null && (value = (List)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)annotation, (String)"value")) != null) {
            if (value.isEmpty()) {
                throw new ProcessingErrorException("Discriminator value can't be empty array", (Element)element, annotation);
            }
            return value;
        }
        return List.of(element.getSimpleName().toString());
    }
}

