/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.annotation.processor.reader;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.json.annotation.processor.JsonTypes;
import ru.tinkoff.kora.json.annotation.processor.JsonUtils;
import ru.tinkoff.kora.json.annotation.processor.reader.JsonReaderGenerator;

public class EnumReaderGenerator {
    public TypeSpec generateForEnum(TypeElement typeElement) {
        ClassName typeName = ClassName.get((TypeElement)typeElement);
        EnumValue enumValue = this.detectValueType(typeElement);
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)JsonUtils.jsonReaderName(typeElement)).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{JsonReaderGenerator.class.getCanonicalName()})).build()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)JsonTypes.jsonReader, (TypeName[])new TypeName[]{typeName})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addOriginatingElement((Element)typeElement);
        ParameterizedTypeName delegateType = ParameterizedTypeName.get((ClassName)JsonTypes.enumJsonReader, (TypeName[])new TypeName[]{typeName, enumValue.type.box()});
        typeBuilder.addField((TypeName)delegateType, "delegate", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        typeBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)JsonTypes.jsonReader, (TypeName[])new TypeName[]{enumValue.type.box()}), "valueReader", new Modifier[0]).addCode("this.delegate = new $T<>($T.values(), $T::$N, valueReader);\n", new Object[]{JsonTypes.enumJsonReader, typeName, typeName, enumValue.accessor}).build());
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addException(IOException.class).addParameter((TypeName)JsonTypes.jsonParser, "__parser", new Modifier[0]).returns((TypeName)typeName).addAnnotation(Override.class).addAnnotation(Nullable.class).addCode("return this.delegate.read(__parser);\n", new Object[0]).build());
        return typeBuilder.build();
    }

    private EnumValue detectValueType(TypeElement typeElement) {
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement executableElement;
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC) || element.getModifiers().contains((Object)Modifier.STATIC) || element.getKind() != ElementKind.METHOD || !(element instanceof ExecutableElement) || !(executableElement = (ExecutableElement)element).getParameters().isEmpty() || !AnnotationUtils.isAnnotationPresent((Element)executableElement, (ClassName)JsonTypes.json)) continue;
            TypeName typeName = TypeName.get((TypeMirror)executableElement.getReturnType());
            return new EnumValue(typeName, executableElement.getSimpleName().toString());
        }
        ClassName typeName = ClassName.get(String.class);
        return new EnumValue((TypeName)typeName, "toString");
    }

    record EnumValue(TypeName type, String accessor) {
    }
}

