/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.annotation.processor.writer;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.json.annotation.processor.JsonTypes;
import ru.tinkoff.kora.json.annotation.processor.JsonUtils;

public class SealedInterfaceWriterGenerator {
    private final Types types;
    private final Elements elements;

    public SealedInterfaceWriterGenerator(ProcessingEnvironment processingEnvironment) {
        this.types = processingEnvironment.getTypeUtils();
        this.elements = processingEnvironment.getElementUtils();
    }

    public TypeSpec generateSealedWriter(TypeElement jsonElement, List<? extends Element> jsonElements) {
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)JsonUtils.jsonWriterName(jsonElement)).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{SealedInterfaceWriterGenerator.class.getCanonicalName()})).build()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)JsonTypes.jsonWriter, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)jsonElement.asType())})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addOriginatingElement((Element)jsonElement);
        this.addWriters(typeBuilder, jsonElements);
        for (TypeParameterElement typeParameterElement : jsonElement.getTypeParameters()) {
            typeBuilder.addTypeVariable(TypeVariableName.get((TypeParameterElement)typeParameterElement));
        }
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"write").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addException(IOException.class).addParameter((TypeName)JsonTypes.jsonGenerator, "_gen", new Modifier[0]).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)jsonElement.asType()), (String)"_object", (Modifier[])new Modifier[0]).addAnnotation(Nullable.class).build()).addAnnotation(Override.class);
        method.beginControlFlow("if (_object == null)", new Object[0]).addStatement("_gen.writeNull()", new Object[0]);
        for (Element element : jsonElements) {
            String writerName = this.getWriterFieldName(element);
            TypeMirror elemErasure = this.types.erasure(element.asType());
            method.nextControlFlow("else if (_object instanceof $T _o)", new Object[]{elemErasure}).addStatement("$L.write(_gen, _o)", new Object[]{writerName});
        }
        method.nextControlFlow("else", new Object[0]).addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, "Unsupported class"}).endControlFlow();
        typeBuilder.addMethod(method.build());
        return typeBuilder.build();
    }

    private void addWriters(TypeSpec.Builder typeBuilder, List<? extends Element> jsonElements) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        jsonElements.forEach(elem -> {
            String fieldName = this.getWriterFieldName((Element)elem);
            ParameterizedTypeName fieldType = ParameterizedTypeName.get((ClassName)JsonTypes.jsonWriter, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)elem.asType())});
            FieldSpec.Builder readerField = FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            constructor.addParameter((TypeName)fieldType, fieldName, new Modifier[0]);
            constructor.addStatement("this.$L = $L", new Object[]{fieldName, fieldName});
            typeBuilder.addField(readerField.build());
        });
        typeBuilder.addMethod(constructor.build());
    }

    @Nonnull
    private String getWriterFieldName(Element elem) {
        return CommonUtils.decapitalize((String)(elem.getSimpleName().toString() + "Reader"));
    }
}

