/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.annotation.processor.extension;

import com.squareup.javapoet.ClassName;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.json.annotation.processor.JsonProcessor;
import ru.tinkoff.kora.json.annotation.processor.JsonTypes;
import ru.tinkoff.kora.json.annotation.processor.JsonUtils;
import ru.tinkoff.kora.json.annotation.processor.KnownType;
import ru.tinkoff.kora.json.annotation.processor.reader.ReaderTypeMetaParser;
import ru.tinkoff.kora.json.annotation.processor.writer.WriterTypeMetaParser;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;

public class JsonKoraExtension
implements KoraExtension {
    private final Types types;
    private final Elements elements;
    private final JsonProcessor processor;
    private final TypeMirror jsonWriterErasure;
    private final TypeMirror jsonReaderErasure;
    private final ReaderTypeMetaParser readerTypeMetaParser;
    private final WriterTypeMetaParser writerTypeMetaParser;

    public JsonKoraExtension(ProcessingEnvironment processingEnv) {
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        KnownType knownTypes = new KnownType();
        this.readerTypeMetaParser = new ReaderTypeMetaParser(processingEnv, knownTypes);
        this.writerTypeMetaParser = new WriterTypeMetaParser(processingEnv, knownTypes);
        this.processor = new JsonProcessor(processingEnv);
        this.jsonWriterErasure = this.types.erasure(this.elements.getTypeElement(JsonTypes.jsonWriter.canonicalName()).asType());
        this.jsonReaderErasure = this.types.erasure(this.elements.getTypeElement(JsonTypes.jsonReader.canonicalName()).asType());
    }

    @Nullable
    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tags) {
        if (!tags.isEmpty()) {
            return null;
        }
        TypeMirror erasure = this.types.erasure(typeMirror);
        if (this.types.isSameType(erasure, this.jsonWriterErasure)) {
            DeclaredType writerType = (DeclaredType)typeMirror;
            TypeMirror possibleJsonClass = writerType.getTypeArguments().get(0);
            if (possibleJsonClass.getKind() != TypeKind.DECLARED) {
                return null;
            }
            TypeElement jsonElement = (TypeElement)this.types.asElement(possibleJsonClass);
            if (AnnotationUtils.findAnnotation((Element)jsonElement, (ClassName)JsonTypes.json) != null || AnnotationUtils.findAnnotation((Element)jsonElement, (ClassName)JsonTypes.jsonWriterAnnotation) != null) {
                return KoraExtension.KoraExtensionDependencyGenerator.generatedFrom((Elements)this.elements, (Element)jsonElement, (ClassName)JsonTypes.jsonWriter);
            }
            if (jsonElement.getKind().isInterface()) {
                if (jsonElement.getModifiers().contains((Object)Modifier.SEALED)) {
                    return () -> this.generateWriter(possibleJsonClass);
                }
                return null;
            }
            if (jsonElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                if (jsonElement.getModifiers().contains((Object)Modifier.SEALED)) {
                    return () -> this.generateWriter(possibleJsonClass);
                }
                return null;
            }
            if (jsonElement.getKind() == ElementKind.ENUM) {
                return () -> this.generateWriter(possibleJsonClass);
            }
            try {
                Objects.requireNonNull(this.writerTypeMetaParser.parse(jsonElement, possibleJsonClass));
                return () -> this.generateWriter(possibleJsonClass);
            }
            catch (ProcessingErrorException e2) {
                return null;
            }
        }
        if (this.types.isSameType(erasure, this.jsonReaderErasure)) {
            DeclaredType readerType = (DeclaredType)typeMirror;
            TypeMirror possibleJsonClass = readerType.getTypeArguments().get(0);
            if (possibleJsonClass.getKind() != TypeKind.DECLARED) {
                return null;
            }
            TypeElement jsonElement = (TypeElement)this.types.asElement(possibleJsonClass);
            if (AnnotationUtils.findAnnotation((Element)jsonElement, (ClassName)JsonTypes.json) != null || AnnotationUtils.findAnnotation((Element)jsonElement, (ClassName)JsonTypes.jsonReaderAnnotation) != null || CommonUtils.findConstructors((TypeElement)jsonElement, s -> s.contains((Object)Modifier.PUBLIC)).stream().anyMatch(e -> AnnotationUtils.findAnnotation((Element)e, (ClassName)JsonTypes.jsonReaderAnnotation) != null)) {
                return KoraExtension.KoraExtensionDependencyGenerator.generatedFrom((Elements)this.elements, (Element)jsonElement, (ClassName)JsonTypes.jsonReader);
            }
            if (jsonElement.getKind().isInterface()) {
                if (jsonElement.getModifiers().contains((Object)Modifier.SEALED)) {
                    return () -> this.generateReader(possibleJsonClass);
                }
                return null;
            }
            if (jsonElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                if (jsonElement.getModifiers().contains((Object)Modifier.SEALED)) {
                    return () -> this.generateReader(possibleJsonClass);
                }
                return null;
            }
            if (jsonElement.getKind() == ElementKind.ENUM) {
                return () -> this.generateReader(possibleJsonClass);
            }
            try {
                Objects.requireNonNull(this.readerTypeMetaParser.parse(jsonElement, typeMirror));
                return () -> this.generateReader(possibleJsonClass);
            }
            catch (ProcessingErrorException e3) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    private ExtensionResult generateReader(TypeMirror jsonClass) {
        String resultClassName;
        TypeElement jsonTypeElement = (TypeElement)this.types.asElement(jsonClass);
        String packageElement = this.elements.getPackageOf(jsonTypeElement).getQualifiedName().toString();
        TypeElement resultElement = this.elements.getTypeElement(packageElement + "." + (resultClassName = JsonUtils.jsonReaderName(this.types, jsonClass)));
        if (resultElement != null) {
            return this.buildExtensionResult(resultElement);
        }
        boolean hasJsonConstructor = CommonUtils.findConstructors((TypeElement)jsonTypeElement, s -> !s.contains((Object)Modifier.PRIVATE)).stream().anyMatch(e -> AnnotationUtils.findAnnotation((Element)e, (ClassName)JsonTypes.jsonReaderAnnotation) != null);
        if (hasJsonConstructor || AnnotationUtils.findAnnotation((Element)jsonTypeElement, (ClassName)JsonTypes.jsonReaderAnnotation) != null) {
            return ExtensionResult.nextRound();
        }
        this.processor.generateReader(jsonTypeElement);
        return ExtensionResult.nextRound();
    }

    @Nullable
    private ExtensionResult generateWriter(TypeMirror jsonClass) {
        String resultClassName;
        TypeElement jsonTypeElement = (TypeElement)this.types.asElement(jsonClass);
        String packageElement = this.elements.getPackageOf(jsonTypeElement).getQualifiedName().toString();
        TypeElement resultElement = this.elements.getTypeElement(packageElement + "." + (resultClassName = JsonUtils.jsonWriterName(this.types, jsonClass)));
        if (resultElement != null) {
            return this.buildExtensionResult(resultElement);
        }
        if (AnnotationUtils.findAnnotation((Element)jsonTypeElement, (ClassName)JsonTypes.json) != null || AnnotationUtils.findAnnotation((Element)jsonTypeElement, (ClassName)JsonTypes.jsonWriterAnnotation) != null) {
            return ExtensionResult.nextRound();
        }
        this.processor.generateWriter(jsonTypeElement);
        return ExtensionResult.nextRound();
    }

    private ExtensionResult buildExtensionResult(TypeElement resultElement) {
        ExecutableElement constructor = this.findDefaultConstructor(resultElement);
        return ExtensionResult.fromExecutable((ExecutableElement)constructor);
    }

    private ExecutableElement findDefaultConstructor(TypeElement resultElement) {
        return resultElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).map(ExecutableElement.class::cast).findFirst().orElseThrow();
    }
}

