/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.annotation.processor.reader;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.json.annotation.processor.JsonTypes;
import ru.tinkoff.kora.json.annotation.processor.JsonUtils;
import ru.tinkoff.kora.json.annotation.processor.KnownType;
import ru.tinkoff.kora.json.annotation.processor.reader.JsonClassReaderMeta;
import ru.tinkoff.kora.json.annotation.processor.reader.ReaderFieldType;

public class JsonReaderGenerator {
    private final Types types;

    public JsonReaderGenerator(ProcessingEnvironment processingEnvironment) {
        this.types = processingEnvironment.getTypeUtils();
    }

    @Nullable
    public TypeSpec generate(JsonClassReaderMeta meta) {
        return this.generateForClass(meta);
    }

    private boolean isNullable(JsonClassReaderMeta.FieldMeta field) {
        if (field.parameter().asType().getKind().isPrimitive()) {
            return false;
        }
        return CommonUtils.isNullable((AnnotatedConstruct)field.parameter());
    }

    /*
     * WARNING - void declaration
     */
    private TypeSpec generateForClass(JsonClassReaderMeta meta) {
        int i;
        JsonClassReaderMeta.FieldMeta field;
        void var4_6;
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)JsonUtils.jsonReaderName(meta.typeElement())).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{JsonReaderGenerator.class.getCanonicalName()})).build()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)JsonTypes.jsonReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)meta.typeMirror())})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addOriginatingElement((Element)meta.typeElement());
        for (TypeParameterElement typeParameterElement : meta.typeElement().getTypeParameters()) {
            typeBuilder.addTypeVariable(TypeVariableName.get((TypeParameterElement)typeParameterElement));
        }
        this.addBitSet(typeBuilder, meta);
        this.addReaders(typeBuilder, meta);
        this.addFieldNames(typeBuilder, meta);
        this.addReadMethods(typeBuilder, meta);
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addException(IOException.class).addParameter((TypeName)JsonTypes.jsonParser, "_parser", new Modifier[0]).returns(TypeName.get((TypeMirror)meta.typeElement().asType())).addAnnotation(Override.class).addAnnotation(Nullable.class);
        method.addStatement("var _token = _parser.currentToken()", new Object[0]);
        method.addCode("if (_token == $T.VALUE_NULL) $>\nreturn null;$<\n", new Object[]{JsonTypes.jsonToken});
        this.assertTokenType(method, "START_OBJECT");
        if (meta.fields().size() <= 32) {
            method.addStatement("var _receivedFields = new int[]{NULLABLE_FIELDS_RECEIVED}", new Object[]{BitSet.class});
        } else {
            method.addStatement("var _receivedFields = ($T) NULLABLE_FIELDS_RECEIVED.clone()", new Object[]{BitSet.class});
        }
        method.addCode("\n", new Object[0]);
        this.addFieldVariables(method, meta);
        this.addFastPath(method, meta);
        if (meta.fields().isEmpty()) {
            method.addStatement("_token = _parser.nextToken()", new Object[0]);
        } else {
            method.addStatement("_token = _parser.currentToken()", new Object[0]);
        }
        method.addCode("while (_token != $T.END_OBJECT) {$>\n", new Object[]{JsonTypes.jsonToken});
        this.assertTokenType(method, "FIELD_NAME");
        method.addStatement("var _fieldName = _parser.getCurrentName()", new Object[0]);
        method.addCode("switch (_fieldName) {$>\n", new Object[0]);
        boolean bl = false;
        int fieldsSize = meta.fields().size();
        while (var4_6 < fieldsSize) {
            field = meta.fields().get((int)var4_6);
            method.addCode("case $S -> {$>\n", new Object[]{field.jsonName()});
            method.addCode("$L = $L(_parser, _receivedFields);", new Object[]{field.parameter(), this.readerMethodName(field)});
            method.addCode("$<\n}\n", new Object[0]);
            ++var4_6;
        }
        method.addCode("default -> {$>\n_parser.nextToken();\n_parser.skipChildren();$<\n}", new Object[0]);
        method.addCode("$<\n}\n", new Object[0]);
        method.addCode("_token = _parser.nextToken();", new Object[0]);
        method.addCode("$<\n}\n", new Object[0]);
        CodeBlock.Builder builder = CodeBlock.builder().add("switch (i) {$>", new Object[0]);
        for (i = 0; i < meta.fields().size(); ++i) {
            field = meta.fields().get(i);
            builder.add("\n    case $L -> $S;", new Object[]{i, "%s(%s)".formatted(field.parameter().getSimpleName(), field.jsonName())});
        }
        builder.add("\n    default -> \"\";", new Object[0]);
        builder.add("$<\n    }", new Object[0]);
        if (meta.fields().size() > 32) {
            method.addCode("if (!_receivedFields.equals(ALL_FIELDS_RECEIVED)) {\n  _receivedFields.flip(0, $L);\n  var __error = new $T(\"Some of required json fields were not received:\");\n  for (int i = _receivedFields.nextSetBit(0); i >= 0; i = _receivedFields.nextSetBit(i+1)) {\n    __error.append(\" \").append($L);\n  }\n  throw new $T(_parser, __error.toString());\n}\n", new Object[]{meta.fields().size(), StringBuilder.class, builder.build(), JsonTypes.jsonParseException});
        } else {
            method.addCode("if (_receivedFields[0] != ALL_FIELDS_RECEIVED) {\n  var _nonReceivedFields = (~_receivedFields[0]) & ALL_FIELDS_RECEIVED;\n  var __error = new $T(\"Some of required json fields were not received:\");\n  for (int i = 0; i < $L; i++) {\n    if ((_nonReceivedFields & (1 << i)) != 0) {\n      __error.append(\" \").append($L);\n    }\n  }\n  throw new $T(_parser, __error.toString());\n}\n", new Object[]{StringBuilder.class, meta.fields().size(), builder.build(), JsonTypes.jsonParseException});
        }
        method.addCode("return new $T(", new Object[]{meta.typeElement()});
        for (i = 0; i < meta.fields().size(); ++i) {
            field = meta.fields().get(i);
            method.addCode("$L", new Object[]{field.parameter().getSimpleName()});
            if (i >= meta.fields().size() - 1) continue;
            method.addCode(", ", new Object[0]);
        }
        method.addCode(");", new Object[0]);
        typeBuilder.addMethod(method.build());
        return typeBuilder.build();
    }

    private void addBitSet(TypeSpec.Builder typeBuilder, JsonClassReaderMeta meta) {
        if (meta.fields().size() <= 32) {
            StringBuilder sb = new StringBuilder();
            for (int i = meta.fields().size() - 1; i >= 0; --i) {
                JsonClassReaderMeta.FieldMeta f = meta.fields().get(i);
                sb.append(this.isNullable(f) ? "1" : "0");
            }
            Object nullableFieldsReceived = meta.fields().isEmpty() ? "0" : "0b" + sb;
            String allFieldsReceived = meta.fields().isEmpty() ? "0" : "0b" + "1".repeat(meta.fields().size());
            typeBuilder.addField(FieldSpec.builder((TypeName)TypeName.INT, (String)"ALL_FIELDS_RECEIVED", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.of((String)allFieldsReceived, (Object[])new Object[0])).build()).addField(FieldSpec.builder((TypeName)TypeName.INT, (String)"NULLABLE_FIELDS_RECEIVED", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.of((String)nullableFieldsReceived, (Object[])new Object[0])).build());
        } else {
            typeBuilder.addField((TypeName)ClassName.get(BitSet.class), "ALL_FIELDS_RECEIVED", new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addField((TypeName)ClassName.get(BitSet.class), "NULLABLE_FIELDS_RECEIVED", new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
            CodeBlock.Builder fieldReceivedInitBlock = CodeBlock.builder().add("ALL_FIELDS_RECEIVED = new $T($L);\nALL_FIELDS_RECEIVED.set(0, $L);\nNULLABLE_FIELDS_RECEIVED = new $T($L);\n", new Object[]{BitSet.class, meta.fields().size(), meta.fields().size(), BitSet.class, meta.fields().size()});
            for (int i = 0; i < meta.fields().size(); ++i) {
                JsonClassReaderMeta.FieldMeta field = meta.fields().get(i);
                if (!this.isNullable(field)) continue;
                fieldReceivedInitBlock.add("NULLABLE_FIELDS_RECEIVED.set($L);\n", new Object[]{i});
            }
            typeBuilder.addStaticBlock(fieldReceivedInitBlock.build());
        }
    }

    private void addFastPath(MethodSpec.Builder method, JsonClassReaderMeta meta) {
        int i;
        for (i = 0; i < meta.fields().size(); ++i) {
            JsonClassReaderMeta.FieldMeta field = meta.fields().get(i);
            method.addCode("if (_parser.nextFieldName($L)) {$>\n", new Object[]{this.jsonNameStaticName(field)});
            method.addCode("$L = $L(_parser, _receivedFields);\n", new Object[]{field.parameter(), this.readerMethodName(field)});
            if (i != meta.fields().size() - 1) continue;
            method.addCode("_token = _parser.nextToken();\nwhile (_token != JsonToken.END_OBJECT) {\n    _parser.nextToken();\n    _parser.skipChildren();\n    _token = _parser.nextToken();\n}\n", new Object[0]);
            method.addCode("return new $T(", new Object[]{meta.typeMirror()});
            for (int j = 0; j < meta.fields().size(); ++j) {
                method.addCode("$L", new Object[]{meta.fields().get(j).parameter()});
                if (j >= meta.fields().size() - 1) continue;
                method.addCode(", ", new Object[0]);
            }
            method.addCode(");$<\n", new Object[0]);
        }
        for (i = 0; i < meta.fields().size(); ++i) {
            method.addCode("}", new Object[0]);
            if (i < meta.fields().size() - 1) {
                method.addCode("$<", new Object[0]);
            }
            method.addCode("\n", new Object[0]);
        }
    }

    private void addFieldVariables(MethodSpec.Builder method, JsonClassReaderMeta meta) {
        for (int i = 0; i < meta.fields().size(); ++i) {
            JsonClassReaderMeta.FieldMeta field = meta.fields().get(i);
            method.addCode("$T $L", new Object[]{field.parameter(), field.parameter().getSimpleName()});
            TypeMirror parameterType = field.parameter().asType();
            if (parameterType instanceof PrimitiveType) {
                if (parameterType.toString().equals("boolean")) {
                    method.addCode(" = false;\n", new Object[0]);
                    continue;
                }
                method.addCode(" = 0;\n", new Object[0]);
                continue;
            }
            method.addCode(" = null;\n", new Object[0]);
        }
    }

    private void addReadMethods(TypeSpec.Builder typeBuilder, JsonClassReaderMeta meta) {
        List<JsonClassReaderMeta.FieldMeta> fields = meta.fields();
        for (int i = 0; i < fields.size(); ++i) {
            typeBuilder.addMethod(this.readParamMethod(i, fields.size(), fields.get(i)));
        }
    }

    private void addFieldNames(TypeSpec.Builder typeBuilder, JsonClassReaderMeta meta) {
        for (JsonClassReaderMeta.FieldMeta field : meta.fields()) {
            typeBuilder.addField(FieldSpec.builder((TypeName)JsonTypes.serializedString, (String)this.jsonNameStaticName(field), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.of((String)"new $T($S)", (Object[])new Object[]{JsonTypes.serializedString, field.jsonName()})).build());
        }
    }

    private void addReaders(TypeSpec.Builder typeBuilder, JsonClassReaderMeta classMeta) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (JsonClassReaderMeta.FieldMeta field : classMeta.fields()) {
            FieldSpec.Builder readerField;
            TypeName fieldType;
            String fieldName;
            if (field.reader() == null && field.typeMeta() instanceof ReaderFieldType.KnownTypeReaderMeta) continue;
            if (field.reader() != null) {
                fieldName = this.readerFieldName(field);
                fieldType = TypeName.get((TypeMirror)field.reader());
                readerField = FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                TypeElement readerElement = (TypeElement)this.types.asElement(field.reader());
                if (CommonUtils.hasDefaultConstructorAndFinal((TypeElement)readerElement)) {
                    readerField.addModifiers(new Modifier[]{Modifier.STATIC});
                    readerField.initializer("new $T()", new Object[]{field.reader()});
                    typeBuilder.addField(readerField.build());
                    continue;
                }
                typeBuilder.addField(readerField.build());
                constructor.addParameter(fieldType, fieldName, new Modifier[0]);
                constructor.addStatement("this.$L = $L", new Object[]{fieldName, fieldName});
                continue;
            }
            if (!(field.typeMeta() instanceof ReaderFieldType.UnknownTypeReaderMeta)) continue;
            fieldName = this.readerFieldName(field);
            fieldType = ParameterizedTypeName.get((ClassName)JsonTypes.jsonReader, (TypeName[])new TypeName[]{field.typeName()});
            readerField = FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            constructor.addParameter(fieldType, fieldName, new Modifier[0]);
            constructor.addStatement("this.$L = $L", new Object[]{fieldName, fieldName});
            typeBuilder.addField(readerField.build());
        }
        typeBuilder.addMethod(constructor.build());
    }

    private String readerFieldName(JsonClassReaderMeta.FieldMeta field) {
        return field.parameter().getSimpleName() + "Reader";
    }

    private MethodSpec readParamMethod(int index, int size, JsonClassReaderMeta.FieldMeta field) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)this.readerMethodName(field)).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)JsonTypes.jsonParser, "_parser", new Modifier[0]).addException(IOException.class).addParameter((TypeName)(size > 32 ? TypeName.get(BitSet.class) : ArrayTypeName.of((TypeName)TypeName.INT)), "_receivedFields", new Modifier[0]).returns(field.typeName());
        if (field.reader() != null) {
            method.addCode("var _token = _parser.nextToken();\n", new Object[0]);
            if (!this.isNullable(field)) {
                method.addCode("if (_token == $T.VALUE_NULL)\n  throw new $T(_parser, $S);\n", new Object[]{JsonTypes.jsonToken, JsonTypes.jsonParseException, "Expecting nonnull value for field %s, got VALUE_NULL token".formatted(field.jsonName())});
                if (size > 32) {
                    method.addCode("_receivedFields.set($L);\n", new Object[]{index});
                } else {
                    method.addCode("_receivedFields[0] = _receivedFields[0] | (1 << $L);\n", new Object[]{index});
                }
            }
            method.addCode("return $L.read(_parser);\n", new Object[]{this.readerFieldName(field)});
            return method.build();
        }
        method.addStatement("var _token = _parser.nextToken()", new Object[0]);
        ReaderFieldType readerFieldType = field.typeMeta();
        if (readerFieldType instanceof ReaderFieldType.KnownTypeReaderMeta) {
            ReaderFieldType.KnownTypeReaderMeta meta = (ReaderFieldType.KnownTypeReaderMeta)readerFieldType;
            method.addModifiers(new Modifier[]{Modifier.STATIC});
            CodeBlock.Builder block = CodeBlock.builder();
            if (size > 32) {
                block.add("_receivedFields.set($L);\n", new Object[]{index});
            } else {
                block.add("_receivedFields[0] = _receivedFields[0] | (1 << $L);\n", new Object[]{index});
            }
            block.add(this.readKnownType(field.jsonName(), CodeBlock.of((String)"return ", (Object[])new Object[0]), meta.knownType(), this.isNullable(field), meta.typeMirror()));
            method.addCode(block.build());
            return method.build();
        }
        if (this.isNullable(field)) {
            method.addCode("if (_token == $T.VALUE_NULL) {\n  return null;\n}\n", new Object[]{JsonTypes.jsonToken});
        } else {
            method.addCode("if (_token == $T.VALUE_NULL)\n  throw new $T(_parser, $S);\n", new Object[]{JsonTypes.jsonToken, JsonTypes.jsonParseException, "Expecting nonnull value for field %s, got VALUE_NULL token".formatted(field.jsonName())});
            if (size > 32) {
                method.addCode("_receivedFields.set($L);\n", new Object[]{index});
            } else {
                method.addCode("_receivedFields[0] = _receivedFields[0] | (1 << $L);\n", new Object[]{index});
            }
        }
        method.addStatement("return $L.read(_parser)", new Object[]{this.readerFieldName(field)});
        return method.build();
    }

    private String readerMethodName(JsonClassReaderMeta.FieldMeta field) {
        return "read_" + field.parameter().getSimpleName().toString();
    }

    private CodeBlock readKnownType(String jsonName, CodeBlock parameterName, KnownType.KnownTypesEnum knownType, boolean nullable, TypeMirror typeMirror) {
        CodeBlock.Builder method = CodeBlock.builder();
        CodeBlock code = switch (knownType) {
            default -> throw new IncompatibleClassChangeError();
            case KnownType.KnownTypesEnum.STRING -> CodeBlock.of((String)"if (_token == $T.VALUE_STRING) {\n  $L _parser.getText();\n}\n", (Object[])new Object[]{JsonTypes.jsonToken, parameterName});
            case KnownType.KnownTypesEnum.BOOLEAN_OBJECT, KnownType.KnownTypesEnum.BOOLEAN_PRIMITIVE -> CodeBlock.of((String)"if (_token == $T.VALUE_TRUE) {\n  $L true;\n} else if (_token == $T.VALUE_FALSE) {\n  $L false;\n}\n", (Object[])new Object[]{JsonTypes.jsonToken, parameterName, JsonTypes.jsonToken, parameterName});
            case KnownType.KnownTypesEnum.INTEGER_OBJECT, KnownType.KnownTypesEnum.INTEGER_PRIMITIVE -> CodeBlock.of((String)"if (_token == $T.VALUE_NUMBER_INT) {\n  $L _parser.getIntValue();\n}\n", (Object[])new Object[]{JsonTypes.jsonToken, parameterName});
            case KnownType.KnownTypesEnum.BIG_INTEGER -> CodeBlock.of((String)"if (_token == $T.VALUE_NUMBER_INT) {\n  $L _parser.getBigIntegerValue();\n}\n", (Object[])new Object[]{JsonTypes.jsonToken, parameterName});
            case KnownType.KnownTypesEnum.BIG_DECIMAL -> CodeBlock.of((String)"if (_token == $T.VALUE_NUMBER_INT || _token == $T.VALUE_NUMBER_FLOAT) {\n  $L _parser.getDecimalValue();\n}\n", (Object[])new Object[]{JsonTypes.jsonToken, JsonTypes.jsonToken, parameterName});
            case KnownType.KnownTypesEnum.DOUBLE_OBJECT, KnownType.KnownTypesEnum.DOUBLE_PRIMITIVE -> CodeBlock.of((String)"if (_token == $T.VALUE_NUMBER_FLOAT || _token == $T.VALUE_NUMBER_INT) {\n  $L _parser.getDoubleValue();\n}\n", (Object[])new Object[]{JsonTypes.jsonToken, JsonTypes.jsonToken, parameterName});
            case KnownType.KnownTypesEnum.FLOAT_OBJECT, KnownType.KnownTypesEnum.FLOAT_PRIMITIVE -> CodeBlock.of((String)"if (_token == $T.VALUE_NUMBER_FLOAT || _token == $T.VALUE_NUMBER_INT) {\n  $L _parser.getFloatValue();\n}\n", (Object[])new Object[]{JsonTypes.jsonToken, JsonTypes.jsonToken, parameterName});
            case KnownType.KnownTypesEnum.LONG_OBJECT, KnownType.KnownTypesEnum.LONG_PRIMITIVE -> CodeBlock.of((String)"if (_token == $T.VALUE_NUMBER_INT) {\n  $L _parser.getLongValue();\n}\n", (Object[])new Object[]{JsonTypes.jsonToken, parameterName});
            case KnownType.KnownTypesEnum.SHORT_OBJECT, KnownType.KnownTypesEnum.SHORT_PRIMITIVE -> CodeBlock.of((String)"if (_token == $T.VALUE_NUMBER_INT) {\n  $L _parser.getShortValue();\n}\n", (Object[])new Object[]{JsonTypes.jsonToken, parameterName});
            case KnownType.KnownTypesEnum.BINARY -> CodeBlock.of((String)"if (_token == $T.VALUE_STRING) {\n  $L _parser.getBinaryValue();\n}\n", (Object[])new Object[]{JsonTypes.jsonToken, parameterName});
            case KnownType.KnownTypesEnum.UUID -> CodeBlock.of((String)"if (_token == $T.VALUE_STRING) {\n  $L $T.fromString(_parser.getText());\n}\n", (Object[])new Object[]{JsonTypes.jsonToken, parameterName, UUID.class});
        };
        method.add(code);
        if (nullable) {
            method.add("else if (_token == $T.VALUE_NULL) {$>\n$L null;}$<\n", new Object[]{JsonTypes.jsonToken, parameterName});
        }
        method.add("else {$>\nthrow new $T(_parser, $S + _token);$<\n}", new Object[]{JsonTypes.jsonParseException, "Expecting %s token for field '%s', got ".formatted(Arrays.toString(this.expectedTokens(knownType, nullable)), jsonName)});
        return method.build();
    }

    private String[] expectedTokens(KnownType.KnownTypesEnum knownType, boolean nullable) {
        String[] stringArray;
        switch (knownType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case STRING: 
            case BINARY: 
            case UUID: {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "VALUE_STRING";
                break;
            }
            case BOOLEAN_OBJECT: 
            case BOOLEAN_PRIMITIVE: {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "VALUE_TRUE";
                stringArray = stringArray3;
                stringArray3[1] = "VALUE_FALSE";
                break;
            }
            case INTEGER_OBJECT: 
            case INTEGER_PRIMITIVE: 
            case BIG_INTEGER: 
            case LONG_OBJECT: 
            case LONG_PRIMITIVE: 
            case SHORT_OBJECT: 
            case SHORT_PRIMITIVE: {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = "VALUE_NUMBER_INT";
                break;
            }
            case BIG_DECIMAL: 
            case DOUBLE_OBJECT: 
            case DOUBLE_PRIMITIVE: 
            case FLOAT_OBJECT: 
            case FLOAT_PRIMITIVE: {
                String[] stringArray5 = new String[2];
                stringArray5[0] = "VALUE_NUMBER_FLOAT";
                stringArray = stringArray5;
                stringArray5[1] = "VALUE_NUMBER_INT";
            }
        }
        String[] result = stringArray;
        if (nullable) {
            result = Arrays.copyOf(result, result.length + 1);
            result[result.length - 1] = "VALUE_NULL";
        }
        return result;
    }

    private void assertTokenType(MethodSpec.Builder method, String expectedToken) {
        method.addCode("if (_token != $T.$L) $>\nthrow new $T(_parser, $S + _token);$<\n", new Object[]{JsonTypes.jsonToken, expectedToken, JsonTypes.jsonParseException, "Expecting %s token, got ".formatted(expectedToken)});
    }

    private String jsonNameStaticName(JsonClassReaderMeta.FieldMeta field) {
        return "_" + field.parameter().getSimpleName().toString() + "_optimized_field_name";
    }
}

