/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.annotation.processor.reader;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.common.naming.NameConverter;
import ru.tinkoff.kora.json.annotation.processor.JsonTypes;
import ru.tinkoff.kora.json.annotation.processor.KnownType;
import ru.tinkoff.kora.json.annotation.processor.reader.JsonClassReaderMeta;
import ru.tinkoff.kora.json.annotation.processor.reader.ReaderFieldType;

public class ReaderTypeMetaParser {
    private final ProcessingEnvironment env;
    private final Elements elements;
    private final KnownType knownTypes;

    public ReaderTypeMetaParser(ProcessingEnvironment env, KnownType knownTypes) {
        this.env = env;
        this.elements = env.getElementUtils();
        this.knownTypes = knownTypes;
    }

    public JsonClassReaderMeta parse(TypeElement jsonClass, TypeMirror typeMirror) throws ProcessingErrorException {
        if (jsonClass.getKind() != ElementKind.CLASS && jsonClass.getKind() != ElementKind.RECORD) {
            throw new IllegalArgumentException("Should not be called for non class elements");
        }
        if (jsonClass.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new IllegalArgumentException("Should not be called for abstract elements");
        }
        ExecutableElement jsonConstructor = Objects.requireNonNull(this.findJsonConstructor(jsonClass));
        ArrayList<JsonClassReaderMeta.FieldMeta> fields = new ArrayList<JsonClassReaderMeta.FieldMeta>(jsonConstructor.getParameters().size());
        NameConverter nameConverter = CommonUtils.getNameConverter((TypeElement)jsonClass);
        for (VariableElement variableElement : jsonConstructor.getParameters()) {
            JsonClassReaderMeta.FieldMeta fieldMeta = this.parseField(jsonClass, variableElement, nameConverter);
            fields.add(fieldMeta);
        }
        return new JsonClassReaderMeta(typeMirror, jsonClass, fields);
    }

    @Nullable
    public ReaderFieldType parseReaderFieldType(TypeMirror jsonClass) {
        KnownType.KnownTypesEnum knownType = this.knownTypes.detect(jsonClass);
        if (knownType != null) {
            return new ReaderFieldType.KnownTypeReaderMeta(knownType, jsonClass);
        }
        return new ReaderFieldType.UnknownTypeReaderMeta(jsonClass);
    }

    private ExecutableElement findJsonConstructor(TypeElement typeElement) {
        List<ExecutableElement> constructors = typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC)).map(ExecutableElement.class::cast).toList();
        if (constructors.isEmpty()) {
            throw new ProcessingErrorException("Class: %s\nIn order to generate JsonReader class must have one public constructor or constructor annotated with any of @Json/@JsonReader".formatted(typeElement), (Element)typeElement);
        }
        if (constructors.size() == 1) {
            return constructors.get(0);
        }
        List<ExecutableElement> jsonReaderConstructors = constructors.stream().filter(e -> AnnotationUtils.findAnnotation((Element)e, (ClassName)JsonTypes.jsonReaderAnnotation) != null).toList();
        if (jsonReaderConstructors.size() == 1) {
            return jsonReaderConstructors.get(0);
        }
        if (!jsonReaderConstructors.isEmpty()) {
            throw new ProcessingErrorException("Class: %s\nIn order to generate JsonReader class must have one public constructor or constructor annotated with any of @Json/@JsonReader".formatted(typeElement), (Element)typeElement);
        }
        List<ExecutableElement> jsonConstructors = constructors.stream().filter(e -> AnnotationUtils.findAnnotation((Element)e, (ClassName)JsonTypes.json) != null).toList();
        if (jsonConstructors.size() == 1) {
            return jsonConstructors.get(0);
        }
        if (!jsonConstructors.isEmpty()) {
            throw new ProcessingErrorException("Class: %s\nIn order to generate JsonReader class must have one public constructor or constructor annotated with any of @Json/@JsonReader".formatted(typeElement), (Element)typeElement);
        }
        List<ExecutableElement> nonEmpty = constructors.stream().filter(c -> !c.getParameters().isEmpty()).toList();
        if (nonEmpty.size() == 1) {
            return nonEmpty.get(0);
        }
        throw new ProcessingErrorException("Class: %s\nIn order to generate JsonReader class must have one public constructor or constructor annotated with any of @Json/@JsonReader".formatted(typeElement), (Element)typeElement);
    }

    private JsonClassReaderMeta.FieldMeta parseField(TypeElement jsonClass, VariableElement parameter, NameConverter nameConverter) {
        AnnotationMirror jsonField = this.findJsonField(jsonClass, parameter);
        String jsonName = this.parseJsonName(parameter, jsonField, nameConverter);
        TypeMirror reader = (TypeMirror)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)jsonField, (String)"reader");
        ReaderFieldType typeMeta = this.parseReaderFieldType(parameter.asType());
        return new JsonClassReaderMeta.FieldMeta(parameter, jsonName, TypeName.get((TypeMirror)parameter.asType()), typeMeta, reader);
    }

    @Nullable
    private AnnotationMirror findJsonField(TypeElement jsonClass, VariableElement param) {
        AnnotationMirror paramJsonField = AnnotationUtils.findAnnotation((Element)param, (ClassName)JsonTypes.jsonFieldAnnotation);
        if (paramJsonField != null) {
            return paramJsonField;
        }
        for (Element element : jsonClass.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || !element.getSimpleName().toString().equals(param.getSimpleName().toString())) continue;
            return AnnotationUtils.findAnnotation((Element)element, (ClassName)JsonTypes.jsonFieldAnnotation);
        }
        return null;
    }

    private String parseJsonName(VariableElement param, @Nullable AnnotationMirror jsonField, @Nullable NameConverter nameConverter) {
        if (jsonField == null) {
            if (nameConverter != null) {
                return nameConverter.convert(param.getSimpleName().toString());
            }
            return param.getSimpleName().toString();
        }
        String jsonFieldValue = (String)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)jsonField, (String)"value");
        if (jsonFieldValue != null && !jsonFieldValue.isBlank()) {
            return jsonFieldValue;
        }
        return param.getSimpleName().toString();
    }
}

