/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.annotation.processor.reader;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.SealedTypeUtils;
import ru.tinkoff.kora.json.annotation.processor.JsonTypes;
import ru.tinkoff.kora.json.annotation.processor.JsonUtils;

public class SealedInterfaceReaderGenerator {
    private final Types types;
    private final Elements elements;

    public SealedInterfaceReaderGenerator(ProcessingEnvironment processingEnvironment) {
        this.types = processingEnvironment.getTypeUtils();
        this.elements = processingEnvironment.getElementUtils();
    }

    /*
     * WARNING - void declaration
     */
    public TypeSpec generateSealedReader(TypeElement jsonElement) {
        void var5_8;
        String typeName = JsonUtils.jsonReaderName(jsonElement);
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)typeName).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{SealedInterfaceReaderGenerator.class.getCanonicalName()})).build()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)JsonTypes.jsonReader, (TypeName[])new TypeName[]{ClassName.get((TypeElement)jsonElement)})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addOriginatingElement((Element)jsonElement);
        for (TypeParameterElement typeParameterElement : jsonElement.getTypeParameters()) {
            typeBuilder.addTypeVariable(TypeVariableName.get((TypeParameterElement)typeParameterElement));
        }
        List permittedSubclasses = SealedTypeUtils.collectFinalPermittedSubtypes((Types)this.types, (Elements)this.elements, (TypeElement)jsonElement);
        this.addReaders(typeBuilder, permittedSubclasses);
        String string = JsonUtils.discriminatorField(this.types, jsonElement);
        if (string == null) {
            String string2 = "@type";
        }
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addException(IOException.class).addParameter((TypeName)JsonTypes.jsonParser, "_parser", new Modifier[0]).returns((TypeName)ClassName.get((TypeElement)jsonElement)).addAnnotation(Override.class).addAnnotation(Nullable.class);
        method.addCode("var bufferingParser = new $T(_parser);\n", new Object[]{JsonTypes.bufferingJsonParser});
        method.addCode("var discriminator = $T.readStringDiscriminator(bufferingParser, $S);\n", new Object[]{JsonTypes.discriminatorHelper, var5_8});
        method.addCode("if (discriminator == null) throw new $T(_parser, $S);\n", new Object[]{JsonTypes.jsonParseException, "Discriminator required, but not provided"});
        method.addCode("var bufferedParser = $T.createFlattened(false, bufferingParser.reset(), _parser);\n", new Object[]{JsonTypes.jsonParserSequence});
        method.addCode("bufferedParser.nextToken();\n", new Object[0]);
        method.addCode("return switch(discriminator) {$>\n", new Object[0]);
        for (TypeElement elem : permittedSubclasses) {
            String readerName = this.getReaderFieldName(elem);
            List<String> discriminatorValues = JsonUtils.discriminatorValue(elem);
            for (String discriminatorValue : discriminatorValues) {
                method.addCode("case $S -> $L.read(bufferedParser);\n", new Object[]{discriminatorValue, readerName});
            }
        }
        method.addCode("default -> throw new $T(_parser, $S + discriminator + \"'\");$<\n};", new Object[]{JsonTypes.jsonParseException, "Unknown discriminator: '"});
        typeBuilder.addMethod(method.build());
        return typeBuilder.build();
    }

    private void addReaders(TypeSpec.Builder typeBuilder, List<? extends Element> jsonElements) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        jsonElements.forEach(elem -> {
            String fieldName = this.getReaderFieldName((Element)elem);
            ParameterizedTypeName fieldType = ParameterizedTypeName.get((ClassName)JsonTypes.jsonReader, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)elem.asType())});
            FieldSpec.Builder readerField = FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            constructor.addParameter((TypeName)fieldType, fieldName, new Modifier[0]);
            constructor.addStatement("this.$L = $L", new Object[]{fieldName, fieldName});
            typeBuilder.addField(readerField.build());
        });
        typeBuilder.addMethod(constructor.build());
    }

    @Nonnull
    private String getReaderFieldName(Element elem) {
        return CommonUtils.decapitalize((String)(elem.getSimpleName().toString() + "Reader"));
    }
}

