/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.annotation.processor.writer;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.json.annotation.processor.JsonTypes;
import ru.tinkoff.kora.json.annotation.processor.JsonUtils;
import ru.tinkoff.kora.json.annotation.processor.KnownType;
import ru.tinkoff.kora.json.annotation.processor.writer.JsonClassWriterMeta;
import ru.tinkoff.kora.json.annotation.processor.writer.WriterFieldType;

public class JsonWriterGenerator {
    private final Types types;

    public JsonWriterGenerator(ProcessingEnvironment processingEnvironment) {
        this.types = processingEnvironment.getTypeUtils();
    }

    @Nullable
    public TypeSpec generate(JsonClassWriterMeta meta) {
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)JsonUtils.jsonWriterName(meta.typeElement())).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{JsonWriterGenerator.class.getCanonicalName()})).build()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)JsonTypes.jsonWriter, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)meta.typeElement().asType())})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addOriginatingElement((Element)meta.typeElement());
        for (TypeParameterElement typeParameterElement : meta.typeElement().getTypeParameters()) {
            typeBuilder.addTypeVariable(TypeVariableName.get((TypeParameterElement)typeParameterElement));
        }
        this.addWriters(typeBuilder, meta);
        for (JsonClassWriterMeta.FieldMeta fieldMeta : meta.fields()) {
            typeBuilder.addField(FieldSpec.builder((TypeName)JsonTypes.serializedString, (String)this.jsonNameStaticName(fieldMeta), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.of((String)"new $T($S)", (Object[])new Object[]{JsonTypes.serializedString, fieldMeta.jsonName()})).build());
        }
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"write").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addException(IOException.class).addParameter((TypeName)JsonTypes.jsonGenerator, "_gen", new Modifier[0]).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)meta.typeMirror()), (String)"_object", (Modifier[])new Modifier[0]).addAnnotation(Nullable.class).build()).addAnnotation(Override.class);
        method.addCode("if (_object == null) {$>\n_gen.writeNull();\nreturn;$<\n}\n", new Object[0]);
        method.addStatement("_gen.writeStartObject(_object)", new Object[0]);
        String string = JsonUtils.discriminatorField(this.types, meta.typeElement());
        if (string != null && meta.fields().stream().noneMatch(f -> f.jsonName().equals(discriminatorField))) {
            List<String> discriminatorFieldValues = JsonUtils.discriminatorValue(meta.typeElement());
            method.addCode("_gen.writeFieldName($S);\n", new Object[]{string});
            method.addStatement("_gen.writeString($S)", new Object[]{discriminatorFieldValues.get(0)});
        }
        for (JsonClassWriterMeta.FieldMeta field : meta.fields()) {
            this.addWriteParam(method, field);
        }
        method.addStatement("_gen.writeEndObject()", new Object[0]);
        typeBuilder.addMethod(method.build());
        return typeBuilder.build();
    }

    private void addWriters(TypeSpec.Builder typeBuilder, JsonClassWriterMeta classMeta) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (JsonClassWriterMeta.FieldMeta field : classMeta.fields()) {
            FieldSpec.Builder writerField;
            TypeName fieldType;
            String fieldName;
            if (field.writer() != null) {
                List<Element> constructors;
                fieldName = this.writerFieldName(field);
                fieldType = TypeName.get((TypeMirror)field.writer());
                writerField = FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                TypeElement writerElement = (TypeElement)this.types.asElement(field.writer());
                if (writerElement.getModifiers().contains((Object)Modifier.FINAL) && (constructors = writerElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).toList()).size() == 1) {
                    writerField.addModifiers(new Modifier[]{Modifier.STATIC});
                    writerField.initializer("new $T()", new Object[]{field.writer()});
                    typeBuilder.addField(writerField.build());
                    continue;
                }
                typeBuilder.addField(writerField.build());
                constructor.addParameter(fieldType, fieldName, new Modifier[0]);
                constructor.addStatement("this.$L = $L", new Object[]{fieldName, fieldName});
                continue;
            }
            if (!(field.writerTypeMeta() instanceof WriterFieldType.UnknownWriterFieldType)) continue;
            fieldName = this.writerFieldName(field);
            fieldType = ParameterizedTypeName.get((ClassName)JsonTypes.jsonWriter, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)field.typeMirror())});
            writerField = FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            typeBuilder.addField(writerField.build());
            constructor.addParameter(fieldType, fieldName, new Modifier[0]);
            constructor.addStatement("this.$L = $L", new Object[]{fieldName, fieldName});
        }
        typeBuilder.addMethod(constructor.build());
    }

    private String writerFieldName(JsonClassWriterMeta.FieldMeta field) {
        return field.accessor().getSimpleName() + "Writer";
    }

    private void addWriteParam(MethodSpec.Builder method, JsonClassWriterMeta.FieldMeta field) {
        WriterFieldType writerFieldType;
        boolean isEmptyCheck;
        if (field.typeMirror().getKind().isPrimitive()) {
            WriterFieldType writerFieldType2;
            method.addCode("_gen.writeFieldName($L);\n", new Object[]{this.jsonNameStaticName(field)});
            if (field.writer() == null && (writerFieldType2 = field.writerTypeMeta()) instanceof WriterFieldType.KnownWriterFieldType) {
                WriterFieldType.KnownWriterFieldType typeMeta = (WriterFieldType.KnownWriterFieldType)writerFieldType2;
                method.addCode(this.writeKnownType(typeMeta.knownType(), CodeBlock.of((String)"_object.$L", (Object[])new Object[]{field.accessor()})));
            } else {
                method.addStatement("$L.write(_gen, _object.$L)", new Object[]{this.writerFieldName(field), field.accessor()});
            }
            return;
        }
        boolean bl = isEmptyCheck = field.includeType() == JsonClassWriterMeta.IncludeType.NON_EMPTY && (CommonUtils.isCollection((TypeMirror)field.typeMirror()) || CommonUtils.isMap((TypeMirror)field.typeMirror()));
        if (isEmptyCheck) {
            method.addCode("if (_object.$L != null && !_object.$L.isEmpty()) {$>\n", new Object[]{field.accessor(), field.accessor()});
        } else if (field.includeType() != JsonClassWriterMeta.IncludeType.ALWAYS) {
            method.addCode("if (_object.$L != null) {$>\n", new Object[]{field.accessor()});
        }
        method.addCode("_gen.writeFieldName($L);\n", new Object[]{this.jsonNameStaticName(field)});
        if (field.writer() == null && (writerFieldType = field.writerTypeMeta()) instanceof WriterFieldType.KnownWriterFieldType) {
            WriterFieldType.KnownWriterFieldType typeMeta = (WriterFieldType.KnownWriterFieldType)writerFieldType;
            if (field.includeType() == JsonClassWriterMeta.IncludeType.ALWAYS) {
                method.beginControlFlow("if (_object.$L == null)", new Object[]{field.accessor()});
                method.addCode("_gen.writeNull();\n", new Object[0]);
                method.nextControlFlow("else", new Object[0]);
                method.addCode(this.writeKnownType(typeMeta.knownType(), CodeBlock.of((String)"_object.$L", (Object[])new Object[]{field.accessor()})));
                method.endControlFlow();
            } else {
                method.addCode(this.writeKnownType(typeMeta.knownType(), CodeBlock.of((String)"_object.$L", (Object[])new Object[]{field.accessor()})));
            }
        } else {
            method.addStatement("$L.write(_gen, _object.$L)", new Object[]{this.writerFieldName(field), field.accessor()});
        }
        if (field.includeType() != JsonClassWriterMeta.IncludeType.ALWAYS) {
            method.addCode("$<}\n", new Object[0]);
        }
    }

    private String jsonNameStaticName(JsonClassWriterMeta.FieldMeta field) {
        return "_" + field.field().getSimpleName().toString() + "_optimized_field_name";
    }

    private CodeBlock writeKnownType(KnownType.KnownTypesEnum knownType, CodeBlock value) {
        return switch (knownType) {
            default -> throw new IncompatibleClassChangeError();
            case KnownType.KnownTypesEnum.STRING -> CodeBlock.of((String)"_gen.writeString($L);\n", (Object[])new Object[]{value});
            case KnownType.KnownTypesEnum.BOOLEAN_OBJECT, KnownType.KnownTypesEnum.BOOLEAN_PRIMITIVE -> CodeBlock.of((String)"_gen.writeBoolean($L);\n", (Object[])new Object[]{value});
            case KnownType.KnownTypesEnum.INTEGER_OBJECT, KnownType.KnownTypesEnum.BIG_INTEGER, KnownType.KnownTypesEnum.BIG_DECIMAL, KnownType.KnownTypesEnum.DOUBLE_OBJECT, KnownType.KnownTypesEnum.FLOAT_OBJECT, KnownType.KnownTypesEnum.LONG_OBJECT, KnownType.KnownTypesEnum.SHORT_OBJECT, KnownType.KnownTypesEnum.INTEGER_PRIMITIVE, KnownType.KnownTypesEnum.DOUBLE_PRIMITIVE, KnownType.KnownTypesEnum.FLOAT_PRIMITIVE, KnownType.KnownTypesEnum.LONG_PRIMITIVE, KnownType.KnownTypesEnum.SHORT_PRIMITIVE -> CodeBlock.of((String)"_gen.writeNumber($L);\n", (Object[])new Object[]{value});
            case KnownType.KnownTypesEnum.BINARY -> CodeBlock.of((String)"_gen.writeBinary($L);\n", (Object[])new Object[]{value});
            case KnownType.KnownTypesEnum.UUID -> CodeBlock.of((String)"_gen.writeString($L.toString());\n", (Object[])new Object[]{value});
        };
    }
}

