/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.annotation.processor.writer;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.common.naming.NameConverter;
import ru.tinkoff.kora.json.annotation.processor.JsonTypes;
import ru.tinkoff.kora.json.annotation.processor.KnownType;
import ru.tinkoff.kora.json.annotation.processor.writer.JsonClassWriterMeta;
import ru.tinkoff.kora.json.annotation.processor.writer.WriterFieldType;

public class WriterTypeMetaParser {
    private final ProcessingEnvironment env;
    private final Elements elements;
    private final Types types;
    private final KnownType knownTypes;
    private final TypeMirror jsonFieldAnnotation;

    public WriterTypeMetaParser(ProcessingEnvironment env, KnownType knownTypes) {
        this.env = env;
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.knownTypes = knownTypes;
        TypeElement jsonFieldElement = this.elements.getTypeElement(JsonTypes.jsonFieldAnnotation.canonicalName());
        this.jsonFieldAnnotation = jsonFieldElement.asType();
    }

    public JsonClassWriterMeta parse(TypeElement jsonClass, TypeMirror typeMirror) {
        if (jsonClass.getKind() != ElementKind.CLASS && jsonClass.getKind() != ElementKind.RECORD) {
            throw new IllegalArgumentException("Should not be called for non classes");
        }
        if (jsonClass.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new IllegalArgumentException("Should not be called for abstract classes");
        }
        List<VariableElement> fieldElements = this.parseFields(jsonClass);
        ArrayList<JsonClassWriterMeta.FieldMeta> fieldMetas = new ArrayList<JsonClassWriterMeta.FieldMeta>(fieldElements.size());
        for (VariableElement fieldElement : fieldElements) {
            JsonClassWriterMeta.FieldMeta fieldMeta = this.parseField(jsonClass, fieldElement);
            fieldMetas.add(fieldMeta);
        }
        return new JsonClassWriterMeta(typeMirror, jsonClass, fieldMetas);
    }

    private List<VariableElement> parseFields(TypeElement typeElement) {
        return typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).filter(e -> !e.getModifiers().contains((Object)Modifier.STATIC)).map(VariableElement.class::cast).filter(v -> AnnotationUtils.findAnnotation((Element)v, (ClassName)JsonTypes.jsonSkipAnnotation) == null).collect(Collectors.toList());
    }

    private JsonClassWriterMeta.FieldMeta parseField(TypeElement jsonClass, VariableElement field) {
        AnnotationMirror jsonField = this.findJsonField(field);
        NameConverter fieldNameConverter = CommonUtils.getNameConverter((TypeElement)jsonClass);
        TypeMirror fieldTypeMirror = field.asType();
        String jsonName = this.parseJsonName(field, jsonField, fieldNameConverter);
        ExecutableElement accessorMethod = this.getAccessorMethod(jsonClass, field);
        TypeMirror writer = (TypeMirror)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)jsonField, (String)"writer");
        WriterFieldType typeMeta = this.parseWriterFieldType(fieldTypeMirror);
        JsonClassWriterMeta.IncludeType includeType = Optional.ofNullable(AnnotationUtils.findAnnotation((Element)field, (ClassName)JsonTypes.jsonInclude)).or(() -> Optional.ofNullable(AnnotationUtils.findAnnotation((Element)jsonClass, (ClassName)JsonTypes.jsonInclude))).map(a -> ((VariableElement)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)a, (String)"value")).getSimpleName().toString()).flatMap(JsonClassWriterMeta.IncludeType::tryParse).orElse(JsonClassWriterMeta.IncludeType.NON_NULL);
        return new JsonClassWriterMeta.FieldMeta(field, fieldTypeMirror, typeMeta, jsonName, includeType, accessorMethod, writer);
    }

    private WriterFieldType parseWriterFieldType(TypeMirror typeMirror) {
        KnownType.KnownTypesEnum knownType = this.knownTypes.detect(typeMirror);
        if (knownType != null) {
            return new WriterFieldType.KnownWriterFieldType(knownType);
        }
        return new WriterFieldType.UnknownWriterFieldType(TypeName.get((TypeMirror)typeMirror));
    }

    @Nullable
    private AnnotationMirror findJsonField(VariableElement param) {
        return param.getAnnotationMirrors().stream().filter(a -> this.types.isSameType(a.getAnnotationType(), this.jsonFieldAnnotation)).findFirst().orElse(null);
    }

    private String parseJsonName(VariableElement param, @Nullable AnnotationMirror jsonField, @Nullable NameConverter nameConverter) {
        if (jsonField == null) {
            if (nameConverter != null) {
                return nameConverter.convert(param.getSimpleName().toString());
            }
            return param.getSimpleName().toString();
        }
        String jsonFieldValue = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)jsonField, (String)"value");
        if (jsonFieldValue != null && !jsonFieldValue.isBlank()) {
            return jsonFieldValue;
        }
        return param.getSimpleName().toString();
    }

    private ExecutableElement getAccessorMethod(TypeElement jsonClass, VariableElement param) {
        String paramName = param.getSimpleName().toString();
        String capitalizedParamName = Character.toUpperCase(paramName.charAt(0)) + paramName.substring(1);
        Optional<ExecutableElement> accessorMethodName = jsonClass.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(e -> e.getParameters().isEmpty()).filter(e -> {
            String methodName = e.getSimpleName().toString();
            return methodName.equals(paramName) || methodName.equals("get" + capitalizedParamName);
        }).filter(e -> this.types.isSameType(e.getReturnType(), param.asType())).findFirst();
        if (accessorMethodName.isPresent()) {
            return accessorMethodName.get();
        }
        throw new ProcessingErrorException("Can't detect accessor method name: %s".formatted(paramName), (Element)param);
    }
}

