/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import ru.tinkoff.kora.json.common.JsonReader;

public final class EnumJsonReader<T extends Enum<T>, V>
implements JsonReader<T> {
    private final Map<V, T> values = new HashMap<V, T>();
    private final JsonReader<V> valueReader;

    public EnumJsonReader(T[] values, Function<T, V> mapper, JsonReader<V> valueReader) {
        for (T value : values) {
            this.values.put(mapper.apply(value), value);
        }
        this.valueReader = valueReader;
    }

    @Override
    @Nullable
    public T read(JsonParser parser) throws IOException {
        V jsonValue = this.valueReader.read(parser);
        if (jsonValue == null) {
            return null;
        }
        Enum value = (Enum)this.values.get(jsonValue);
        if (value == null) {
            throw new JsonParseException(parser, "Expecting one of " + this.values.keySet() + ", got " + jsonValue);
        }
        return (T)value;
    }
}

