/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.json.common.JsonObjectCodec;
import ru.tinkoff.kora.json.common.JsonReader;
import ru.tinkoff.kora.json.common.JsonWriter;
import ru.tinkoff.kora.json.common.KoraDateTimeFormatters;
import ru.tinkoff.kora.json.common.ListJsonReader;
import ru.tinkoff.kora.json.common.ListJsonWriter;
import ru.tinkoff.kora.json.common.MapJsonReader;
import ru.tinkoff.kora.json.common.MapJsonWriter;
import ru.tinkoff.kora.json.common.RawJson;
import ru.tinkoff.kora.json.common.RawJsonWriter;
import ru.tinkoff.kora.json.common.SetJsonReader;
import ru.tinkoff.kora.json.common.SetJsonWriter;
import ru.tinkoff.kora.json.common.SortedSetJsonReader;
import ru.tinkoff.kora.json.common.UuidJsonCodec;

public interface JsonCommonModule {
    public static final JsonFactory JSON_FACTORY = new JsonFactory((JsonFactoryBuilder)new JsonFactoryBuilder().disable(JsonFactory.Feature.INTERN_FIELD_NAMES));

    @DefaultComponent
    default public JsonWriter<Object> objectJsonWriter() {
        return JsonObjectCodec::write;
    }

    @DefaultComponent
    default public JsonReader<Object> objectJsonReader() {
        return JsonObjectCodec::parse;
    }

    default public <T> JsonWriter<List<T>> listJsonWriterFactory(JsonWriter<T> writer) {
        return new ListJsonWriter<T>(writer);
    }

    default public <T> JsonReader<List<T>> listJsonReaderFactory(JsonReader<T> reader) {
        return new ListJsonReader<T>(reader);
    }

    default public <T> JsonWriter<Map<String, T>> mapJsonWriterFactory(JsonWriter<T> writer) {
        return new MapJsonWriter<T>(writer);
    }

    default public <T> JsonReader<Map<String, T>> mapJsonReaderFactory(JsonReader<T> reader) {
        return new MapJsonReader<T>(reader);
    }

    default public <T> JsonWriter<Set<T>> setJsonWriterFactory(JsonWriter<T> writer) {
        return new SetJsonWriter<T>(writer);
    }

    default public <T> JsonReader<Set<T>> setJsonReaderFactory(JsonReader<T> reader) {
        return new SetJsonReader<T>(reader);
    }

    default public <T extends Comparable<T>> JsonReader<SortedSet<T>> sortedSetJsonReaderFactory(JsonReader<T> reader) {
        return new SortedSetJsonReader<T>(reader);
    }

    default public JsonWriter<Integer> integerJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeNumber(object.intValue());
            }
        };
    }

    default public JsonReader<Integer> integerJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_NUMBER_INT -> parser.getIntValue();
            default -> throw new JsonParseException(parser, "Expecting VALUE_NUMBER_INT token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<LocalDate> localDateJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.format(DateTimeFormatter.ISO_DATE));
            }
        };
    }

    @DefaultComponent
    default public JsonReader<LocalDate> localDateJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> LocalDate.parse(parser.getValueAsString(), DateTimeFormatter.ISO_DATE);
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<LocalTime> localTimeJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.format(KoraDateTimeFormatters.ISO_LOCAL_TIME));
            }
        };
    }

    @DefaultComponent
    default public JsonReader<LocalTime> localTimeJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> LocalTime.parse(parser.getValueAsString(), DateTimeFormatter.ISO_LOCAL_TIME);
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<LocalDateTime> localDateTimeJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.format(KoraDateTimeFormatters.ISO_LOCAL_DATE_TIME));
            }
        };
    }

    @DefaultComponent
    default public JsonReader<LocalDateTime> localDateTimeJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> LocalDateTime.parse(parser.getValueAsString(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<OffsetTime> offsetTimeJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.format(KoraDateTimeFormatters.ISO_OFFSET_TIME));
            }
        };
    }

    @DefaultComponent
    default public JsonReader<OffsetTime> offsetTimeJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> OffsetTime.parse(parser.getValueAsString(), DateTimeFormatter.ISO_OFFSET_TIME);
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<OffsetDateTime> offsetDateTimeJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.format(KoraDateTimeFormatters.ISO_OFFSET_DATE_TIME));
            }
        };
    }

    @DefaultComponent
    default public JsonReader<OffsetDateTime> offsetDateTimeJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> OffsetDateTime.parse(parser.getValueAsString(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<ZonedDateTime> zonedDateTimeJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.format(KoraDateTimeFormatters.ISO_ZONED_DATE_TIME));
            }
        };
    }

    @DefaultComponent
    default public JsonReader<ZonedDateTime> zonedDateTimeJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> ZonedDateTime.parse(parser.getValueAsString(), DateTimeFormatter.ISO_ZONED_DATE_TIME);
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<Instant> instantJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(DateTimeFormatter.ISO_INSTANT.format((TemporalAccessor)object));
            }
        };
    }

    @DefaultComponent
    default public JsonReader<Instant> instantJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> DateTimeFormatter.ISO_INSTANT.parse(parser.getValueAsString()).query(Instant::from);
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<Year> yearJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.format(KoraDateTimeFormatters.ISO_YEAR));
            }
        };
    }

    @DefaultComponent
    default public JsonReader<Year> yearJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> Year.parse(parser.getValueAsString(), KoraDateTimeFormatters.ISO_YEAR);
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<YearMonth> yearMonthJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.format(KoraDateTimeFormatters.ISO_YEAR_MONTH));
            }
        };
    }

    @DefaultComponent
    default public JsonReader<YearMonth> yearMonthJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> YearMonth.parse(parser.getValueAsString(), KoraDateTimeFormatters.ISO_YEAR_MONTH);
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<MonthDay> monthDayJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.format(KoraDateTimeFormatters.ISO_MONTH_DAY));
            }
        };
    }

    @DefaultComponent
    default public JsonReader<MonthDay> monthDayJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> MonthDay.parse(parser.getValueAsString(), KoraDateTimeFormatters.ISO_MONTH_DAY);
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<Month> monthJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.name());
            }
        };
    }

    @DefaultComponent
    default public JsonReader<Month> monthJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> {
                String valueAsString = parser.getValueAsString();
                for (Month month : KoraDateTimeFormatters.MONTHS) {
                    if (!month.name().equalsIgnoreCase(valueAsString)) continue;
                    yield month;
                }
                yield Month.of(Integer.parseInt(valueAsString));
            }
            case JsonToken.VALUE_NUMBER_INT -> Month.of(parser.getValueAsInt());
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING or VALUE_NUMBER_INT token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<DayOfWeek> dayOfWeekJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.name());
            }
        };
    }

    @DefaultComponent
    default public JsonReader<DayOfWeek> dayOfWeekJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> {
                String valueAsString = parser.getValueAsString();
                for (DayOfWeek dayOfWeek : KoraDateTimeFormatters.DAY_OF_WEEKS) {
                    if (!dayOfWeek.name().equalsIgnoreCase(valueAsString)) continue;
                    yield dayOfWeek;
                }
                yield DayOfWeek.of(Integer.parseInt(valueAsString));
            }
            case JsonToken.VALUE_NUMBER_INT -> DayOfWeek.of(parser.getValueAsInt());
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING or VALUE_NUMBER_INT token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<ZoneId> zoneIdJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.getId());
            }
        };
    }

    @DefaultComponent
    default public JsonReader<ZoneId> zoneIdJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> ZoneId.of(parser.getValueAsString());
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    @DefaultComponent
    default public JsonWriter<Duration> durationJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object.toString());
            }
        };
    }

    @DefaultComponent
    default public JsonReader<Duration> durationJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> Duration.parse(parser.getValueAsString());
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    default public JsonWriter<Long> longJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeNumber(object.longValue());
            }
        };
    }

    default public JsonReader<Long> longJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_NUMBER_INT -> parser.getLongValue();
            default -> throw new JsonParseException(parser, "Expecting VALUE_NUMBER_INT token, got " + parser.currentToken());
        };
    }

    default public JsonWriter<Double> doubleJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeNumber(object.doubleValue());
            }
        };
    }

    default public JsonReader<Double> doubleJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT -> parser.getDoubleValue();
            default -> throw new JsonParseException(parser, "Expecting VALUE_NUMBER_FLOAT or VALUE_NUMBER_INT token, got " + parser.currentToken());
        };
    }

    default public JsonWriter<String> stringJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeString(object);
            }
        };
    }

    default public JsonReader<String> stringJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_STRING -> parser.getText();
            default -> throw new JsonParseException(parser, "Expecting VALUE_STRING token, got " + parser.currentToken());
        };
    }

    default public JsonWriter<Boolean> booleanJsonWriter() {
        return (gen, object) -> {
            if (object == null) {
                gen.writeNull();
            } else {
                gen.writeBoolean(object.booleanValue());
            }
        };
    }

    default public JsonReader<Boolean> booleanJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_TRUE -> true;
            case JsonToken.VALUE_FALSE -> false;
            default -> throw new JsonParseException(parser, "Expecting VALUE_TRUE or VALUE_FALSE token, got " + parser.currentToken());
        };
    }

    default public JsonWriter<BigDecimal> bigDecimalJsonWriter() {
        return (gen, bigDecimal) -> {
            if (bigDecimal == null) {
                gen.writeNull();
            } else {
                gen.writeNumber(bigDecimal);
            }
        };
    }

    default public JsonReader<BigDecimal> bigDecimalJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT -> parser.getDecimalValue();
            default -> throw new JsonParseException(parser, "Expecting VALUE_NUMBER_FLOAT or VALUE_NUMBER_INT token, got " + parser.currentToken());
        };
    }

    default public JsonWriter<BigInteger> bigIntegerJsonWriter() {
        return (gen, bigDecimal) -> {
            if (bigDecimal == null) {
                gen.writeNull();
            } else {
                gen.writeNumber(bigDecimal);
            }
        };
    }

    default public JsonReader<BigInteger> bigIntegerJsonReader() {
        return parser -> switch (parser.currentToken()) {
            case JsonToken.VALUE_NULL -> null;
            case JsonToken.VALUE_NUMBER_INT -> parser.getBigIntegerValue();
            default -> throw new JsonParseException(parser, "Expecting VALUE_NUMBER_INT token, got " + parser.currentToken());
        };
    }

    default public JsonWriter<RawJson> rawJsonWriter() {
        return new RawJsonWriter();
    }

    default public JsonReader<UUID> uuidJsonReader() {
        return new UuidJsonCodec();
    }

    default public JsonWriter<UUID> uuidJsonWriter() {
        return new UuidJsonCodec();
    }
}

