/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import ru.tinkoff.kora.json.common.JsonNullableUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface JsonNullable<T> {
    public boolean isDefined();

    default public boolean isNull() {
        return this.isDefined() && this.value() == null;
    }

    @Nullable
    public T value();

    public static <T> JsonNullable<T> undefined() {
        return JsonNullableUtil.UNDEFINED;
    }

    public static <T> JsonNullable<T> nullValue() {
        return JsonNullableUtil.NULL;
    }

    public static <T> JsonNullable<T> of(@Nonnull T value) {
        Objects.requireNonNull(value, "JsonNullable#of require non-null, but got null");
        return new Defined<T>(value);
    }

    public static <T> JsonNullable<T> ofNullable(@Nullable T value) {
        return value == null ? JsonNullable.nullValue() : new Defined<T>(value);
    }

    public record Defined<T>(@Nullable T value) implements JsonNullable<T>
    {
        @Override
        public boolean isDefined() {
            return true;
        }
    }

    public record Undefined<T>() implements JsonNullable<T>
    {
        @Override
        public boolean isDefined() {
            return false;
        }

        @Override
        @Nullable
        public T value() {
            throw new NullPointerException("JsonNullable is undefined");
        }
    }
}

