/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common;

import com.fasterxml.jackson.core.JsonGenerator;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Map;
import ru.tinkoff.kora.json.common.JsonWriter;

public class MapJsonWriter<T>
implements JsonWriter<Map<String, T>> {
    private final JsonWriter<T> writer;

    public MapJsonWriter(JsonWriter<T> writer) {
        this.writer = writer;
    }

    @Override
    public void write(JsonGenerator gen, @Nullable Map<String, T> object) throws IOException {
        if (object == null) {
            gen.writeNull();
            return;
        }
        gen.writeStartObject(object, object.size());
        for (Map.Entry<String, T> field : object.entrySet()) {
            gen.writeFieldName(field.getKey());
            this.writer.write(gen, field.getValue());
        }
        gen.writeEndObject();
    }
}

