/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.json.common;

import com.fasterxml.jackson.core.SerializableString;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class RawJson
implements SerializableString {
    public final byte[] value;
    private char[] valueChars;

    public RawJson(@Nonnull String value) {
        this.value = value.getBytes(StandardCharsets.UTF_8);
    }

    public RawJson(@Nonnull byte[] value) {
        this.value = value;
    }

    public byte[] value() {
        return this.value;
    }

    public String getValue() {
        return new String(this.value, StandardCharsets.UTF_8);
    }

    public int charLength() {
        return this.getValue().length();
    }

    public char[] asQuotedChars() {
        return this.getValue().toCharArray();
    }

    public byte[] asUnquotedUTF8() {
        return this.value;
    }

    public byte[] asQuotedUTF8() {
        throw new UnsupportedOperationException();
    }

    public int appendQuotedUTF8(byte[] buffer, int offset) {
        throw new UnsupportedOperationException();
    }

    public int appendQuoted(char[] buffer, int offset) {
        throw new UnsupportedOperationException();
    }

    public int appendUnquotedUTF8(byte[] buffer, int offset) {
        int length = this.value.length;
        if (offset + length > buffer.length) {
            return -1;
        }
        System.arraycopy(this.value, 0, buffer, offset, length);
        return length;
    }

    public int appendUnquoted(char[] buffer, int offset) {
        int length;
        if (this.valueChars == null) {
            this.valueChars = new String(this.value).toCharArray();
        }
        if (offset + (length = this.valueChars.length) > buffer.length) {
            return -1;
        }
        System.arraycopy(this.valueChars, 0, buffer, offset, length);
        return length;
    }

    public int writeQuotedUTF8(OutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int writeUnquotedUTF8(OutputStream out) throws IOException {
        out.write(this.value, 0, this.value.length);
        return this.value.length;
    }

    public int putQuotedUTF8(ByteBuffer buffer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int putUnquotedUTF8(ByteBuffer buffer) throws IOException {
        int length = this.value.length;
        if (length > buffer.remaining()) {
            return -1;
        }
        buffer.put(this.value, 0, length);
        return length;
    }
}

